import { tracingClient } from "./utils/tracing";
export class DataLakeLeaseClient {
    get leaseId() {
        return this.client.leaseId;
    }
    get url() {
        return this.client.url;
    }
    constructor(client) {
        this.client = client;
    }
    async acquireLease(duration, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-acquireLease", options, async (updatedOptions) => {
            return this.client.acquireLease(duration, updatedOptions);
        });
    }
    async changeLease(proposedLeaseId, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-changeLease", options, async (updatedOptions) => {
            return this.client.changeLease(proposedLeaseId, updatedOptions);
        });
    }
    async releaseLease(options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-releaseLease", options, async (updatedOptions) => {
            return this.client.releaseLease(updatedOptions);
        });
    }
    async renewLease(options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-renewLease", options, async (updatedOptions) => {
            return this.client.renewLease(updatedOptions);
        });
    }
    async breakLease(breakPeriod, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-renewLease", options, async (updatedOptions) => {
            return this.client.breakLease(breakPeriod, updatedOptions);
        });
    }
}
//# sourceMappingURL=DataLakeLeaseClient.js.map