// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { isNode } from "@azure/core-util";
import { StorageClient } from "./generated/src";
/**
 * @internal
 */
export class StorageContextClient extends StorageClient {
    async sendOperationRequest(operationArguments, operationSpec) {
        var _a;
        const operationSpecToSend = Object.assign({}, operationSpec);
        if (!isNode &&
            !operationSpec.requestBody &&
            ((_a = operationSpec.headerParameters) === null || _a === void 0 ? void 0 : _a.some((param) => param.mapper.serializedName === "Content-Length"))) {
            operationSpecToSend.mediaType = "text";
            operationSpecToSend.requestBody = {
                parameterPath: "body",
                mapper: {
                    serializedName: "body",
                    isConstant: true,
                    defaultValue: "",
                    type: {
                        name: "String",
                    },
                },
            };
        }
        if (operationSpecToSend.path === "/{filesystem}" ||
            operationSpecToSend.path === "/{filesystem}/{path}") {
            operationSpecToSend.path = "";
        }
        return super.sendOperationRequest(operationArguments, operationSpecToSend);
    }
}
//# sourceMappingURL=StorageContextClient.js.map