/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
export const FileSystemList = {
    serializedName: "FileSystemList",
    type: {
        name: "Composite",
        className: "FileSystemList",
        modelProperties: {
            filesystems: {
                serializedName: "filesystems",
                xmlName: "filesystems",
                xmlElementName: "FileSystem",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "FileSystem"
                        }
                    }
                }
            }
        }
    }
};
export const FileSystem = {
    serializedName: "FileSystem",
    type: {
        name: "Composite",
        className: "FileSystem",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "lastModified",
                xmlName: "lastModified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "eTag",
                xmlName: "eTag",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const StorageError = {
    serializedName: "StorageError",
    type: {
        name: "Composite",
        className: "StorageError",
        modelProperties: {
            error: {
                serializedName: "error",
                xmlName: "error",
                type: {
                    name: "Composite",
                    className: "StorageErrorError"
                }
            },
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String"
                }
            },
            authenticationErrorDetail: {
                serializedName: "AuthenticationErrorDetail",
                xmlName: "AuthenticationErrorDetail",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const StorageErrorError = {
    serializedName: "StorageErrorError",
    type: {
        name: "Composite",
        className: "StorageErrorError",
        modelProperties: {
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String"
                }
            },
            message: {
                serializedName: "Message",
                xmlName: "Message",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathList = {
    serializedName: "PathList",
    type: {
        name: "Composite",
        className: "PathList",
        modelProperties: {
            paths: {
                serializedName: "paths",
                xmlName: "paths",
                xmlElementName: "Path",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Path"
                        }
                    }
                }
            }
        }
    }
};
export const Path = {
    serializedName: "Path",
    type: {
        name: "Composite",
        className: "Path",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            isDirectory: {
                defaultValue: false,
                serializedName: "isDirectory",
                xmlName: "isDirectory",
                type: {
                    name: "Boolean"
                }
            },
            lastModified: {
                serializedName: "lastModified",
                xmlName: "lastModified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "eTag",
                xmlName: "eTag",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "contentLength",
                xmlName: "contentLength",
                type: {
                    name: "Number"
                }
            },
            owner: {
                serializedName: "owner",
                xmlName: "owner",
                type: {
                    name: "String"
                }
            },
            group: {
                serializedName: "group",
                xmlName: "group",
                type: {
                    name: "String"
                }
            },
            permissions: {
                serializedName: "permissions",
                xmlName: "permissions",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "EncryptionScope",
                xmlName: "EncryptionScope",
                type: {
                    name: "String"
                }
            },
            creationTime: {
                serializedName: "creationTime",
                xmlName: "creationTime",
                type: {
                    name: "String"
                }
            },
            expiryTime: {
                serializedName: "expiryTime",
                xmlName: "expiryTime",
                type: {
                    name: "String"
                }
            },
            encryptionContext: {
                serializedName: "EncryptionContext",
                xmlName: "EncryptionContext",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const ListBlobsHierarchySegmentResponse = {
    serializedName: "ListBlobsHierarchySegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListBlobsHierarchySegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            containerName: {
                serializedName: "ContainerName",
                required: true,
                xmlName: "ContainerName",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String"
                }
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String"
                }
            },
            maxResults: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number"
                }
            },
            delimiter: {
                serializedName: "Delimiter",
                xmlName: "Delimiter",
                type: {
                    name: "String"
                }
            },
            segment: {
                serializedName: "Segment",
                xmlName: "Blobs",
                type: {
                    name: "Composite",
                    className: "BlobHierarchyListSegment"
                }
            },
            nextMarker: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const BlobHierarchyListSegment = {
    serializedName: "BlobHierarchyListSegment",
    xmlName: "Blobs",
    type: {
        name: "Composite",
        className: "BlobHierarchyListSegment",
        modelProperties: {
            blobPrefixes: {
                serializedName: "BlobPrefixes",
                xmlName: "BlobPrefixes",
                xmlElementName: "BlobPrefix",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobPrefix"
                        }
                    }
                }
            },
            blobItems: {
                serializedName: "BlobItems",
                required: true,
                xmlName: "BlobItems",
                xmlElementName: "Blob",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobItemModel"
                        }
                    }
                }
            }
        }
    }
};
export const BlobPrefix = {
    serializedName: "BlobPrefix",
    type: {
        name: "Composite",
        className: "BlobPrefix",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const BlobItemModel = {
    serializedName: "BlobItemModel",
    xmlName: "Blob",
    type: {
        name: "Composite",
        className: "BlobItemModel",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            deleted: {
                serializedName: "Deleted",
                required: true,
                xmlName: "Deleted",
                type: {
                    name: "Boolean"
                }
            },
            snapshot: {
                serializedName: "Snapshot",
                required: true,
                xmlName: "Snapshot",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "VersionId",
                xmlName: "VersionId",
                type: {
                    name: "String"
                }
            },
            isCurrentVersion: {
                serializedName: "IsCurrentVersion",
                xmlName: "IsCurrentVersion",
                type: {
                    name: "Boolean"
                }
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "BlobPropertiesModel"
                }
            },
            deletionId: {
                serializedName: "DeletionId",
                xmlName: "DeletionId",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const BlobPropertiesModel = {
    serializedName: "BlobPropertiesModel",
    xmlName: "Properties",
    type: {
        name: "Composite",
        className: "BlobPropertiesModel",
        modelProperties: {
            creationTime: {
                serializedName: "Creation-Time",
                xmlName: "Creation-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            lastModified: {
                serializedName: "Last-Modified",
                required: true,
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "Etag",
                required: true,
                xmlName: "Etag",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "Content-Length",
                xmlName: "Content-Length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "Content-Type",
                xmlName: "Content-Type",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "Content-Encoding",
                xmlName: "Content-Encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "Content-Language",
                xmlName: "Content-Language",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "Content-MD5",
                xmlName: "Content-MD5",
                type: {
                    name: "ByteArray"
                }
            },
            contentDisposition: {
                serializedName: "Content-Disposition",
                xmlName: "Content-Disposition",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "Cache-Control",
                xmlName: "Cache-Control",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            copyId: {
                serializedName: "CopyId",
                xmlName: "CopyId",
                type: {
                    name: "String"
                }
            },
            copySource: {
                serializedName: "CopySource",
                xmlName: "CopySource",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "CopyProgress",
                xmlName: "CopyProgress",
                type: {
                    name: "String"
                }
            },
            copyCompletionTime: {
                serializedName: "CopyCompletionTime",
                xmlName: "CopyCompletionTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "CopyStatusDescription",
                xmlName: "CopyStatusDescription",
                type: {
                    name: "String"
                }
            },
            serverEncrypted: {
                serializedName: "ServerEncrypted",
                xmlName: "ServerEncrypted",
                type: {
                    name: "Boolean"
                }
            },
            incrementalCopy: {
                serializedName: "IncrementalCopy",
                xmlName: "IncrementalCopy",
                type: {
                    name: "Boolean"
                }
            },
            destinationSnapshot: {
                serializedName: "DestinationSnapshot",
                xmlName: "DestinationSnapshot",
                type: {
                    name: "String"
                }
            },
            deletedTime: {
                serializedName: "DeletedTime",
                xmlName: "DeletedTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            remainingRetentionDays: {
                serializedName: "RemainingRetentionDays",
                xmlName: "RemainingRetentionDays",
                type: {
                    name: "Number"
                }
            },
            accessTierInferred: {
                serializedName: "AccessTierInferred",
                xmlName: "AccessTierInferred",
                type: {
                    name: "Boolean"
                }
            },
            customerProvidedKeySha256: {
                serializedName: "CustomerProvidedKeySha256",
                xmlName: "CustomerProvidedKeySha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "EncryptionScope",
                xmlName: "EncryptionScope",
                type: {
                    name: "String"
                }
            },
            accessTierChangeTime: {
                serializedName: "AccessTierChangeTime",
                xmlName: "AccessTierChangeTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            tagCount: {
                serializedName: "TagCount",
                xmlName: "TagCount",
                type: {
                    name: "Number"
                }
            },
            expiresOn: {
                serializedName: "Expiry-Time",
                xmlName: "Expiry-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            sealed: {
                serializedName: "Sealed",
                xmlName: "Sealed",
                type: {
                    name: "Boolean"
                }
            },
            lastAccessedOn: {
                serializedName: "LastAccessTime",
                xmlName: "LastAccessTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
export const SetAccessControlRecursiveResponse = {
    serializedName: "SetAccessControlRecursiveResponse",
    type: {
        name: "Composite",
        className: "SetAccessControlRecursiveResponse",
        modelProperties: {
            directoriesSuccessful: {
                serializedName: "directoriesSuccessful",
                xmlName: "directoriesSuccessful",
                type: {
                    name: "Number"
                }
            },
            filesSuccessful: {
                serializedName: "filesSuccessful",
                xmlName: "filesSuccessful",
                type: {
                    name: "Number"
                }
            },
            failureCount: {
                serializedName: "failureCount",
                xmlName: "failureCount",
                type: {
                    name: "Number"
                }
            },
            failedEntries: {
                serializedName: "failedEntries",
                xmlName: "failedEntries",
                xmlElementName: "AclFailedEntry",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "AclFailedEntry"
                        }
                    }
                }
            }
        }
    }
};
export const AclFailedEntry = {
    serializedName: "AclFailedEntry",
    type: {
        name: "Composite",
        className: "AclFailedEntry",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            type: {
                serializedName: "type",
                xmlName: "type",
                type: {
                    name: "String"
                }
            },
            errorMessage: {
                serializedName: "errorMessage",
                xmlName: "errorMessage",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const ServiceListFileSystemsHeaders = {
    serializedName: "Service_listFileSystemsHeaders",
    type: {
        name: "Composite",
        className: "ServiceListFileSystemsHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const ServiceListFileSystemsExceptionHeaders = {
    serializedName: "Service_listFileSystemsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceListFileSystemsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemCreateHeaders = {
    serializedName: "FileSystem_createHeaders",
    type: {
        name: "Composite",
        className: "FileSystemCreateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            namespaceEnabled: {
                serializedName: "x-ms-namespace-enabled",
                xmlName: "x-ms-namespace-enabled",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemCreateExceptionHeaders = {
    serializedName: "FileSystem_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemSetPropertiesHeaders = {
    serializedName: "FileSystem_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "FileSystemSetPropertiesHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemSetPropertiesExceptionHeaders = {
    serializedName: "FileSystem_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemGetPropertiesHeaders = {
    serializedName: "FileSystem_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "FileSystemGetPropertiesHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            namespaceEnabled: {
                serializedName: "x-ms-namespace-enabled",
                xmlName: "x-ms-namespace-enabled",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemGetPropertiesExceptionHeaders = {
    serializedName: "FileSystem_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemDeleteHeaders = {
    serializedName: "FileSystem_deleteHeaders",
    type: {
        name: "Composite",
        className: "FileSystemDeleteHeaders",
        modelProperties: {
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
export const FileSystemDeleteExceptionHeaders = {
    serializedName: "FileSystem_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemListPathsHeaders = {
    serializedName: "FileSystem_listPathsHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListPathsHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemListPathsExceptionHeaders = {
    serializedName: "FileSystem_listPathsExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListPathsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemListBlobHierarchySegmentHeaders = {
    serializedName: "FileSystem_listBlobHierarchySegmentHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListBlobHierarchySegmentHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const FileSystemListBlobHierarchySegmentExceptionHeaders = {
    serializedName: "FileSystem_listBlobHierarchySegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListBlobHierarchySegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathCreateHeaders = {
    serializedName: "Path_createHeaders",
    type: {
        name: "Composite",
        className: "PathCreateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathCreateExceptionHeaders = {
    serializedName: "Path_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathUpdateHeaders = {
    serializedName: "Path_updateHeaders",
    type: {
        name: "Composite",
        className: "PathUpdateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            xMsContinuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathUpdateExceptionHeaders = {
    serializedName: "Path_updateExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathUpdateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathLeaseHeaders = {
    serializedName: "Path_leaseHeaders",
    type: {
        name: "Composite",
        className: "PathLeaseHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            leaseId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathLeaseExceptionHeaders = {
    serializedName: "Path_leaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathReadHeaders = {
    serializedName: "Path_readHeaders",
    type: {
        name: "Composite",
        className: "PathReadHeaders",
        modelProperties: {
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "String"
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "String"
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "String"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathReadExceptionHeaders = {
    serializedName: "Path_readExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathReadExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathGetPropertiesHeaders = {
    serializedName: "Path_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "PathGetPropertiesHeaders",
        modelProperties: {
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String"
                }
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String"
                }
            },
            permissions: {
                serializedName: "x-ms-permissions",
                xmlName: "x-ms-permissions",
                type: {
                    name: "String"
                }
            },
            acl: {
                serializedName: "x-ms-acl",
                xmlName: "x-ms-acl",
                type: {
                    name: "String"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "String"
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "String"
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathGetPropertiesExceptionHeaders = {
    serializedName: "Path_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathDeleteHeaders = {
    serializedName: "Path_deleteHeaders",
    type: {
        name: "Composite",
        className: "PathDeleteHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            deletionId: {
                serializedName: "x-ms-deletion-id",
                xmlName: "x-ms-deletion-id",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathDeleteExceptionHeaders = {
    serializedName: "Path_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetAccessControlHeaders = {
    serializedName: "Path_setAccessControlHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetAccessControlExceptionHeaders = {
    serializedName: "Path_setAccessControlExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetAccessControlRecursiveHeaders = {
    serializedName: "Path_setAccessControlRecursiveHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlRecursiveHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetAccessControlRecursiveExceptionHeaders = {
    serializedName: "Path_setAccessControlRecursiveExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlRecursiveExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathFlushDataHeaders = {
    serializedName: "Path_flushDataHeaders",
    type: {
        name: "Composite",
        className: "PathFlushDataHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            leaseRenewed: {
                serializedName: "x-ms-lease-renewed",
                xmlName: "x-ms-lease-renewed",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
export const PathFlushDataExceptionHeaders = {
    serializedName: "Path_flushDataExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathFlushDataExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathAppendDataHeaders = {
    serializedName: "Path_appendDataHeaders",
    type: {
        name: "Composite",
        className: "PathAppendDataHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            leaseRenewed: {
                serializedName: "x-ms-lease-renewed",
                xmlName: "x-ms-lease-renewed",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
export const PathAppendDataExceptionHeaders = {
    serializedName: "Path_appendDataExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathAppendDataExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetExpiryHeaders = {
    serializedName: "Path_setExpiryHeaders",
    type: {
        name: "Composite",
        className: "PathSetExpiryHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathSetExpiryExceptionHeaders = {
    serializedName: "Path_setExpiryExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetExpiryExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
export const PathUndeleteHeaders = {
    serializedName: "Path_undeleteHeaders",
    type: {
        name: "Composite",
        className: "PathUndeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
export const PathUndeleteExceptionHeaders = {
    serializedName: "Path_undeleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathUndeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
//# sourceMappingURL=mappers.js.map