/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
export const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
export const resource = {
    parameterPath: "resource",
    mapper: {
        defaultValue: "account",
        isConstant: true,
        serializedName: "resource",
        type: {
            name: "String"
        }
    }
};
export const prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String"
        }
    }
};
export const continuation = {
    parameterPath: ["options", "continuation"],
    mapper: {
        serializedName: "continuation",
        xmlName: "continuation",
        type: {
            name: "String"
        }
    }
};
export const maxResults = {
    parameterPath: ["options", "maxResults"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxResults",
        xmlName: "maxResults",
        type: {
            name: "Number"
        }
    }
};
export const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
export const timeout = {
    parameterPath: ["options", "timeout"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
export const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2025-05-05",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
export const resource1 = {
    parameterPath: "resource",
    mapper: {
        defaultValue: "filesystem",
        isConstant: true,
        serializedName: "resource",
        type: {
            name: "String"
        }
    }
};
export const properties = {
    parameterPath: ["options", "properties"],
    mapper: {
        serializedName: "x-ms-properties",
        xmlName: "x-ms-properties",
        type: {
            name: "String"
        }
    }
};
export const ifModifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifModifiedSince"],
    mapper: {
        serializedName: "If-Modified-Since",
        xmlName: "If-Modified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
export const ifUnmodifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifUnmodifiedSince"],
    mapper: {
        serializedName: "If-Unmodified-Since",
        xmlName: "If-Unmodified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
export const path = {
    parameterPath: ["options", "path"],
    mapper: {
        serializedName: "directory",
        xmlName: "directory",
        type: {
            name: "String"
        }
    }
};
export const recursive = {
    parameterPath: "recursive",
    mapper: {
        serializedName: "recursive",
        required: true,
        xmlName: "recursive",
        type: {
            name: "Boolean"
        }
    }
};
export const upn = {
    parameterPath: ["options", "upn"],
    mapper: {
        serializedName: "upn",
        xmlName: "upn",
        type: {
            name: "Boolean"
        }
    }
};
export const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "container",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
export const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const delimiter = {
    parameterPath: ["options", "delimiter"],
    mapper: {
        serializedName: "delimiter",
        xmlName: "delimiter",
        type: {
            name: "String"
        }
    }
};
export const marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String"
        }
    }
};
export const include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListBlobsIncludeItem",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: [
                        "copy",
                        "deleted",
                        "metadata",
                        "snapshots",
                        "uncommittedblobs",
                        "versions",
                        "tags"
                    ]
                }
            }
        }
    },
    collectionFormat: "CSV"
};
export const showonly = {
    parameterPath: ["options", "showonly"],
    mapper: {
        defaultValue: "deleted",
        isConstant: true,
        serializedName: "showonly",
        type: {
            name: "String"
        }
    }
};
export const resource2 = {
    parameterPath: ["options", "resource"],
    mapper: {
        serializedName: "resource",
        xmlName: "resource",
        type: {
            name: "Enum",
            allowedValues: ["directory", "file"]
        }
    }
};
export const mode = {
    parameterPath: ["options", "mode"],
    mapper: {
        serializedName: "mode",
        xmlName: "mode",
        type: {
            name: "Enum",
            allowedValues: ["legacy", "posix"]
        }
    }
};
export const cacheControl = {
    parameterPath: ["options", "pathHttpHeaders", "cacheControl"],
    mapper: {
        serializedName: "x-ms-cache-control",
        xmlName: "x-ms-cache-control",
        type: {
            name: "String"
        }
    }
};
export const contentEncoding = {
    parameterPath: ["options", "pathHttpHeaders", "contentEncoding"],
    mapper: {
        serializedName: "x-ms-content-encoding",
        xmlName: "x-ms-content-encoding",
        type: {
            name: "String"
        }
    }
};
export const contentLanguage = {
    parameterPath: ["options", "pathHttpHeaders", "contentLanguage"],
    mapper: {
        serializedName: "x-ms-content-language",
        xmlName: "x-ms-content-language",
        type: {
            name: "String"
        }
    }
};
export const contentDisposition = {
    parameterPath: ["options", "pathHttpHeaders", "contentDisposition"],
    mapper: {
        serializedName: "x-ms-content-disposition",
        xmlName: "x-ms-content-disposition",
        type: {
            name: "String"
        }
    }
};
export const contentType = {
    parameterPath: ["options", "pathHttpHeaders", "contentType"],
    mapper: {
        serializedName: "x-ms-content-type",
        xmlName: "x-ms-content-type",
        type: {
            name: "String"
        }
    }
};
export const renameSource = {
    parameterPath: ["options", "renameSource"],
    mapper: {
        serializedName: "x-ms-rename-source",
        xmlName: "x-ms-rename-source",
        type: {
            name: "String"
        }
    }
};
export const leaseId = {
    parameterPath: ["options", "leaseAccessConditions", "leaseId"],
    mapper: {
        serializedName: "x-ms-lease-id",
        xmlName: "x-ms-lease-id",
        type: {
            name: "String"
        }
    }
};
export const sourceLeaseId = {
    parameterPath: ["options", "sourceLeaseId"],
    mapper: {
        serializedName: "x-ms-source-lease-id",
        xmlName: "x-ms-source-lease-id",
        type: {
            name: "String"
        }
    }
};
export const permissions = {
    parameterPath: ["options", "permissions"],
    mapper: {
        serializedName: "x-ms-permissions",
        xmlName: "x-ms-permissions",
        type: {
            name: "String"
        }
    }
};
export const umask = {
    parameterPath: ["options", "umask"],
    mapper: {
        serializedName: "x-ms-umask",
        xmlName: "x-ms-umask",
        type: {
            name: "String"
        }
    }
};
export const ifMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifMatch"],
    mapper: {
        serializedName: "If-Match",
        xmlName: "If-Match",
        type: {
            name: "String"
        }
    }
};
export const ifNoneMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifNoneMatch"],
    mapper: {
        serializedName: "If-None-Match",
        xmlName: "If-None-Match",
        type: {
            name: "String"
        }
    }
};
export const sourceIfMatch = {
    parameterPath: ["options", "sourceModifiedAccessConditions", "sourceIfMatch"],
    mapper: {
        serializedName: "x-ms-source-if-match",
        xmlName: "x-ms-source-if-match",
        type: {
            name: "String"
        }
    }
};
export const sourceIfNoneMatch = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfNoneMatch"
    ],
    mapper: {
        serializedName: "x-ms-source-if-none-match",
        xmlName: "x-ms-source-if-none-match",
        type: {
            name: "String"
        }
    }
};
export const sourceIfModifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfModifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-modified-since",
        xmlName: "x-ms-source-if-modified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
export const sourceIfUnmodifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfUnmodifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-unmodified-since",
        xmlName: "x-ms-source-if-unmodified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
export const encryptionKey = {
    parameterPath: ["options", "cpkInfo", "encryptionKey"],
    mapper: {
        serializedName: "x-ms-encryption-key",
        xmlName: "x-ms-encryption-key",
        type: {
            name: "String"
        }
    }
};
export const encryptionKeySha256 = {
    parameterPath: ["options", "cpkInfo", "encryptionKeySha256"],
    mapper: {
        serializedName: "x-ms-encryption-key-sha256",
        xmlName: "x-ms-encryption-key-sha256",
        type: {
            name: "String"
        }
    }
};
export const encryptionAlgorithm = {
    parameterPath: ["options", "cpkInfo", "encryptionAlgorithm"],
    mapper: {
        serializedName: "x-ms-encryption-algorithm",
        xmlName: "x-ms-encryption-algorithm",
        type: {
            name: "String"
        }
    }
};
export const owner = {
    parameterPath: ["options", "owner"],
    mapper: {
        serializedName: "x-ms-owner",
        xmlName: "x-ms-owner",
        type: {
            name: "String"
        }
    }
};
export const group = {
    parameterPath: ["options", "group"],
    mapper: {
        serializedName: "x-ms-group",
        xmlName: "x-ms-group",
        type: {
            name: "String"
        }
    }
};
export const acl = {
    parameterPath: ["options", "acl"],
    mapper: {
        serializedName: "x-ms-acl",
        xmlName: "x-ms-acl",
        type: {
            name: "String"
        }
    }
};
export const proposedLeaseId = {
    parameterPath: ["options", "proposedLeaseId"],
    mapper: {
        serializedName: "x-ms-proposed-lease-id",
        xmlName: "x-ms-proposed-lease-id",
        type: {
            name: "String"
        }
    }
};
export const leaseDuration = {
    parameterPath: ["options", "leaseDuration"],
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number"
        }
    }
};
export const expiryOptions = {
    parameterPath: ["options", "expiryOptions"],
    mapper: {
        serializedName: "x-ms-expiry-option",
        xmlName: "x-ms-expiry-option",
        type: {
            name: "Enum",
            allowedValues: [
                "NeverExpire",
                "RelativeToCreation",
                "RelativeToNow",
                "Absolute"
            ]
        }
    }
};
export const expiresOn = {
    parameterPath: ["options", "expiresOn"],
    mapper: {
        serializedName: "x-ms-expiry-time",
        xmlName: "x-ms-expiry-time",
        type: {
            name: "String"
        }
    }
};
export const encryptionContext = {
    parameterPath: ["options", "encryptionContext"],
    mapper: {
        serializedName: "x-ms-encryption-context",
        xmlName: "x-ms-encryption-context",
        type: {
            name: "String"
        }
    }
};
export const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/octet-stream",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const body = {
    parameterPath: "body",
    mapper: {
        serializedName: "body",
        required: true,
        xmlName: "body",
        type: {
            name: "Stream"
        }
    }
};
export const accept2 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
export const action = {
    parameterPath: "action",
    mapper: {
        serializedName: "action",
        required: true,
        xmlName: "action",
        type: {
            name: "Enum",
            allowedValues: [
                "append",
                "flush",
                "setProperties",
                "setAccessControl",
                "setAccessControlRecursive"
            ]
        }
    }
};
export const maxRecords = {
    parameterPath: ["options", "maxRecords"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxRecords",
        xmlName: "maxRecords",
        type: {
            name: "Number"
        }
    }
};
export const mode1 = {
    parameterPath: "mode",
    mapper: {
        serializedName: "mode",
        required: true,
        xmlName: "mode",
        type: {
            name: "Enum",
            allowedValues: ["set", "modify", "remove"]
        }
    }
};
export const forceFlag = {
    parameterPath: ["options", "forceFlag"],
    mapper: {
        serializedName: "forceFlag",
        xmlName: "forceFlag",
        type: {
            name: "Boolean"
        }
    }
};
export const position = {
    parameterPath: ["options", "position"],
    mapper: {
        serializedName: "position",
        xmlName: "position",
        type: {
            name: "Number"
        }
    }
};
export const retainUncommittedData = {
    parameterPath: ["options", "retainUncommittedData"],
    mapper: {
        serializedName: "retainUncommittedData",
        xmlName: "retainUncommittedData",
        type: {
            name: "Boolean"
        }
    }
};
export const close = {
    parameterPath: ["options", "close"],
    mapper: {
        serializedName: "close",
        xmlName: "close",
        type: {
            name: "Boolean"
        }
    }
};
export const contentLength = {
    parameterPath: ["options", "contentLength"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "Content-Length",
        xmlName: "Content-Length",
        type: {
            name: "Number"
        }
    }
};
export const contentMD5 = {
    parameterPath: ["options", "pathHttpHeaders", "contentMD5"],
    mapper: {
        serializedName: "x-ms-content-md5",
        xmlName: "x-ms-content-md5",
        type: {
            name: "ByteArray"
        }
    }
};
export const xMsLeaseAction = {
    parameterPath: "xMsLeaseAction",
    mapper: {
        serializedName: "x-ms-lease-action",
        required: true,
        xmlName: "x-ms-lease-action",
        type: {
            name: "Enum",
            allowedValues: ["acquire", "break", "change", "renew", "release"]
        }
    }
};
export const xMsLeaseDuration = {
    parameterPath: "xMsLeaseDuration",
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number"
        }
    }
};
export const xMsLeaseBreakPeriod = {
    parameterPath: ["options", "xMsLeaseBreakPeriod"],
    mapper: {
        serializedName: "x-ms-lease-break-period",
        xmlName: "x-ms-lease-break-period",
        type: {
            name: "Number"
        }
    }
};
export const range = {
    parameterPath: ["options", "range"],
    mapper: {
        serializedName: "Range",
        xmlName: "Range",
        type: {
            name: "String"
        }
    }
};
export const xMsRangeGetContentMd5 = {
    parameterPath: ["options", "xMsRangeGetContentMd5"],
    mapper: {
        serializedName: "x-ms-range-get-content-md5",
        xmlName: "x-ms-range-get-content-md5",
        type: {
            name: "Boolean"
        }
    }
};
export const action1 = {
    parameterPath: ["options", "action"],
    mapper: {
        serializedName: "action",
        xmlName: "action",
        type: {
            name: "Enum",
            allowedValues: ["getAccessControl", "getStatus"]
        }
    }
};
export const recursive1 = {
    parameterPath: ["options", "recursive"],
    mapper: {
        serializedName: "recursive",
        xmlName: "recursive",
        type: {
            name: "Boolean"
        }
    }
};
export const paginated = {
    parameterPath: ["options", "paginated"],
    mapper: {
        serializedName: "paginated",
        xmlName: "paginated",
        type: {
            name: "Boolean"
        }
    }
};
export const action2 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "setAccessControl",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
export const action3 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "setAccessControlRecursive",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
export const action4 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "flush",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
export const leaseAction = {
    parameterPath: ["options", "leaseAction"],
    mapper: {
        serializedName: "x-ms-lease-action",
        xmlName: "x-ms-lease-action",
        type: {
            name: "Enum",
            allowedValues: ["acquire", "auto-renew", "release", "acquire-release"]
        }
    }
};
export const contentType2 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
export const action5 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "append",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
export const transactionalContentHash = {
    parameterPath: ["options", "pathHttpHeaders", "transactionalContentHash"],
    mapper: {
        serializedName: "Content-MD5",
        xmlName: "Content-MD5",
        type: {
            name: "ByteArray"
        }
    }
};
export const transactionalContentCrc64 = {
    parameterPath: ["options", "transactionalContentCrc64"],
    mapper: {
        serializedName: "x-ms-content-crc64",
        xmlName: "x-ms-content-crc64",
        type: {
            name: "ByteArray"
        }
    }
};
export const flush = {
    parameterPath: ["options", "flush"],
    mapper: {
        serializedName: "flush",
        xmlName: "flush",
        type: {
            name: "Boolean"
        }
    }
};
export const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "expiry",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const expiryOptions1 = {
    parameterPath: "expiryOptions",
    mapper: {
        serializedName: "x-ms-expiry-option",
        required: true,
        xmlName: "x-ms-expiry-option",
        type: {
            name: "Enum",
            allowedValues: [
                "NeverExpire",
                "RelativeToCreation",
                "RelativeToNow",
                "Absolute"
            ]
        }
    }
};
export const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "undelete",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
export const undeleteSource = {
    parameterPath: ["options", "undeleteSource"],
    mapper: {
        serializedName: "x-ms-undelete-source",
        xmlName: "x-ms-undelete-source",
        type: {
            name: "String"
        }
    }
};
//# sourceMappingURL=parameters.js.map