/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import * as coreClient from "@azure/core-client";
import * as Mappers from "../models/mappers";
import * as Parameters from "../models/parameters";
/** Class containing Service operations. */
export class ServiceImpl {
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * List filesystems and their properties in given account.
     * @param options The options parameters.
     */
    listFileSystems(options) {
        return this.client.sendOperationRequest({ options }, listFileSystemsOperationSpec);
    }
}
// Operation Specifications
const serializer = coreClient.createSerializer(Mappers, /* isXml */ false);
const listFileSystemsOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.FileSystemList,
            headersMapper: Mappers.ServiceListFileSystemsHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceListFileSystemsExceptionHeaders
        }
    },
    queryParameters: [
        Parameters.resource,
        Parameters.prefix,
        Parameters.continuation,
        Parameters.maxResults,
        Parameters.timeout
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.accept,
        Parameters.requestId,
        Parameters.version
    ],
    serializer
};
//# sourceMappingURL=service.js.map