// Keeping these for backward compatibility when we changed to use string unions.
/**
 * Defines values for PathGetPropertiesAction.
 * Possible values include: 'getAccessControl', 'getStatus'
 * @readonly
 */
export var PathGetPropertiesAction;
(function (PathGetPropertiesAction) {
    PathGetPropertiesAction["GetAccessControl"] = "getAccessControl";
    PathGetPropertiesAction["GetStatus"] = "getStatus";
})(PathGetPropertiesAction || (PathGetPropertiesAction = {}));
/**
 * Defines values for PathRenameMode.
 * Possible values include: 'legacy', 'posix'
 * @readonly
 */
export var PathRenameMode;
(function (PathRenameMode) {
    PathRenameMode["Legacy"] = "legacy";
    PathRenameMode["Posix"] = "posix";
})(PathRenameMode || (PathRenameMode = {}));
/**
 * Defines values for PathResourceType.
 * Possible values include: 'directory', 'file'
 * @readonly
 */
export var PathResourceType;
(function (PathResourceType) {
    PathResourceType["Directory"] = "directory";
    PathResourceType["File"] = "file";
})(PathResourceType || (PathResourceType = {}));
/**
 * Defines the known cloud audiences for Storage.
 */
export var StorageDataLakeAudience;
(function (StorageDataLakeAudience) {
    /**
     * The OAuth scope to use to retrieve an AAD token for Azure Storage.
     */
    StorageDataLakeAudience["StorageOAuthScopes"] = "https://storage.azure.com/.default";
})(StorageDataLakeAudience || (StorageDataLakeAudience = {}));
/**
 * To get OAuth audience for a storage account for datalake service.
 */
export function getDataLakeServiceAccountAudience(storageAccountName) {
    return `https://${storageAccountName}.dfs.core.windows.net/.default`;
}
/** *********************************************************/
/** DataLakeLeaseClient option and response related models */
/** *********************************************************/
//# sourceMappingURL=models.js.map