/**
 * An error thrown when an operation is interrupted and can be continued later on.
 */
export class DataLakeAclChangeFailedError extends Error {
    constructor(error, continuationToken) {
        super(error.message);
        this.name = "DataLakeAclChangeFailedError";
        this.innerError = error;
        this.continuationToken = continuationToken;
        Object.setPrototypeOf(this, DataLakeAclChangeFailedError.prototype);
    }
}
//# sourceMappingURL=DataLakeAclChangeFailedError.js.map