'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var coreRestPipeline = require('@azure/core-rest-pipeline');
var coreUtil = require('@azure/core-util');
var storageBlob = require('@azure/storage-blob');
var tslib = require('tslib');
var coreHttpCompat = require('@azure/core-http-compat');
var coreClient = require('@azure/core-client');
require('@azure/core-xml');
var coreAuth = require('@azure/core-auth');
var coreTracing = require('@azure/core-tracing');
var crypto = require('crypto');
var events = require('events');
var fs = require('fs');
var util = require('util');
var stream = require('stream');
var buffer = require('buffer');
var logger$1 = require('@azure/logger');

function _interopNamespaceDefault(e) {
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n.default = e;
    return Object.freeze(n);
}

var coreHttpCompat__namespace = /*#__PURE__*/_interopNamespaceDefault(coreHttpCompat);
var coreClient__namespace = /*#__PURE__*/_interopNamespaceDefault(coreClient);
var fs__namespace = /*#__PURE__*/_interopNamespaceDefault(fs);
var util__namespace = /*#__PURE__*/_interopNamespaceDefault(util);

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * The `@azure/logger` configuration for this package.
 */
const logger = logger$1.createClientLogger("storage-file-datalake");

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
const SDK_VERSION = "12.26.0";
const SERVICE_VERSION = "2025-05-05";
const KB = 1024;
const MB = KB * 1024;
const DEFAULT_HIGH_LEVEL_CONCURRENCY = 5;
const FILE_MAX_SINGLE_UPLOAD_THRESHOLD = 100 * MB;
const FILE_UPLOAD_MAX_CHUNK_SIZE = 4000 * MB;
const FILE_UPLOAD_DEFAULT_CHUNK_SIZE = 8 * MB;
const BLOCK_BLOB_MAX_BLOCKS = 50000;
const FILE_MAX_SIZE_BYTES = BLOCK_BLOB_MAX_BLOCKS * FILE_UPLOAD_MAX_CHUNK_SIZE;
/**
 * The OAuth scope to use with Azure Storage.
 */
const StorageOAuthScopes = "https://storage.azure.com/.default";
const DevelopmentConnectionString = `DefaultEndpointsProtocol=http;AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==;BlobEndpoint=http://127.0.0.1:10000/devstoreaccount1;`;
// Mapping pairs to transform url from dfs endpoint to blob endpoint
// Customize this value to add more mapping patterns
const ToBlobEndpointHostMappings = [
    ["dfs.preprod.core.windows.net", "blob.preprod.core.windows.net"],
    ["dfs.core.windows.net", "blob.core.windows.net"],
    ["dfs.core.chinacloudapi.cn", "blob.core.chinacloudapi.cn"],
    ["dfs.core.usgovcloudapi.net", "blob.core.usgovcloudapi.net"],
    ["dfs.core.cloudapi.de", "blob.core.cloudapi.de"],
    ["dfs.core.microsoft.scloud", "blob.core.microsoft.scloud"],
    ["dfs.core.eaglex.ic.gov", "blob.core.eaglex.ic.gov"],
    ["dfs.storage.azure.net", "blob.storage.azure.net"],
];
// Mapping pairs to transform url from blob endpoint to dfs endpoint
// Customize this value to add more mapping patterns
const ToDfsEndpointHostMappings = [
    ["blob.preprod.core.windows.net", "dfs.preprod.core.windows.net"],
    ["blob.core.windows.net", "dfs.core.windows.net"],
    ["blob.core.chinacloudapi.cn", "dfs.core.chinacloudapi.cn"],
    ["blob.core.usgovcloudapi.net", "dfs.core.usgovcloudapi.net"],
    ["blob.core.cloudapi.de", "dfs.core.cloudapi.de"],
    ["blob.core.microsoft.scloud", "dfs.core.microsoft.scloud"],
    ["blob.core.eaglex.ic.gov", "dfs.core.eaglex.ic.gov"],
    ["blob.storage.azure.net", "dfs.storage.azure.net"],
];
const ETagAny = "*";
const DeletionIdKey = "deletionid";
const EncryptionAlgorithmAES25 = "AES256";
const PathResultTypeConstants = {
    DirectoryResourceType: "directory",
};
/// List of ports used for path style addressing.
/// Path style addressing means that storage account is put in URI's Path segment in instead of in host.
const PathStylePorts = [
    "10000",
    "10001",
    "10002",
    "10003",
    "10004",
    "10100",
    "10101",
    "10102",
    "10103",
    "10104",
    "11000",
    "11001",
    "11002",
    "11003",
    "11004",
    "11100",
    "11101",
    "11102",
    "11103",
    "11104",
];

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Creates a new Pipeline object with Credential provided.
 *
 * @param credential -  Such as AnonymousCredential, StorageSharedKeyCredential or any credential from the `@azure/identity` package to authenticate requests to the service. You can also provide an object that implements the TokenCredential interface. If not specified, AnonymousCredential is used.
 * @param pipelineOptions - Optional. Options.
 * @returns A new Pipeline object.
 */
function newPipeline(credential, pipelineOptions = {}) {
    if (!credential) {
        credential = new storageBlob.AnonymousCredential();
    }
    const pipeline = new storageBlob.Pipeline([], pipelineOptions);
    pipeline._credential = credential;
    return pipeline;
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Creates a span using the global tracer.
 * @internal
 */
const tracingClient = coreTracing.createTracingClient({
    packageName: "@azure/storage-file-datalake",
    packageVersion: SDK_VERSION,
    namespace: "Microsoft.Storage",
});

class DataLakeLeaseClient {
    get leaseId() {
        return this.client.leaseId;
    }
    get url() {
        return this.client.url;
    }
    constructor(client) {
        this.client = client;
    }
    async acquireLease(duration, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-acquireLease", options, async (updatedOptions) => {
            return this.client.acquireLease(duration, updatedOptions);
        });
    }
    async changeLease(proposedLeaseId, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-changeLease", options, async (updatedOptions) => {
            return this.client.changeLease(proposedLeaseId, updatedOptions);
        });
    }
    async releaseLease(options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-releaseLease", options, async (updatedOptions) => {
            return this.client.releaseLease(updatedOptions);
        });
    }
    async renewLease(options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-renewLease", options, async (updatedOptions) => {
            return this.client.renewLease(updatedOptions);
        });
    }
    async breakLease(breakPeriod, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeLeaseClient-renewLease", options, async (updatedOptions) => {
            return this.client.breakLease(breakPeriod, updatedOptions);
        });
    }
}

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
const FileSystemList = {
    serializedName: "FileSystemList",
    type: {
        name: "Composite",
        className: "FileSystemList",
        modelProperties: {
            filesystems: {
                serializedName: "filesystems",
                xmlName: "filesystems",
                xmlElementName: "FileSystem",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "FileSystem"
                        }
                    }
                }
            }
        }
    }
};
const FileSystem = {
    serializedName: "FileSystem",
    type: {
        name: "Composite",
        className: "FileSystem",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "lastModified",
                xmlName: "lastModified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "eTag",
                xmlName: "eTag",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const StorageError = {
    serializedName: "StorageError",
    type: {
        name: "Composite",
        className: "StorageError",
        modelProperties: {
            error: {
                serializedName: "error",
                xmlName: "error",
                type: {
                    name: "Composite",
                    className: "StorageErrorError"
                }
            },
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String"
                }
            },
            authenticationErrorDetail: {
                serializedName: "AuthenticationErrorDetail",
                xmlName: "AuthenticationErrorDetail",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const StorageErrorError = {
    serializedName: "StorageErrorError",
    type: {
        name: "Composite",
        className: "StorageErrorError",
        modelProperties: {
            code: {
                serializedName: "Code",
                xmlName: "Code",
                type: {
                    name: "String"
                }
            },
            message: {
                serializedName: "Message",
                xmlName: "Message",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathList = {
    serializedName: "PathList",
    type: {
        name: "Composite",
        className: "PathList",
        modelProperties: {
            paths: {
                serializedName: "paths",
                xmlName: "paths",
                xmlElementName: "Path",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Path"
                        }
                    }
                }
            }
        }
    }
};
const Path = {
    serializedName: "Path",
    type: {
        name: "Composite",
        className: "Path",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            isDirectory: {
                defaultValue: false,
                serializedName: "isDirectory",
                xmlName: "isDirectory",
                type: {
                    name: "Boolean"
                }
            },
            lastModified: {
                serializedName: "lastModified",
                xmlName: "lastModified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "eTag",
                xmlName: "eTag",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "contentLength",
                xmlName: "contentLength",
                type: {
                    name: "Number"
                }
            },
            owner: {
                serializedName: "owner",
                xmlName: "owner",
                type: {
                    name: "String"
                }
            },
            group: {
                serializedName: "group",
                xmlName: "group",
                type: {
                    name: "String"
                }
            },
            permissions: {
                serializedName: "permissions",
                xmlName: "permissions",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "EncryptionScope",
                xmlName: "EncryptionScope",
                type: {
                    name: "String"
                }
            },
            creationTime: {
                serializedName: "creationTime",
                xmlName: "creationTime",
                type: {
                    name: "String"
                }
            },
            expiryTime: {
                serializedName: "expiryTime",
                xmlName: "expiryTime",
                type: {
                    name: "String"
                }
            },
            encryptionContext: {
                serializedName: "EncryptionContext",
                xmlName: "EncryptionContext",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ListBlobsHierarchySegmentResponse = {
    serializedName: "ListBlobsHierarchySegmentResponse",
    xmlName: "EnumerationResults",
    type: {
        name: "Composite",
        className: "ListBlobsHierarchySegmentResponse",
        modelProperties: {
            serviceEndpoint: {
                serializedName: "ServiceEndpoint",
                required: true,
                xmlName: "ServiceEndpoint",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            containerName: {
                serializedName: "ContainerName",
                required: true,
                xmlName: "ContainerName",
                xmlIsAttribute: true,
                type: {
                    name: "String"
                }
            },
            prefix: {
                serializedName: "Prefix",
                xmlName: "Prefix",
                type: {
                    name: "String"
                }
            },
            marker: {
                serializedName: "Marker",
                xmlName: "Marker",
                type: {
                    name: "String"
                }
            },
            maxResults: {
                serializedName: "MaxResults",
                xmlName: "MaxResults",
                type: {
                    name: "Number"
                }
            },
            delimiter: {
                serializedName: "Delimiter",
                xmlName: "Delimiter",
                type: {
                    name: "String"
                }
            },
            segment: {
                serializedName: "Segment",
                xmlName: "Blobs",
                type: {
                    name: "Composite",
                    className: "BlobHierarchyListSegment"
                }
            },
            nextMarker: {
                serializedName: "NextMarker",
                xmlName: "NextMarker",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobHierarchyListSegment = {
    serializedName: "BlobHierarchyListSegment",
    xmlName: "Blobs",
    type: {
        name: "Composite",
        className: "BlobHierarchyListSegment",
        modelProperties: {
            blobPrefixes: {
                serializedName: "BlobPrefixes",
                xmlName: "BlobPrefixes",
                xmlElementName: "BlobPrefix",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobPrefix"
                        }
                    }
                }
            },
            blobItems: {
                serializedName: "BlobItems",
                required: true,
                xmlName: "BlobItems",
                xmlElementName: "Blob",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "BlobItemModel"
                        }
                    }
                }
            }
        }
    }
};
const BlobPrefix = {
    serializedName: "BlobPrefix",
    type: {
        name: "Composite",
        className: "BlobPrefix",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobItemModel = {
    serializedName: "BlobItemModel",
    xmlName: "Blob",
    type: {
        name: "Composite",
        className: "BlobItemModel",
        modelProperties: {
            name: {
                serializedName: "Name",
                required: true,
                xmlName: "Name",
                type: {
                    name: "String"
                }
            },
            deleted: {
                serializedName: "Deleted",
                required: true,
                xmlName: "Deleted",
                type: {
                    name: "Boolean"
                }
            },
            snapshot: {
                serializedName: "Snapshot",
                required: true,
                xmlName: "Snapshot",
                type: {
                    name: "String"
                }
            },
            versionId: {
                serializedName: "VersionId",
                xmlName: "VersionId",
                type: {
                    name: "String"
                }
            },
            isCurrentVersion: {
                serializedName: "IsCurrentVersion",
                xmlName: "IsCurrentVersion",
                type: {
                    name: "Boolean"
                }
            },
            properties: {
                serializedName: "Properties",
                xmlName: "Properties",
                type: {
                    name: "Composite",
                    className: "BlobPropertiesModel"
                }
            },
            deletionId: {
                serializedName: "DeletionId",
                xmlName: "DeletionId",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const BlobPropertiesModel = {
    serializedName: "BlobPropertiesModel",
    xmlName: "Properties",
    type: {
        name: "Composite",
        className: "BlobPropertiesModel",
        modelProperties: {
            creationTime: {
                serializedName: "Creation-Time",
                xmlName: "Creation-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            lastModified: {
                serializedName: "Last-Modified",
                required: true,
                xmlName: "Last-Modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "Etag",
                required: true,
                xmlName: "Etag",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "Content-Length",
                xmlName: "Content-Length",
                type: {
                    name: "Number"
                }
            },
            contentType: {
                serializedName: "Content-Type",
                xmlName: "Content-Type",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "Content-Encoding",
                xmlName: "Content-Encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "Content-Language",
                xmlName: "Content-Language",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "Content-MD5",
                xmlName: "Content-MD5",
                type: {
                    name: "ByteArray"
                }
            },
            contentDisposition: {
                serializedName: "Content-Disposition",
                xmlName: "Content-Disposition",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "Cache-Control",
                xmlName: "Cache-Control",
                type: {
                    name: "String"
                }
            },
            blobSequenceNumber: {
                serializedName: "x-ms-blob-sequence-number",
                xmlName: "x-ms-blob-sequence-number",
                type: {
                    name: "Number"
                }
            },
            copyId: {
                serializedName: "CopyId",
                xmlName: "CopyId",
                type: {
                    name: "String"
                }
            },
            copySource: {
                serializedName: "CopySource",
                xmlName: "CopySource",
                type: {
                    name: "String"
                }
            },
            copyProgress: {
                serializedName: "CopyProgress",
                xmlName: "CopyProgress",
                type: {
                    name: "String"
                }
            },
            copyCompletionTime: {
                serializedName: "CopyCompletionTime",
                xmlName: "CopyCompletionTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            copyStatusDescription: {
                serializedName: "CopyStatusDescription",
                xmlName: "CopyStatusDescription",
                type: {
                    name: "String"
                }
            },
            serverEncrypted: {
                serializedName: "ServerEncrypted",
                xmlName: "ServerEncrypted",
                type: {
                    name: "Boolean"
                }
            },
            incrementalCopy: {
                serializedName: "IncrementalCopy",
                xmlName: "IncrementalCopy",
                type: {
                    name: "Boolean"
                }
            },
            destinationSnapshot: {
                serializedName: "DestinationSnapshot",
                xmlName: "DestinationSnapshot",
                type: {
                    name: "String"
                }
            },
            deletedTime: {
                serializedName: "DeletedTime",
                xmlName: "DeletedTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            remainingRetentionDays: {
                serializedName: "RemainingRetentionDays",
                xmlName: "RemainingRetentionDays",
                type: {
                    name: "Number"
                }
            },
            accessTierInferred: {
                serializedName: "AccessTierInferred",
                xmlName: "AccessTierInferred",
                type: {
                    name: "Boolean"
                }
            },
            customerProvidedKeySha256: {
                serializedName: "CustomerProvidedKeySha256",
                xmlName: "CustomerProvidedKeySha256",
                type: {
                    name: "String"
                }
            },
            encryptionScope: {
                serializedName: "EncryptionScope",
                xmlName: "EncryptionScope",
                type: {
                    name: "String"
                }
            },
            accessTierChangeTime: {
                serializedName: "AccessTierChangeTime",
                xmlName: "AccessTierChangeTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            tagCount: {
                serializedName: "TagCount",
                xmlName: "TagCount",
                type: {
                    name: "Number"
                }
            },
            expiresOn: {
                serializedName: "Expiry-Time",
                xmlName: "Expiry-Time",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            sealed: {
                serializedName: "Sealed",
                xmlName: "Sealed",
                type: {
                    name: "Boolean"
                }
            },
            lastAccessedOn: {
                serializedName: "LastAccessTime",
                xmlName: "LastAccessTime",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const SetAccessControlRecursiveResponse = {
    serializedName: "SetAccessControlRecursiveResponse",
    type: {
        name: "Composite",
        className: "SetAccessControlRecursiveResponse",
        modelProperties: {
            directoriesSuccessful: {
                serializedName: "directoriesSuccessful",
                xmlName: "directoriesSuccessful",
                type: {
                    name: "Number"
                }
            },
            filesSuccessful: {
                serializedName: "filesSuccessful",
                xmlName: "filesSuccessful",
                type: {
                    name: "Number"
                }
            },
            failureCount: {
                serializedName: "failureCount",
                xmlName: "failureCount",
                type: {
                    name: "Number"
                }
            },
            failedEntries: {
                serializedName: "failedEntries",
                xmlName: "failedEntries",
                xmlElementName: "AclFailedEntry",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "AclFailedEntry"
                        }
                    }
                }
            }
        }
    }
};
const AclFailedEntry = {
    serializedName: "AclFailedEntry",
    type: {
        name: "Composite",
        className: "AclFailedEntry",
        modelProperties: {
            name: {
                serializedName: "name",
                xmlName: "name",
                type: {
                    name: "String"
                }
            },
            type: {
                serializedName: "type",
                xmlName: "type",
                type: {
                    name: "String"
                }
            },
            errorMessage: {
                serializedName: "errorMessage",
                xmlName: "errorMessage",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceListFileSystemsHeaders = {
    serializedName: "Service_listFileSystemsHeaders",
    type: {
        name: "Composite",
        className: "ServiceListFileSystemsHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const ServiceListFileSystemsExceptionHeaders = {
    serializedName: "Service_listFileSystemsExceptionHeaders",
    type: {
        name: "Composite",
        className: "ServiceListFileSystemsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemCreateHeaders = {
    serializedName: "FileSystem_createHeaders",
    type: {
        name: "Composite",
        className: "FileSystemCreateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            namespaceEnabled: {
                serializedName: "x-ms-namespace-enabled",
                xmlName: "x-ms-namespace-enabled",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemCreateExceptionHeaders = {
    serializedName: "FileSystem_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemSetPropertiesHeaders = {
    serializedName: "FileSystem_setPropertiesHeaders",
    type: {
        name: "Composite",
        className: "FileSystemSetPropertiesHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemSetPropertiesExceptionHeaders = {
    serializedName: "FileSystem_setPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemSetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemGetPropertiesHeaders = {
    serializedName: "FileSystem_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "FileSystemGetPropertiesHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            namespaceEnabled: {
                serializedName: "x-ms-namespace-enabled",
                xmlName: "x-ms-namespace-enabled",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemGetPropertiesExceptionHeaders = {
    serializedName: "FileSystem_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemDeleteHeaders = {
    serializedName: "FileSystem_deleteHeaders",
    type: {
        name: "Composite",
        className: "FileSystemDeleteHeaders",
        modelProperties: {
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const FileSystemDeleteExceptionHeaders = {
    serializedName: "FileSystem_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemListPathsHeaders = {
    serializedName: "FileSystem_listPathsHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListPathsHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemListPathsExceptionHeaders = {
    serializedName: "FileSystem_listPathsExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListPathsExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemListBlobHierarchySegmentHeaders = {
    serializedName: "FileSystem_listBlobHierarchySegmentHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListBlobHierarchySegmentHeaders",
        modelProperties: {
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const FileSystemListBlobHierarchySegmentExceptionHeaders = {
    serializedName: "FileSystem_listBlobHierarchySegmentExceptionHeaders",
    type: {
        name: "Composite",
        className: "FileSystemListBlobHierarchySegmentExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathCreateHeaders = {
    serializedName: "Path_createHeaders",
    type: {
        name: "Composite",
        className: "PathCreateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathCreateExceptionHeaders = {
    serializedName: "Path_createExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathCreateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathUpdateHeaders = {
    serializedName: "Path_updateHeaders",
    type: {
        name: "Composite",
        className: "PathUpdateHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            xMsContinuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathUpdateExceptionHeaders = {
    serializedName: "Path_updateExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathUpdateExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathLeaseHeaders = {
    serializedName: "Path_leaseHeaders",
    type: {
        name: "Composite",
        className: "PathLeaseHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            leaseId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-lease-id",
                xmlName: "x-ms-lease-id",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathLeaseExceptionHeaders = {
    serializedName: "Path_leaseExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathLeaseExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathReadHeaders = {
    serializedName: "Path_readHeaders",
    type: {
        name: "Composite",
        className: "PathReadHeaders",
        modelProperties: {
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "String"
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "String"
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "String"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathReadExceptionHeaders = {
    serializedName: "Path_readExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathReadExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathGetPropertiesHeaders = {
    serializedName: "Path_getPropertiesHeaders",
    type: {
        name: "Composite",
        className: "PathGetPropertiesHeaders",
        modelProperties: {
            acceptRanges: {
                serializedName: "accept-ranges",
                xmlName: "accept-ranges",
                type: {
                    name: "String"
                }
            },
            cacheControl: {
                serializedName: "cache-control",
                xmlName: "cache-control",
                type: {
                    name: "String"
                }
            },
            contentDisposition: {
                serializedName: "content-disposition",
                xmlName: "content-disposition",
                type: {
                    name: "String"
                }
            },
            contentEncoding: {
                serializedName: "content-encoding",
                xmlName: "content-encoding",
                type: {
                    name: "String"
                }
            },
            contentLanguage: {
                serializedName: "content-language",
                xmlName: "content-language",
                type: {
                    name: "String"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            contentRange: {
                serializedName: "content-range",
                xmlName: "content-range",
                type: {
                    name: "String"
                }
            },
            contentType: {
                serializedName: "content-type",
                xmlName: "content-type",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            properties: {
                serializedName: "x-ms-properties",
                xmlName: "x-ms-properties",
                type: {
                    name: "String"
                }
            },
            owner: {
                serializedName: "x-ms-owner",
                xmlName: "x-ms-owner",
                type: {
                    name: "String"
                }
            },
            group: {
                serializedName: "x-ms-group",
                xmlName: "x-ms-group",
                type: {
                    name: "String"
                }
            },
            permissions: {
                serializedName: "x-ms-permissions",
                xmlName: "x-ms-permissions",
                type: {
                    name: "String"
                }
            },
            acl: {
                serializedName: "x-ms-acl",
                xmlName: "x-ms-acl",
                type: {
                    name: "String"
                }
            },
            leaseDuration: {
                serializedName: "x-ms-lease-duration",
                xmlName: "x-ms-lease-duration",
                type: {
                    name: "String"
                }
            },
            leaseState: {
                serializedName: "x-ms-lease-state",
                xmlName: "x-ms-lease-state",
                type: {
                    name: "String"
                }
            },
            leaseStatus: {
                serializedName: "x-ms-lease-status",
                xmlName: "x-ms-lease-status",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathGetPropertiesExceptionHeaders = {
    serializedName: "Path_getPropertiesExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathGetPropertiesExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathDeleteHeaders = {
    serializedName: "Path_deleteHeaders",
    type: {
        name: "Composite",
        className: "PathDeleteHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            deletionId: {
                serializedName: "x-ms-deletion-id",
                xmlName: "x-ms-deletion-id",
                type: {
                    name: "String"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathDeleteExceptionHeaders = {
    serializedName: "Path_deleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathDeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetAccessControlHeaders = {
    serializedName: "Path_setAccessControlHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetAccessControlExceptionHeaders = {
    serializedName: "Path_setAccessControlExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetAccessControlRecursiveHeaders = {
    serializedName: "Path_setAccessControlRecursiveHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlRecursiveHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            continuation: {
                serializedName: "x-ms-continuation",
                xmlName: "x-ms-continuation",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetAccessControlRecursiveExceptionHeaders = {
    serializedName: "Path_setAccessControlRecursiveExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetAccessControlRecursiveExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathFlushDataHeaders = {
    serializedName: "Path_flushDataHeaders",
    type: {
        name: "Composite",
        className: "PathFlushDataHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            contentLength: {
                serializedName: "content-length",
                xmlName: "content-length",
                type: {
                    name: "Number"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                constraints: {
                    Pattern: new RegExp("^[{(]?[0-9a-f]{8}[-]?([0-9a-f]{4}[-]?){3}[0-9a-f]{12}[)}]?$")
                },
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            leaseRenewed: {
                serializedName: "x-ms-lease-renewed",
                xmlName: "x-ms-lease-renewed",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const PathFlushDataExceptionHeaders = {
    serializedName: "Path_flushDataExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathFlushDataExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathAppendDataHeaders = {
    serializedName: "Path_appendDataHeaders",
    type: {
        name: "Composite",
        className: "PathAppendDataHeaders",
        modelProperties: {
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            contentMD5: {
                serializedName: "content-md5",
                xmlName: "content-md5",
                type: {
                    name: "ByteArray"
                }
            },
            xMsContentCrc64: {
                serializedName: "x-ms-content-crc64",
                xmlName: "x-ms-content-crc64",
                type: {
                    name: "ByteArray"
                }
            },
            isServerEncrypted: {
                serializedName: "x-ms-request-server-encrypted",
                xmlName: "x-ms-request-server-encrypted",
                type: {
                    name: "Boolean"
                }
            },
            encryptionKeySha256: {
                serializedName: "x-ms-encryption-key-sha256",
                xmlName: "x-ms-encryption-key-sha256",
                type: {
                    name: "String"
                }
            },
            leaseRenewed: {
                serializedName: "x-ms-lease-renewed",
                xmlName: "x-ms-lease-renewed",
                type: {
                    name: "Boolean"
                }
            }
        }
    }
};
const PathAppendDataExceptionHeaders = {
    serializedName: "Path_appendDataExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathAppendDataExceptionHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetExpiryHeaders = {
    serializedName: "Path_setExpiryHeaders",
    type: {
        name: "Composite",
        className: "PathSetExpiryHeaders",
        modelProperties: {
            etag: {
                serializedName: "etag",
                xmlName: "etag",
                type: {
                    name: "String"
                }
            },
            lastModified: {
                serializedName: "last-modified",
                xmlName: "last-modified",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            },
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathSetExpiryExceptionHeaders = {
    serializedName: "Path_setExpiryExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathSetExpiryExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};
const PathUndeleteHeaders = {
    serializedName: "Path_undeleteHeaders",
    type: {
        name: "Composite",
        className: "PathUndeleteHeaders",
        modelProperties: {
            clientRequestId: {
                serializedName: "x-ms-client-request-id",
                xmlName: "x-ms-client-request-id",
                type: {
                    name: "String"
                }
            },
            requestId: {
                serializedName: "x-ms-request-id",
                xmlName: "x-ms-request-id",
                type: {
                    name: "String"
                }
            },
            resourceType: {
                serializedName: "x-ms-resource-type",
                xmlName: "x-ms-resource-type",
                type: {
                    name: "String"
                }
            },
            version: {
                serializedName: "x-ms-version",
                xmlName: "x-ms-version",
                type: {
                    name: "String"
                }
            },
            date: {
                serializedName: "date",
                xmlName: "date",
                type: {
                    name: "DateTimeRfc1123"
                }
            }
        }
    }
};
const PathUndeleteExceptionHeaders = {
    serializedName: "Path_undeleteExceptionHeaders",
    type: {
        name: "Composite",
        className: "PathUndeleteExceptionHeaders",
        modelProperties: {
            errorCode: {
                serializedName: "x-ms-error-code",
                xmlName: "x-ms-error-code",
                type: {
                    name: "String"
                }
            }
        }
    }
};

var Mappers = /*#__PURE__*/Object.freeze({
    __proto__: null,
    AclFailedEntry: AclFailedEntry,
    BlobHierarchyListSegment: BlobHierarchyListSegment,
    BlobItemModel: BlobItemModel,
    BlobPrefix: BlobPrefix,
    BlobPropertiesModel: BlobPropertiesModel,
    FileSystem: FileSystem,
    FileSystemCreateExceptionHeaders: FileSystemCreateExceptionHeaders,
    FileSystemCreateHeaders: FileSystemCreateHeaders,
    FileSystemDeleteExceptionHeaders: FileSystemDeleteExceptionHeaders,
    FileSystemDeleteHeaders: FileSystemDeleteHeaders,
    FileSystemGetPropertiesExceptionHeaders: FileSystemGetPropertiesExceptionHeaders,
    FileSystemGetPropertiesHeaders: FileSystemGetPropertiesHeaders,
    FileSystemList: FileSystemList,
    FileSystemListBlobHierarchySegmentExceptionHeaders: FileSystemListBlobHierarchySegmentExceptionHeaders,
    FileSystemListBlobHierarchySegmentHeaders: FileSystemListBlobHierarchySegmentHeaders,
    FileSystemListPathsExceptionHeaders: FileSystemListPathsExceptionHeaders,
    FileSystemListPathsHeaders: FileSystemListPathsHeaders,
    FileSystemSetPropertiesExceptionHeaders: FileSystemSetPropertiesExceptionHeaders,
    FileSystemSetPropertiesHeaders: FileSystemSetPropertiesHeaders,
    ListBlobsHierarchySegmentResponse: ListBlobsHierarchySegmentResponse,
    Path: Path,
    PathAppendDataExceptionHeaders: PathAppendDataExceptionHeaders,
    PathAppendDataHeaders: PathAppendDataHeaders,
    PathCreateExceptionHeaders: PathCreateExceptionHeaders,
    PathCreateHeaders: PathCreateHeaders,
    PathDeleteExceptionHeaders: PathDeleteExceptionHeaders,
    PathDeleteHeaders: PathDeleteHeaders,
    PathFlushDataExceptionHeaders: PathFlushDataExceptionHeaders,
    PathFlushDataHeaders: PathFlushDataHeaders,
    PathGetPropertiesExceptionHeaders: PathGetPropertiesExceptionHeaders,
    PathGetPropertiesHeaders: PathGetPropertiesHeaders,
    PathLeaseExceptionHeaders: PathLeaseExceptionHeaders,
    PathLeaseHeaders: PathLeaseHeaders,
    PathList: PathList,
    PathReadExceptionHeaders: PathReadExceptionHeaders,
    PathReadHeaders: PathReadHeaders,
    PathSetAccessControlExceptionHeaders: PathSetAccessControlExceptionHeaders,
    PathSetAccessControlHeaders: PathSetAccessControlHeaders,
    PathSetAccessControlRecursiveExceptionHeaders: PathSetAccessControlRecursiveExceptionHeaders,
    PathSetAccessControlRecursiveHeaders: PathSetAccessControlRecursiveHeaders,
    PathSetExpiryExceptionHeaders: PathSetExpiryExceptionHeaders,
    PathSetExpiryHeaders: PathSetExpiryHeaders,
    PathUndeleteExceptionHeaders: PathUndeleteExceptionHeaders,
    PathUndeleteHeaders: PathUndeleteHeaders,
    PathUpdateExceptionHeaders: PathUpdateExceptionHeaders,
    PathUpdateHeaders: PathUpdateHeaders,
    ServiceListFileSystemsExceptionHeaders: ServiceListFileSystemsExceptionHeaders,
    ServiceListFileSystemsHeaders: ServiceListFileSystemsHeaders,
    SetAccessControlRecursiveResponse: SetAccessControlRecursiveResponse,
    StorageError: StorageError,
    StorageErrorError: StorageErrorError
});

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
const accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
const resource = {
    parameterPath: "resource",
    mapper: {
        defaultValue: "account",
        isConstant: true,
        serializedName: "resource",
        type: {
            name: "String"
        }
    }
};
const prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String"
        }
    }
};
const continuation = {
    parameterPath: ["options", "continuation"],
    mapper: {
        serializedName: "continuation",
        xmlName: "continuation",
        type: {
            name: "String"
        }
    }
};
const maxResults = {
    parameterPath: ["options", "maxResults"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxResults",
        xmlName: "maxResults",
        type: {
            name: "Number"
        }
    }
};
const requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
const timeout = {
    parameterPath: ["options", "timeout"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
const version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2025-05-05",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
const resource1 = {
    parameterPath: "resource",
    mapper: {
        defaultValue: "filesystem",
        isConstant: true,
        serializedName: "resource",
        type: {
            name: "String"
        }
    }
};
const properties = {
    parameterPath: ["options", "properties"],
    mapper: {
        serializedName: "x-ms-properties",
        xmlName: "x-ms-properties",
        type: {
            name: "String"
        }
    }
};
const ifModifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifModifiedSince"],
    mapper: {
        serializedName: "If-Modified-Since",
        xmlName: "If-Modified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const ifUnmodifiedSince = {
    parameterPath: ["options", "modifiedAccessConditions", "ifUnmodifiedSince"],
    mapper: {
        serializedName: "If-Unmodified-Since",
        xmlName: "If-Unmodified-Since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const path = {
    parameterPath: ["options", "path"],
    mapper: {
        serializedName: "directory",
        xmlName: "directory",
        type: {
            name: "String"
        }
    }
};
const recursive = {
    parameterPath: "recursive",
    mapper: {
        serializedName: "recursive",
        required: true,
        xmlName: "recursive",
        type: {
            name: "Boolean"
        }
    }
};
const upn = {
    parameterPath: ["options", "upn"],
    mapper: {
        serializedName: "upn",
        xmlName: "upn",
        type: {
            name: "Boolean"
        }
    }
};
const accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "container",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
const comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const delimiter = {
    parameterPath: ["options", "delimiter"],
    mapper: {
        serializedName: "delimiter",
        xmlName: "delimiter",
        type: {
            name: "String"
        }
    }
};
const marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String"
        }
    }
};
const include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListBlobsIncludeItem",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Enum",
                    allowedValues: [
                        "copy",
                        "deleted",
                        "metadata",
                        "snapshots",
                        "uncommittedblobs",
                        "versions",
                        "tags"
                    ]
                }
            }
        }
    },
    collectionFormat: "CSV"
};
const showonly = {
    parameterPath: ["options", "showonly"],
    mapper: {
        defaultValue: "deleted",
        isConstant: true,
        serializedName: "showonly",
        type: {
            name: "String"
        }
    }
};
const resource2 = {
    parameterPath: ["options", "resource"],
    mapper: {
        serializedName: "resource",
        xmlName: "resource",
        type: {
            name: "Enum",
            allowedValues: ["directory", "file"]
        }
    }
};
const mode = {
    parameterPath: ["options", "mode"],
    mapper: {
        serializedName: "mode",
        xmlName: "mode",
        type: {
            name: "Enum",
            allowedValues: ["legacy", "posix"]
        }
    }
};
const cacheControl = {
    parameterPath: ["options", "pathHttpHeaders", "cacheControl"],
    mapper: {
        serializedName: "x-ms-cache-control",
        xmlName: "x-ms-cache-control",
        type: {
            name: "String"
        }
    }
};
const contentEncoding = {
    parameterPath: ["options", "pathHttpHeaders", "contentEncoding"],
    mapper: {
        serializedName: "x-ms-content-encoding",
        xmlName: "x-ms-content-encoding",
        type: {
            name: "String"
        }
    }
};
const contentLanguage = {
    parameterPath: ["options", "pathHttpHeaders", "contentLanguage"],
    mapper: {
        serializedName: "x-ms-content-language",
        xmlName: "x-ms-content-language",
        type: {
            name: "String"
        }
    }
};
const contentDisposition = {
    parameterPath: ["options", "pathHttpHeaders", "contentDisposition"],
    mapper: {
        serializedName: "x-ms-content-disposition",
        xmlName: "x-ms-content-disposition",
        type: {
            name: "String"
        }
    }
};
const contentType = {
    parameterPath: ["options", "pathHttpHeaders", "contentType"],
    mapper: {
        serializedName: "x-ms-content-type",
        xmlName: "x-ms-content-type",
        type: {
            name: "String"
        }
    }
};
const renameSource = {
    parameterPath: ["options", "renameSource"],
    mapper: {
        serializedName: "x-ms-rename-source",
        xmlName: "x-ms-rename-source",
        type: {
            name: "String"
        }
    }
};
const leaseId = {
    parameterPath: ["options", "leaseAccessConditions", "leaseId"],
    mapper: {
        serializedName: "x-ms-lease-id",
        xmlName: "x-ms-lease-id",
        type: {
            name: "String"
        }
    }
};
const sourceLeaseId = {
    parameterPath: ["options", "sourceLeaseId"],
    mapper: {
        serializedName: "x-ms-source-lease-id",
        xmlName: "x-ms-source-lease-id",
        type: {
            name: "String"
        }
    }
};
const permissions = {
    parameterPath: ["options", "permissions"],
    mapper: {
        serializedName: "x-ms-permissions",
        xmlName: "x-ms-permissions",
        type: {
            name: "String"
        }
    }
};
const umask = {
    parameterPath: ["options", "umask"],
    mapper: {
        serializedName: "x-ms-umask",
        xmlName: "x-ms-umask",
        type: {
            name: "String"
        }
    }
};
const ifMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifMatch"],
    mapper: {
        serializedName: "If-Match",
        xmlName: "If-Match",
        type: {
            name: "String"
        }
    }
};
const ifNoneMatch = {
    parameterPath: ["options", "modifiedAccessConditions", "ifNoneMatch"],
    mapper: {
        serializedName: "If-None-Match",
        xmlName: "If-None-Match",
        type: {
            name: "String"
        }
    }
};
const sourceIfMatch = {
    parameterPath: ["options", "sourceModifiedAccessConditions", "sourceIfMatch"],
    mapper: {
        serializedName: "x-ms-source-if-match",
        xmlName: "x-ms-source-if-match",
        type: {
            name: "String"
        }
    }
};
const sourceIfNoneMatch = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfNoneMatch"
    ],
    mapper: {
        serializedName: "x-ms-source-if-none-match",
        xmlName: "x-ms-source-if-none-match",
        type: {
            name: "String"
        }
    }
};
const sourceIfModifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfModifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-modified-since",
        xmlName: "x-ms-source-if-modified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const sourceIfUnmodifiedSince = {
    parameterPath: [
        "options",
        "sourceModifiedAccessConditions",
        "sourceIfUnmodifiedSince"
    ],
    mapper: {
        serializedName: "x-ms-source-if-unmodified-since",
        xmlName: "x-ms-source-if-unmodified-since",
        type: {
            name: "DateTimeRfc1123"
        }
    }
};
const encryptionKey = {
    parameterPath: ["options", "cpkInfo", "encryptionKey"],
    mapper: {
        serializedName: "x-ms-encryption-key",
        xmlName: "x-ms-encryption-key",
        type: {
            name: "String"
        }
    }
};
const encryptionKeySha256 = {
    parameterPath: ["options", "cpkInfo", "encryptionKeySha256"],
    mapper: {
        serializedName: "x-ms-encryption-key-sha256",
        xmlName: "x-ms-encryption-key-sha256",
        type: {
            name: "String"
        }
    }
};
const encryptionAlgorithm = {
    parameterPath: ["options", "cpkInfo", "encryptionAlgorithm"],
    mapper: {
        serializedName: "x-ms-encryption-algorithm",
        xmlName: "x-ms-encryption-algorithm",
        type: {
            name: "String"
        }
    }
};
const owner = {
    parameterPath: ["options", "owner"],
    mapper: {
        serializedName: "x-ms-owner",
        xmlName: "x-ms-owner",
        type: {
            name: "String"
        }
    }
};
const group = {
    parameterPath: ["options", "group"],
    mapper: {
        serializedName: "x-ms-group",
        xmlName: "x-ms-group",
        type: {
            name: "String"
        }
    }
};
const acl = {
    parameterPath: ["options", "acl"],
    mapper: {
        serializedName: "x-ms-acl",
        xmlName: "x-ms-acl",
        type: {
            name: "String"
        }
    }
};
const proposedLeaseId = {
    parameterPath: ["options", "proposedLeaseId"],
    mapper: {
        serializedName: "x-ms-proposed-lease-id",
        xmlName: "x-ms-proposed-lease-id",
        type: {
            name: "String"
        }
    }
};
const leaseDuration = {
    parameterPath: ["options", "leaseDuration"],
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number"
        }
    }
};
const expiryOptions = {
    parameterPath: ["options", "expiryOptions"],
    mapper: {
        serializedName: "x-ms-expiry-option",
        xmlName: "x-ms-expiry-option",
        type: {
            name: "Enum",
            allowedValues: [
                "NeverExpire",
                "RelativeToCreation",
                "RelativeToNow",
                "Absolute"
            ]
        }
    }
};
const expiresOn = {
    parameterPath: ["options", "expiresOn"],
    mapper: {
        serializedName: "x-ms-expiry-time",
        xmlName: "x-ms-expiry-time",
        type: {
            name: "String"
        }
    }
};
const encryptionContext = {
    parameterPath: ["options", "encryptionContext"],
    mapper: {
        serializedName: "x-ms-encryption-context",
        xmlName: "x-ms-encryption-context",
        type: {
            name: "String"
        }
    }
};
const contentType1 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/octet-stream",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
const body = {
    parameterPath: "body",
    mapper: {
        serializedName: "body",
        required: true,
        xmlName: "body",
        type: {
            name: "Stream"
        }
    }
};
const accept2 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
const action = {
    parameterPath: "action",
    mapper: {
        serializedName: "action",
        required: true,
        xmlName: "action",
        type: {
            name: "Enum",
            allowedValues: [
                "append",
                "flush",
                "setProperties",
                "setAccessControl",
                "setAccessControlRecursive"
            ]
        }
    }
};
const maxRecords = {
    parameterPath: ["options", "maxRecords"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxRecords",
        xmlName: "maxRecords",
        type: {
            name: "Number"
        }
    }
};
const mode1 = {
    parameterPath: "mode",
    mapper: {
        serializedName: "mode",
        required: true,
        xmlName: "mode",
        type: {
            name: "Enum",
            allowedValues: ["set", "modify", "remove"]
        }
    }
};
const forceFlag = {
    parameterPath: ["options", "forceFlag"],
    mapper: {
        serializedName: "forceFlag",
        xmlName: "forceFlag",
        type: {
            name: "Boolean"
        }
    }
};
const position = {
    parameterPath: ["options", "position"],
    mapper: {
        serializedName: "position",
        xmlName: "position",
        type: {
            name: "Number"
        }
    }
};
const retainUncommittedData = {
    parameterPath: ["options", "retainUncommittedData"],
    mapper: {
        serializedName: "retainUncommittedData",
        xmlName: "retainUncommittedData",
        type: {
            name: "Boolean"
        }
    }
};
const close = {
    parameterPath: ["options", "close"],
    mapper: {
        serializedName: "close",
        xmlName: "close",
        type: {
            name: "Boolean"
        }
    }
};
const contentLength = {
    parameterPath: ["options", "contentLength"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "Content-Length",
        xmlName: "Content-Length",
        type: {
            name: "Number"
        }
    }
};
const contentMD5 = {
    parameterPath: ["options", "pathHttpHeaders", "contentMD5"],
    mapper: {
        serializedName: "x-ms-content-md5",
        xmlName: "x-ms-content-md5",
        type: {
            name: "ByteArray"
        }
    }
};
const xMsLeaseAction = {
    parameterPath: "xMsLeaseAction",
    mapper: {
        serializedName: "x-ms-lease-action",
        required: true,
        xmlName: "x-ms-lease-action",
        type: {
            name: "Enum",
            allowedValues: ["acquire", "break", "change", "renew", "release"]
        }
    }
};
const xMsLeaseDuration = {
    parameterPath: "xMsLeaseDuration",
    mapper: {
        serializedName: "x-ms-lease-duration",
        xmlName: "x-ms-lease-duration",
        type: {
            name: "Number"
        }
    }
};
const xMsLeaseBreakPeriod = {
    parameterPath: ["options", "xMsLeaseBreakPeriod"],
    mapper: {
        serializedName: "x-ms-lease-break-period",
        xmlName: "x-ms-lease-break-period",
        type: {
            name: "Number"
        }
    }
};
const range = {
    parameterPath: ["options", "range"],
    mapper: {
        serializedName: "Range",
        xmlName: "Range",
        type: {
            name: "String"
        }
    }
};
const xMsRangeGetContentMd5 = {
    parameterPath: ["options", "xMsRangeGetContentMd5"],
    mapper: {
        serializedName: "x-ms-range-get-content-md5",
        xmlName: "x-ms-range-get-content-md5",
        type: {
            name: "Boolean"
        }
    }
};
const action1 = {
    parameterPath: ["options", "action"],
    mapper: {
        serializedName: "action",
        xmlName: "action",
        type: {
            name: "Enum",
            allowedValues: ["getAccessControl", "getStatus"]
        }
    }
};
const recursive1 = {
    parameterPath: ["options", "recursive"],
    mapper: {
        serializedName: "recursive",
        xmlName: "recursive",
        type: {
            name: "Boolean"
        }
    }
};
const paginated = {
    parameterPath: ["options", "paginated"],
    mapper: {
        serializedName: "paginated",
        xmlName: "paginated",
        type: {
            name: "Boolean"
        }
    }
};
const action2 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "setAccessControl",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
const action3 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "setAccessControlRecursive",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
const action4 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "flush",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
const leaseAction = {
    parameterPath: ["options", "leaseAction"],
    mapper: {
        serializedName: "x-ms-lease-action",
        xmlName: "x-ms-lease-action",
        type: {
            name: "Enum",
            allowedValues: ["acquire", "auto-renew", "release", "acquire-release"]
        }
    }
};
const contentType2 = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/json",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
const action5 = {
    parameterPath: "action",
    mapper: {
        defaultValue: "append",
        isConstant: true,
        serializedName: "action",
        type: {
            name: "String"
        }
    }
};
const transactionalContentHash = {
    parameterPath: ["options", "pathHttpHeaders", "transactionalContentHash"],
    mapper: {
        serializedName: "Content-MD5",
        xmlName: "Content-MD5",
        type: {
            name: "ByteArray"
        }
    }
};
const transactionalContentCrc64 = {
    parameterPath: ["options", "transactionalContentCrc64"],
    mapper: {
        serializedName: "x-ms-content-crc64",
        xmlName: "x-ms-content-crc64",
        type: {
            name: "ByteArray"
        }
    }
};
const flush = {
    parameterPath: ["options", "flush"],
    mapper: {
        serializedName: "flush",
        xmlName: "flush",
        type: {
            name: "Boolean"
        }
    }
};
const comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "expiry",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const expiryOptions1 = {
    parameterPath: "expiryOptions",
    mapper: {
        serializedName: "x-ms-expiry-option",
        required: true,
        xmlName: "x-ms-expiry-option",
        type: {
            name: "Enum",
            allowedValues: [
                "NeverExpire",
                "RelativeToCreation",
                "RelativeToNow",
                "Absolute"
            ]
        }
    }
};
const comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "undelete",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
const undeleteSource = {
    parameterPath: ["options", "undeleteSource"],
    mapper: {
        serializedName: "x-ms-undelete-source",
        xmlName: "x-ms-undelete-source",
        type: {
            name: "String"
        }
    }
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class containing Service operations. */
class ServiceImpl {
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * List filesystems and their properties in given account.
     * @param options The options parameters.
     */
    listFileSystems(options) {
        return this.client.sendOperationRequest({ options }, listFileSystemsOperationSpec);
    }
}
// Operation Specifications
const serializer$2 = coreClient__namespace.createSerializer(Mappers, /* isXml */ false);
const listFileSystemsOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: FileSystemList,
            headersMapper: ServiceListFileSystemsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: ServiceListFileSystemsExceptionHeaders
        }
    },
    queryParameters: [
        resource,
        prefix,
        continuation,
        maxResults,
        timeout
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version
    ],
    serializer: serializer$2
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class containing FileSystemOperations operations. */
class FileSystemOperationsImpl {
    /**
     * Initialize a new instance of the class FileSystemOperations class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Create a FileSystem rooted at the specified location. If the FileSystem already exists, the
     * operation fails.  This operation does not support conditional HTTP requests.
     * @param options The options parameters.
     */
    create(options) {
        return this.client.sendOperationRequest({ options }, createOperationSpec$1);
    }
    /**
     * Set properties for the FileSystem.  This operation supports conditional HTTP requests.  For more
     * information, see [Specifying Conditional Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param options The options parameters.
     */
    setProperties(options) {
        return this.client.sendOperationRequest({ options }, setPropertiesOperationSpec);
    }
    /**
     * All system and user-defined filesystem properties are specified in the response headers.
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec$1);
    }
    /**
     * Marks the FileSystem for deletion.  When a FileSystem is deleted, a FileSystem with the same
     * identifier cannot be created for at least 30 seconds. While the filesystem is being deleted,
     * attempts to create a filesystem with the same identifier will fail with status code 409 (Conflict),
     * with the service returning additional error information indicating that the filesystem is being
     * deleted. All other operations, including operations on any files or directories within the
     * filesystem, will fail with status code 404 (Not Found) while the filesystem is being deleted. This
     * operation supports conditional HTTP requests.  For more information, see [Specifying Conditional
     * Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param options The options parameters.
     */
    delete(options) {
        return this.client.sendOperationRequest({ options }, deleteOperationSpec$1);
    }
    /**
     * List FileSystem paths and their properties.
     * @param recursive Required
     * @param options The options parameters.
     */
    listPaths(recursive, options) {
        return this.client.sendOperationRequest({ recursive, options }, listPathsOperationSpec);
    }
    /**
     * The List Blobs operation returns a list of the blobs under the specified container
     * @param options The options parameters.
     */
    listBlobHierarchySegment(options) {
        return this.client.sendOperationRequest({ options }, listBlobHierarchySegmentOperationSpec);
    }
}
// Operation Specifications
const xmlSerializer = coreClient__namespace.createSerializer(Mappers, /* isXml */ true);
const serializer$1 = coreClient__namespace.createSerializer(Mappers, /* isXml */ false);
const createOperationSpec$1 = {
    path: "/{filesystem}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: FileSystemCreateHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemCreateExceptionHeaders
        }
    },
    queryParameters: [timeout, resource1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        properties
    ],
    serializer: serializer$1
};
const setPropertiesOperationSpec = {
    path: "/{filesystem}",
    httpMethod: "PATCH",
    responses: {
        200: {
            headersMapper: FileSystemSetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemSetPropertiesExceptionHeaders
        }
    },
    queryParameters: [timeout, resource1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        properties,
        ifModifiedSince,
        ifUnmodifiedSince
    ],
    serializer: serializer$1
};
const getPropertiesOperationSpec$1 = {
    path: "/{filesystem}",
    httpMethod: "HEAD",
    responses: {
        200: {
            headersMapper: FileSystemGetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [timeout, resource1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version
    ],
    serializer: serializer$1
};
const deleteOperationSpec$1 = {
    path: "/{filesystem}",
    httpMethod: "DELETE",
    responses: {
        202: {
            headersMapper: FileSystemDeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemDeleteExceptionHeaders
        }
    },
    queryParameters: [timeout, resource1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince
    ],
    serializer: serializer$1
};
const listPathsOperationSpec = {
    path: "/{filesystem}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: PathList,
            headersMapper: FileSystemListPathsHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemListPathsExceptionHeaders
        }
    },
    queryParameters: [
        continuation,
        maxResults,
        timeout,
        resource1,
        path,
        recursive,
        upn
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version
    ],
    serializer: serializer$1
};
const listBlobHierarchySegmentOperationSpec = {
    path: "/{filesystem}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: ListBlobsHierarchySegmentResponse,
            headersMapper: FileSystemListBlobHierarchySegmentHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: FileSystemListBlobHierarchySegmentExceptionHeaders
        }
    },
    queryParameters: [
        prefix,
        maxResults,
        timeout,
        restype,
        comp,
        delimiter,
        marker,
        include,
        showonly
    ],
    urlParameters: [url],
    headerParameters: [
        requestId,
        version,
        accept1
    ],
    isXML: true,
    serializer: xmlSerializer
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
/** Class containing PathOperations operations. */
class PathOperationsImpl {
    /**
     * Initialize a new instance of the class PathOperations class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Create or rename a file or directory.    By default, the destination is overwritten and if the
     * destination already exists and has a lease the lease is broken.  This operation supports conditional
     * HTTP requests.  For more information, see [Specifying Conditional Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     *  To fail if the destination already exists, use a conditional request with If-None-Match: "*".
     * @param options The options parameters.
     */
    create(options) {
        return this.client.sendOperationRequest({ options }, createOperationSpec);
    }
    /**
     * Uploads data to be appended to a file, flushes (writes) previously uploaded data to a file, sets
     * properties for a file or directory, or sets access control for a file or directory. Data can only be
     * appended to a file. Concurrent writes to the same file using multiple clients are not supported.
     * This operation supports conditional HTTP requests. For more information, see [Specifying Conditional
     * Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param action The action must be "append" to upload data to be appended to a file, "flush" to flush
     *               previously uploaded data to a file, "setProperties" to set the properties of a file or directory,
     *               "setAccessControl" to set the owner, group, permissions, or access control list for a file or
     *               directory, or  "setAccessControlRecursive" to set the access control list for a directory
     *               recursively. Note that Hierarchical Namespace must be enabled for the account in order to use access
     *               control.  Also note that the Access Control List (ACL) includes permissions for the owner, owning
     *               group, and others, so the x-ms-permissions and x-ms-acl request headers are mutually exclusive.
     * @param mode Mode "set" sets POSIX access control rights on files and directories, "modify" modifies
     *             one or more POSIX access control rights  that pre-exist on files and directories, "remove" removes
     *             one or more POSIX access control rights  that were present earlier on files and directories
     * @param body Initial data
     * @param options The options parameters.
     */
    update(action, mode, body, options) {
        return this.client.sendOperationRequest({ action, mode, body, options }, updateOperationSpec);
    }
    /**
     * Create and manage a lease to restrict write and delete access to the path. This operation supports
     * conditional HTTP requests.  For more information, see [Specifying Conditional Headers for Blob
     * Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param xMsLeaseAction There are five lease actions: "acquire", "break", "change", "renew", and
     *                       "release". Use "acquire" and specify the "x-ms-proposed-lease-id" and "x-ms-lease-duration" to
     *                       acquire a new lease. Use "break" to break an existing lease. When a lease is broken, the lease break
     *                       period is allowed to elapse, during which time no lease operation except break and release can be
     *                       performed on the file. When a lease is successfully broken, the response indicates the interval in
     *                       seconds until a new lease can be acquired. Use "change" and specify the current lease ID in
     *                       "x-ms-lease-id" and the new lease ID in "x-ms-proposed-lease-id" to change the lease ID of an active
     *                       lease. Use "renew" and specify the "x-ms-lease-id" to renew an existing lease. Use "release" and
     *                       specify the "x-ms-lease-id" to release a lease.
     * @param options The options parameters.
     */
    lease(xMsLeaseAction, options) {
        return this.client.sendOperationRequest({ xMsLeaseAction, options }, leaseOperationSpec);
    }
    /**
     * Read the contents of a file.  For read operations, range requests are supported. This operation
     * supports conditional HTTP requests.  For more information, see [Specifying Conditional Headers for
     * Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param options The options parameters.
     */
    read(options) {
        return this.client.sendOperationRequest({ options }, readOperationSpec);
    }
    /**
     * Get Properties returns all system and user defined properties for a path. Get Status returns all
     * system defined properties for a path. Get Access Control List returns the access control list for a
     * path. This operation supports conditional HTTP requests.  For more information, see [Specifying
     * Conditional Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec);
    }
    /**
     * Delete the file or directory. This operation supports conditional HTTP requests.  For more
     * information, see [Specifying Conditional Headers for Blob Service
     * Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
     * @param options The options parameters.
     */
    delete(options) {
        return this.client.sendOperationRequest({ options }, deleteOperationSpec);
    }
    /**
     * Set the owner, group, permissions, or access control list for a path.
     * @param options The options parameters.
     */
    setAccessControl(options) {
        return this.client.sendOperationRequest({ options }, setAccessControlOperationSpec);
    }
    /**
     * Set the access control list for a path and sub-paths.
     * @param mode Mode "set" sets POSIX access control rights on files and directories, "modify" modifies
     *             one or more POSIX access control rights  that pre-exist on files and directories, "remove" removes
     *             one or more POSIX access control rights  that were present earlier on files and directories
     * @param options The options parameters.
     */
    setAccessControlRecursive(mode, options) {
        return this.client.sendOperationRequest({ mode, options }, setAccessControlRecursiveOperationSpec);
    }
    /**
     * Set the owner, group, permissions, or access control list for a path.
     * @param options The options parameters.
     */
    flushData(options) {
        return this.client.sendOperationRequest({ options }, flushDataOperationSpec);
    }
    /**
     * Append data to the file.
     * @param body Initial data
     * @param options The options parameters.
     */
    appendData(body, options) {
        return this.client.sendOperationRequest({ body, options }, appendDataOperationSpec);
    }
    /**
     * Sets the time a blob will expire and be deleted.
     * @param expiryOptions Required. Indicates mode of the expiry time
     * @param options The options parameters.
     */
    setExpiry(expiryOptions, options) {
        return this.client.sendOperationRequest({ expiryOptions, options }, setExpiryOperationSpec);
    }
    /**
     * Undelete a path that was previously soft deleted
     * @param options The options parameters.
     */
    undelete(options) {
        return this.client.sendOperationRequest({ options }, undeleteOperationSpec);
    }
}
// Operation Specifications
const serializer = coreClient__namespace.createSerializer(Mappers, /* isXml */ false);
const createOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PUT",
    responses: {
        201: {
            headersMapper: PathCreateHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathCreateExceptionHeaders
        }
    },
    queryParameters: [
        continuation,
        timeout,
        resource2,
        mode
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        properties,
        ifModifiedSince,
        ifUnmodifiedSince,
        cacheControl,
        contentEncoding,
        contentLanguage,
        contentDisposition,
        contentType,
        renameSource,
        leaseId,
        sourceLeaseId,
        permissions,
        umask,
        ifMatch,
        ifNoneMatch,
        sourceIfMatch,
        sourceIfNoneMatch,
        sourceIfModifiedSince,
        sourceIfUnmodifiedSince,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        owner,
        group,
        acl,
        proposedLeaseId,
        leaseDuration,
        expiryOptions,
        expiresOn,
        encryptionContext
    ],
    serializer
};
const updateOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PATCH",
    responses: {
        200: {
            bodyMapper: SetAccessControlRecursiveResponse,
            headersMapper: PathUpdateHeaders
        },
        202: {
            headersMapper: PathUpdateHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathUpdateExceptionHeaders
        }
    },
    requestBody: body,
    queryParameters: [
        continuation,
        timeout,
        action,
        maxRecords,
        mode1,
        forceFlag,
        position,
        retainUncommittedData,
        close
    ],
    urlParameters: [url],
    headerParameters: [
        requestId,
        version,
        properties,
        ifModifiedSince,
        ifUnmodifiedSince,
        cacheControl,
        contentEncoding,
        contentLanguage,
        contentDisposition,
        contentType,
        leaseId,
        permissions,
        ifMatch,
        ifNoneMatch,
        owner,
        group,
        acl,
        contentType1,
        accept2,
        contentLength,
        contentMD5
    ],
    mediaType: "binary",
    serializer
};
const leaseOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "POST",
    responses: {
        200: {
            headersMapper: PathLeaseHeaders
        },
        201: {
            headersMapper: PathLeaseHeaders
        },
        202: {
            headersMapper: PathLeaseHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathLeaseExceptionHeaders
        }
    },
    queryParameters: [timeout],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId,
        ifMatch,
        ifNoneMatch,
        proposedLeaseId,
        xMsLeaseAction,
        xMsLeaseDuration,
        xMsLeaseBreakPeriod
    ],
    serializer
};
const readOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: PathReadHeaders
        },
        206: {
            bodyMapper: {
                type: { name: "Stream" },
                serializedName: "parsedResponse"
            },
            headersMapper: PathReadHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathReadExceptionHeaders
        }
    },
    queryParameters: [timeout],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId,
        ifMatch,
        ifNoneMatch,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        range,
        xMsRangeGetContentMd5
    ],
    serializer
};
const getPropertiesOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "HEAD",
    responses: {
        200: {
            headersMapper: PathGetPropertiesHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathGetPropertiesExceptionHeaders
        }
    },
    queryParameters: [timeout, upn, action1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId,
        ifMatch,
        ifNoneMatch
    ],
    serializer
};
const deleteOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "DELETE",
    responses: {
        200: {
            headersMapper: PathDeleteHeaders
        },
        202: {
            headersMapper: PathDeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathDeleteExceptionHeaders
        }
    },
    queryParameters: [
        continuation,
        timeout,
        recursive1,
        paginated
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId,
        ifMatch,
        ifNoneMatch
    ],
    serializer
};
const setAccessControlOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PATCH",
    responses: {
        200: {
            headersMapper: PathSetAccessControlHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathSetAccessControlExceptionHeaders
        }
    },
    queryParameters: [timeout, action2],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        leaseId,
        permissions,
        ifMatch,
        ifNoneMatch,
        owner,
        group,
        acl
    ],
    serializer
};
const setAccessControlRecursiveOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PATCH",
    responses: {
        200: {
            bodyMapper: SetAccessControlRecursiveResponse,
            headersMapper: PathSetAccessControlRecursiveHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathSetAccessControlRecursiveExceptionHeaders
        }
    },
    queryParameters: [
        continuation,
        timeout,
        maxRecords,
        mode1,
        forceFlag,
        action3
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        acl
    ],
    serializer
};
const flushDataOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PATCH",
    responses: {
        200: {
            headersMapper: PathFlushDataHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathFlushDataExceptionHeaders
        }
    },
    queryParameters: [
        timeout,
        position,
        retainUncommittedData,
        close,
        action4
    ],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        ifModifiedSince,
        ifUnmodifiedSince,
        cacheControl,
        contentEncoding,
        contentLanguage,
        contentDisposition,
        contentType,
        leaseId,
        ifMatch,
        ifNoneMatch,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        proposedLeaseId,
        leaseDuration,
        contentLength,
        contentMD5,
        leaseAction
    ],
    serializer
};
const appendDataOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PATCH",
    responses: {
        202: {
            headersMapper: PathAppendDataHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathAppendDataExceptionHeaders
        }
    },
    requestBody: body,
    queryParameters: [
        timeout,
        position,
        action5,
        flush
    ],
    urlParameters: [url],
    headerParameters: [
        requestId,
        version,
        leaseId,
        encryptionKey,
        encryptionKeySha256,
        encryptionAlgorithm,
        proposedLeaseId,
        leaseDuration,
        accept2,
        contentLength,
        leaseAction,
        contentType2,
        transactionalContentHash,
        transactionalContentCrc64
    ],
    mediaType: "binary",
    serializer
};
const setExpiryOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: PathSetExpiryHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathSetExpiryExceptionHeaders
        }
    },
    queryParameters: [timeout, comp1],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        expiresOn,
        expiryOptions1
    ],
    serializer
};
const undeleteOperationSpec = {
    path: "/{filesystem}/{path}",
    httpMethod: "PUT",
    responses: {
        200: {
            headersMapper: PathUndeleteHeaders
        },
        default: {
            bodyMapper: StorageError,
            headersMapper: PathUndeleteExceptionHeaders
        }
    },
    queryParameters: [timeout, comp2],
    urlParameters: [url],
    headerParameters: [
        accept,
        requestId,
        version,
        undeleteSource
    ],
    serializer
};

/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
let StorageClient$1 = class StorageClient extends coreHttpCompat__namespace.ExtendedServiceClient {
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, container, or blob that is the target of the desired
     *            operation.
     * @param options The parameter options
     */
    constructor(url, options) {
        var _a, _b;
        if (url === undefined) {
            throw new Error("'url' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8"
        };
        const packageDetails = `azsdk-js-azure-storage-datalake/12.26.0`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = Object.assign(Object.assign(Object.assign({}, defaults), options), { userAgentOptions: {
                userAgentPrefix
            }, endpoint: (_b = (_a = options.endpoint) !== null && _a !== void 0 ? _a : options.baseUri) !== null && _b !== void 0 ? _b : "{url}" });
        super(optionsWithDefaults);
        // Parameter assignments
        this.url = url;
        // Assigning values to Constant parameters
        this.version = options.version || "2025-05-05";
        this.resource = options.resource || "filesystem";
        this.service = new ServiceImpl(this);
        this.fileSystemOperations = new FileSystemOperationsImpl(this);
        this.pathOperations = new PathOperationsImpl(this);
    }
};

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * @internal
 */
class StorageContextClient extends StorageClient$1 {
    async sendOperationRequest(operationArguments, operationSpec) {
        var _a;
        const operationSpecToSend = Object.assign({}, operationSpec);
        if (!coreUtil.isNode &&
            !operationSpec.requestBody &&
            ((_a = operationSpec.headerParameters) === null || _a === void 0 ? void 0 : _a.some((param) => param.mapper.serializedName === "Content-Length"))) {
            operationSpecToSend.mediaType = "text";
            operationSpecToSend.requestBody = {
                parameterPath: "body",
                mapper: {
                    serializedName: "body",
                    isConstant: true,
                    defaultValue: "",
                    type: {
                        name: "String",
                    },
                },
            };
        }
        if (operationSpecToSend.path === "/{filesystem}" ||
            operationSpecToSend.path === "/{filesystem}/{path}") {
            operationSpecToSend.path = "";
        }
        return super.sendOperationRequest(operationArguments, operationSpecToSend);
    }
}

/**
 * Reserved URL characters must be properly escaped for Storage services like Blob or File.
 *
 * ## URL encode and escape strategy for JS SDKs
 *
 * When customers pass a URL string into XxxClient classes constructors, the URL string may already be URL encoded or not.
 * But before sending to Azure Storage server, the URL must be encoded. However, it's hard for a SDK to guess whether the URL
 * string has been encoded or not. We have 2 potential strategies, and chose strategy two for the XxxClient constructors.
 *
 * ### Strategy One: Assume the customer URL string is not encoded, and always encode URL string in SDK.
 *
 * This is what legacy V2 SDK does, simple and works for most of the cases.
 * - When customer URL string is "http://account.blob.core.windows.net/con/b:",
 *   SDK will encode it to "http://account.blob.core.windows.net/con/b%3A" and send to server. A blob named "b:" will be created.
 * - When customer URL string is "http://account.blob.core.windows.net/con/b%3A",
 *   SDK will encode it to "http://account.blob.core.windows.net/con/b%253A" and send to server. A blob named "b%3A" will be created.
 *
 * But this strategy will make it not possible to create a blob with "?" in it's name. Because when customer URL string is
 * "http://account.blob.core.windows.net/con/blob?name", the "?name" will be treated as URL paramter instead of blob name.
 * If customer URL string is "http://account.blob.core.windows.net/con/blob%3Fname", a blob named "blob%3Fname" will be created.
 * V2 SDK doesn't have this issue because it doesn't allow customer pass in a full URL, it accepts a separate blob name and encodeURIComponent for it.
 * We cannot accept a SDK cannot create a blob name with "?". So we implement strategy two:
 *
 * ### Strategy Two: SDK doesn't assume the URL has been encoded or not. It will just escape the special characters.
 *
 * This is what V10 Blob Go SDK does. It accepts a URL type in Go, and call url.EscapedPath() to escape the special chars unescaped.
 * - When customer URL string is "http://account.blob.core.windows.net/con/b:",
 *   SDK will escape ":" like "http://account.blob.core.windows.net/con/b%3A" and send to server. A blob named "b:" will be created.
 * - When customer URL string is "http://account.blob.core.windows.net/con/b%3A",
 *   There is no special characters, so send "http://account.blob.core.windows.net/con/b%3A" to server. A blob named "b:" will be created.
 * - When customer URL string is "http://account.blob.core.windows.net/con/b%253A",
 *   There is no special characters, so send "http://account.blob.core.windows.net/con/b%253A" to server. A blob named "b%3A" will be created.
 *
 * This strategy gives us flexibility to create with any special characters. But "%" will be treated as a special characters, if the URL string
 * is not encoded, there shouldn't a "%" in the URL string, otherwise the URL is not a valid URL.
 * If customer needs to create a blob with "%" in it's blob name, use "%25" instead of "%". Just like above 3rd sample.
 * And following URL strings are invalid:
 * - "http://account.blob.core.windows.net/con/b%"
 * - "http://account.blob.core.windows.net/con/b%2"
 * - "http://account.blob.core.windows.net/con/b%G"
 *
 * Another special character is "?", use "%2F" to represent a blob name with "?" in a URL string.
 *
 * ### Strategy for containerName, blobName or other specific XXXName parameters in methods such as `containerClient.getBlobClient(blobName)`
 *
 * We will apply strategy one, and call encodeURIComponent for these parameters like blobName. Because what customers passes in is a plain name instead of a URL.
 *
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-shares--directories--files--and-metadata
 *
 * @param url -
 */
function escapeURLPath(url) {
    const urlParsed = new URL(url);
    let path = urlParsed.pathname;
    path = path || "/";
    path = escape(path);
    urlParsed.pathname = path;
    return urlParsed.toString();
}
function getProxyUriFromDevConnString(connectionString) {
    // Development Connection String
    // https://learn.microsoft.com/en-us/azure/storage/common/storage-configure-connection-string#connect-to-the-emulator-account-using-the-well-known-account-name-and-key
    let proxyUri = "";
    if (connectionString.search("DevelopmentStorageProxyUri=") !== -1) {
        // CONNECTION_STRING=UseDevelopmentStorage=true;DevelopmentStorageProxyUri=http://myProxyUri
        const matchCredentials = connectionString.split(";");
        for (const element of matchCredentials) {
            if (element.trim().startsWith("DevelopmentStorageProxyUri=")) {
                proxyUri = element.trim().match("DevelopmentStorageProxyUri=(.*)")[1];
            }
        }
    }
    return proxyUri;
}
function getValueInConnString(connectionString, argument) {
    const elements = connectionString.split(";");
    for (const element of elements) {
        if (element.trim().startsWith(argument)) {
            return element.trim().match(argument + "=(.*)")[1];
        }
    }
    return "";
}
/**
 * Extracts the parts of an Azure Storage account connection string.
 *
 * @param connectionString - Connection string.
 * @returns String key value pairs of the storage account's url and credentials.
 */
function extractConnectionStringParts(connectionString) {
    let proxyUri = "";
    if (connectionString.startsWith("UseDevelopmentStorage=true")) {
        // Development connection string
        proxyUri = getProxyUriFromDevConnString(connectionString);
        connectionString = DevelopmentConnectionString;
    }
    // Matching BlobEndpoint in the Account connection string
    let blobEndpoint = getValueInConnString(connectionString, "BlobEndpoint");
    // Slicing off '/' at the end if exists
    // (The methods that use `extractConnectionStringParts` expect the url to not have `/` at the end)
    blobEndpoint = blobEndpoint.endsWith("/") ? blobEndpoint.slice(0, -1) : blobEndpoint;
    if (connectionString.search("DefaultEndpointsProtocol=") !== -1 &&
        connectionString.search("AccountKey=") !== -1) {
        // Account connection string
        let defaultEndpointsProtocol = "";
        let accountName = "";
        let accountKey = Buffer.from("accountKey", "base64");
        let endpointSuffix = "";
        // Get account name and key
        accountName = getValueInConnString(connectionString, "AccountName");
        accountKey = Buffer.from(getValueInConnString(connectionString, "AccountKey"), "base64");
        if (!blobEndpoint) {
            // BlobEndpoint is not present in the Account connection string
            // Can be obtained from `${defaultEndpointsProtocol}://${accountName}.blob.${endpointSuffix}`
            defaultEndpointsProtocol = getValueInConnString(connectionString, "DefaultEndpointsProtocol");
            const protocol = defaultEndpointsProtocol.toLowerCase();
            if (protocol !== "https" && protocol !== "http") {
                throw new Error("Invalid DefaultEndpointsProtocol in the provided Connection String. Expecting 'https' or 'http'");
            }
            endpointSuffix = getValueInConnString(connectionString, "EndpointSuffix");
            if (!endpointSuffix) {
                throw new Error("Invalid EndpointSuffix in the provided Connection String");
            }
            blobEndpoint = `${defaultEndpointsProtocol}://${accountName}.blob.${endpointSuffix}`;
        }
        if (!accountName) {
            throw new Error("Invalid AccountName in the provided Connection String");
        }
        else if (accountKey.length === 0) {
            throw new Error("Invalid AccountKey in the provided Connection String");
        }
        return {
            kind: "AccountConnString",
            url: blobEndpoint,
            accountName,
            accountKey,
            proxyUri,
        };
    }
    else {
        // SAS connection string
        const accountSas = getValueInConnString(connectionString, "SharedAccessSignature");
        let accountName = getValueInConnString(connectionString, "AccountName");
        // if accountName is empty, try to read it from BlobEndpoint
        if (!accountName) {
            accountName = getAccountNameFromUrl(blobEndpoint);
        }
        if (!blobEndpoint) {
            throw new Error("Invalid BlobEndpoint in the provided SAS Connection String");
        }
        else if (!accountSas) {
            throw new Error("Invalid SharedAccessSignature in the provided SAS Connection String");
        }
        return { kind: "SASConnString", url: blobEndpoint, accountName, accountSas };
    }
}
/**
 * Internal escape method implemented Strategy Two mentioned in escapeURL() description.
 *
 * @param text -
 */
// eslint-disable-next-line @typescript-eslint/no-redeclare
function escape(text) {
    return encodeURIComponent(text)
        .replace(/%2F/g, "/") // Don't escape for "/"
        .replace(/'/g, "%27") // Escape for "'"
        .replace(/\+/g, "%20")
        .replace(/%25/g, "%"); // Revert encoded "%"
}
/**
 * Append a string to URL path. Will remove duplicated "/" in front of the string
 * when URL path ends with a "/".
 *
 * @param url - Source URL string
 * @param name - String to be appended to URL
 * @returns An updated URL string
 */
function appendToURLPath(url, name) {
    const urlParsed = new URL(url);
    let path = urlParsed.pathname;
    path = path ? (path.endsWith("/") ? `${path}${name}` : `${path}/${name}`) : name;
    urlParsed.pathname = path;
    return urlParsed.toString();
}
/**
 * Append a string to URL query.
 *
 * @param url - Source URL string.
 * @param queryParts - String to be appended to the URL query.
 * @returns An updated URL string.
 */
function appendToURLQuery(url, queryParts) {
    const urlParsed = new URL(url);
    let query = urlParsed.search;
    if (query) {
        query += "&" + queryParts;
    }
    else {
        query = queryParts;
    }
    urlParsed.search = query;
    return urlParsed.toString();
}
/**
 * Set URL path.
 *
 * @param url -
 * @param path -
 */
function setURLPath(url, path) {
    const urlParsed = new URL(url);
    urlParsed.pathname = path;
    return urlParsed.toString();
}
/**
 * Get URL scheme from an URL string.
 *
 * @param url - Source URL string
 */
function getURLScheme(url) {
    try {
        const urlParsed = new URL(url);
        return urlParsed.protocol.endsWith(":") ? urlParsed.protocol.slice(0, -1) : urlParsed.protocol;
    }
    catch (e) {
        return undefined;
    }
}
/**
 * Get URL path and query from an URL string.
 *
 * @param url - Source URL string
 */
function getURLPathAndQuery(url) {
    const urlParsed = new URL(url);
    const pathString = urlParsed.pathname;
    if (!pathString) {
        throw new RangeError("Invalid url without valid path.");
    }
    let queryString = urlParsed.search || "";
    queryString = queryString.trim();
    if (queryString !== "") {
        queryString = queryString.startsWith("?") ? queryString : `?${queryString}`; // Ensure query string start with '?'
    }
    return `${pathString}${queryString}`;
}
/**
 * Set URL query string.
 *
 * @param url -
 * @param queryString -
 */
function setURLQueries(url, queryString) {
    const urlParsed = new URL(url);
    urlParsed.search = queryString;
    return urlParsed.toString();
}
/**
 * Rounds a date off to seconds.
 *
 * @param date -
 * @param withMilliseconds - If true, YYYY-MM-DDThh:mm:ss.fffffffZ will be returned;
 *                                          If false, YYYY-MM-DDThh:mm:ssZ will be returned.
 * @returns Date string in ISO8061 format, with or without 7 milliseconds component
 */
function truncatedISO8061Date(date, withMilliseconds = true) {
    // Date.toISOString() will return like "2018-10-29T06:34:36.139Z"
    const dateString = date.toISOString();
    return withMilliseconds
        ? dateString.substring(0, dateString.length - 1) + "0000" + "Z"
        : dateString.substring(0, dateString.length - 5) + "Z";
}
/**
 * Base64 encode.
 *
 * @param content -
 */
function base64encode(content) {
    return !coreUtil.isNode ? btoa(content) : Buffer.from(content).toString("base64");
}
/**
 * If two strings are equal when compared case insensitive.
 *
 * @param str1 -
 * @param str2 -
 */
function iEqual(str1, str2) {
    return str1.toLocaleLowerCase() === str2.toLocaleLowerCase();
}
/**
 * Extracts account name from the url
 * @param url - url to extract the account name from
 * @returns with the account name
 */
function getAccountNameFromUrl(url) {
    const parsedUrl = new URL(url);
    let accountName;
    try {
        if (parsedUrl.hostname.split(".")[1] === "blob") {
            // `${defaultEndpointsProtocol}://${accountName}.blob.${endpointSuffix}`;
            accountName = parsedUrl.hostname.split(".")[0];
        }
        else if (isIpEndpointStyle(parsedUrl)) {
            // IPv4/IPv6 address hosts... Example - http://192.0.0.10:10001/devstoreaccount1/
            // Single word domain without a [dot] in the endpoint... Example - http://localhost:10001/devstoreaccount1/
            // .getPath() -> /devstoreaccount1/
            accountName = parsedUrl.pathname.split("/")[1];
        }
        else {
            // Custom domain case: "https://customdomain.com/containername/blob".
            accountName = "";
        }
        return accountName;
    }
    catch (error) {
        throw new Error("Unable to extract accountName with provided information.");
    }
}
function isIpEndpointStyle(parsedUrl) {
    const host = parsedUrl.host;
    // Case 1: Ipv6, use a broad regex to find out candidates whose host contains two ':'.
    // Case 2: localhost(:port) or host.docker.internal, use broad regex to match port part.
    // Case 3: Ipv4, use broad regex which just check if host contains Ipv4.
    // For valid host please refer to https://man7.org/linux/man-pages/man7/hostname.7.html.
    return (/^.*:.*:.*$|^(localhost|host.docker.internal)(:[0-9]+)?$|^(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])(\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])){3}(:[0-9]+)?$/.test(host) ||
        (Boolean(parsedUrl.port) && PathStylePorts.includes(parsedUrl.port)));
}
/**
 * This is to convert a Windows File Time ticks to a Date object.
 */
function windowsFileTimeTicksToTime(timeNumber) {
    if (!timeNumber)
        return undefined;
    // A windows file time is a 64-bit value that represents the number of 100-nanosecond intervals that have elapsed
    // since 12:00 A.M. January 1, 1601 Coordinated Universal Time (UTC).
    // JS Date accepts a value that represents milliseconds from 12:00 A.M. January 1, 1970
    // So, we'll handle the calculations in milliseconds from here
    // Time in milliseconds since "12:00 A.M. January 1, 1601"
    const timeElapsed = parseInt(timeNumber) / 10000;
    if (timeElapsed === 0)
        return undefined;
    // Reference - https://stackoverflow.com/a/24188106/4137356
    // Milliseconds calculated relative to "12:00 A.M. January 1, 1970" (will be negative)
    const initialFrameOfReference = Date.UTC(1601, 0, 1);
    // TimeRelativeTo1970 = (TimeAt1601 - TimeAt1970) + (Current - TimeAt1601) = (Current - TimeAt1970)
    return new Date(initialFrameOfReference + timeElapsed);
}
function ensureCpkIfSpecified(cpk, isHttps) {
    if (cpk && !isHttps) {
        throw new RangeError("Customer-provided encryption key must be used over HTTPS.");
    }
    if (cpk && !cpk.encryptionAlgorithm) {
        cpk.encryptionAlgorithm = EncryptionAlgorithmAES25;
    }
}
/**
 * Escape the file or directory name but keep path separator ('/').
 */
function EscapePath(pathName) {
    const split = pathName.split("/");
    for (let i = 0; i < split.length; i++) {
        split[i] = encodeURIComponent(split[i]);
    }
    return split.join("/");
}
/**
 * A typesafe helper for ensuring that a given response object has
 * the original _response attached.
 * @param response - A response object from calling a client operation
 * @returns The same object, but with known _response property
 */
function assertResponse(response) {
    if (`_response` in response) {
        return response;
    }
    throw new TypeError(`Unexpected response object ${response}`);
}
function ParseHeaderValue(rawResponse, headerName) {
    if (rawResponse._response) {
        const headers = rawResponse._response.headers;
        if (headers) {
            return headers.get(headerName);
        }
    }
    return undefined;
}
/**
 * Parse extra properties values from headers in raw response.
 */
function ParsePathGetPropertiesExtraHeaderValues(rawResponse) {
    var _a;
    const response = rawResponse;
    response.encryptionContext = ParseHeaderValue(rawResponse, "x-ms-encryption-context");
    response.owner = ParseHeaderValue(rawResponse, "x-ms-owner");
    response.group = ParseHeaderValue(rawResponse, "x-ms-group");
    response.permissions = toPermissions(ParseHeaderValue(rawResponse, "x-ms-permissions"));
    response.acl = toAcl(ParseHeaderValue(rawResponse, "x-ms-acl"));
    if ((_a = response._response) === null || _a === void 0 ? void 0 : _a.parsedHeaders) {
        response._response.parsedHeaders.encryptionContext = response.encryptionContext;
        response._response.parsedHeaders.owner = response.owner;
        response._response.parsedHeaders.group = response.group;
        response._response.parsedHeaders.permissions = response.permissions;
        response._response.parsedHeaders.acl = response.acl;
    }
    return response;
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Get a blob endpoint URL from incoming blob or dfs endpoint URLs.
 * Only handle known host name pair patterns, add more patterns into ToBlobEndpointHostMappings in constants.ts.
 *
 * Expected input and outputs:
 * http://account.blob.core.windows.net     - http://account.blob.core.windows.net
 * http://account.dfs.core.windows.net      - http://account.blob.core.windows.net
 * http://127.0.0.1:10000                   - http://127.0.0.1:10000
 * http://account.blob.core.windows.net/abc - http://account.blob.core.windows.net/abc
 * http://account.dfs.core.windows.net/abc  - http://account.blob.core.windows.net/abc
 * http://127.0.0.1:10000/abc               - http://127.0.0.1:10000/abc
 *
 * @param url -
 */
function toBlobEndpointUrl(url) {
    return mapHostUrl(url, ToBlobEndpointHostMappings, "toBlobEndpointUrl");
}
/**
 * Get a dfs endpoint URL from incoming blob or dfs endpoint URLs.
 * Only handle known host name pair patterns, add more patterns into ToDfsEndpointHostMappings in constants.ts.
 *
 * Expected input and outputs:
 * http://account.blob.core.windows.net     - http://account.dfs.core.windows.net
 * http://account.dfs.core.windows.net      - http://account.dfs.core.windows.net
 * http://127.0.0.1:10000                   - http://127.0.0.1:10000
 * http://account.blob.core.windows.net/abc - http://account.dfs.core.windows.net/abc
 * http://account.dfs.core.windows.net/abc  - http://account.dfs.core.windows.net/abc
 * http://127.0.0.1:10000/abc               - http://127.0.0.1:10000/abc
 *
 * @param url -
 */
function toDfsEndpointUrl(url) {
    return mapHostUrl(url, ToDfsEndpointHostMappings, "toDfsEndpointUrl");
}
function mapHostUrl(url, hostMappings, callerMethodName) {
    let urlParsed;
    try {
        urlParsed = new URL(url);
    }
    catch (e) {
        // invalid urls are returned unmodified
        return url;
    }
    let host = urlParsed.hostname;
    if (host === undefined) {
        throw RangeError(`${callerMethodName}() parameter url ${url} doesn't include valid host.`);
    }
    for (const mapping of hostMappings) {
        if (host.includes(mapping[0])) {
            host = host.replace(mapping[0], mapping[1]);
            break;
        }
    }
    urlParsed.hostname = host;
    const result = urlParsed.toString();
    // don't add a trailing slash if one wasn't already present
    if (!url.endsWith("/") && result.endsWith("/")) {
        return result.slice(0, -1);
    }
    else {
        return result;
    }
}
function toFileSystemAsyncIterableIterator(iter) {
    return {
        async next() {
            const rawResult = await iter.next();
            if (rawResult.value) {
                rawResult.value.fileSystemItems = rawResult.value.containerItems.map((val) => {
                    return Object.assign(Object.assign({}, val), { versionId: val.version, properties: Object.assign(Object.assign({}, val.properties), { publicAccess: toPublicAccessType(val.properties.publicAccess) }) });
                });
            }
            return rawResult;
        },
        [Symbol.asyncIterator]() {
            return this;
        },
    };
}
function toFileSystemPagedAsyncIterableIterator(iter) {
    return {
        async next() {
            const rawResult = await iter.next();
            const result = rawResult;
            if (!result.done && !rawResult.done) {
                result.value.properties.publicAccess = toPublicAccessType(rawResult.value.properties.publicAccess);
                result.value.versionId = rawResult.value.version;
            }
            return result;
        },
        [Symbol.asyncIterator]() {
            return this;
        },
        byPage(settings = {}) {
            return toFileSystemAsyncIterableIterator(iter.byPage(settings));
        },
    };
}
function toContainerPublicAccessType(publicAccessType) {
    if (!publicAccessType) {
        return undefined;
    }
    switch (publicAccessType) {
        case "filesystem":
            return "container";
        case "file":
            return "blob";
        default:
            throw TypeError(`toContainerPublicAccessType() parameter ${publicAccessType} is not recognized.`);
    }
}
function toPublicAccessType(containerPublicAccessType) {
    if (!containerPublicAccessType) {
        return undefined;
    }
    switch (containerPublicAccessType) {
        case "container":
            return "filesystem";
        case "blob":
            return "file";
        default:
            throw TypeError(`toPublicAccessType() parameter ${containerPublicAccessType} is not recognized.`);
    }
}
function toProperties(metadata) {
    if (metadata === undefined) {
        return undefined;
    }
    const properties = [];
    for (const key in metadata) {
        if (Object.prototype.hasOwnProperty.call(metadata, key)) {
            const value = metadata[key];
            properties.push(`${key}=${base64encode(value)}`);
        }
    }
    return properties.join(",");
}
function toRolePermissions(permissionsString) {
    const error = new RangeError(`toRolePermissions() Invalid role permissions string ${permissionsString}`);
    if (permissionsString.length !== 3) {
        throw error;
    }
    permissionsString = permissionsString.toLowerCase();
    let read = false;
    if (permissionsString[0] === "r") {
        read = true;
    }
    else if (permissionsString[0] !== "-") {
        throw error;
    }
    let write = false;
    if (permissionsString[1] === "w") {
        write = true;
    }
    else if (permissionsString[1] !== "-") {
        throw error;
    }
    let execute = false;
    if (permissionsString[2] === "x") {
        execute = true;
    }
    else if (permissionsString[2] !== "-") {
        throw error;
    }
    return { read, write, execute };
}
function toPermissions(permissionsString) {
    if (permissionsString === undefined || permissionsString === "" || permissionsString === null) {
        return undefined;
    }
    if (permissionsString.length !== 9 && permissionsString.length !== 10) {
        throw RangeError(`toPermissions() Invalid permissions string ${permissionsString}`);
    }
    let stickyBit = false;
    if (permissionsString[8] === "t") {
        stickyBit = true;
        const firstPart = permissionsString.substr(0, 8);
        const lastPart = permissionsString.substr(9);
        permissionsString = firstPart + "x" + lastPart;
    }
    else if (permissionsString[8] === "T") {
        stickyBit = true;
        const firstPart = permissionsString.substr(0, 8);
        const lastPart = permissionsString.substr(9);
        permissionsString = firstPart + "-" + lastPart;
    }
    // Case insensitive
    permissionsString = permissionsString.toLowerCase();
    let extendedAcls = false;
    if (permissionsString.length === 10) {
        if (permissionsString[9] === "+") {
            extendedAcls = true;
        }
        else {
            throw RangeError(`toPermissions() Invalid extendedAcls bit ${permissionsString[9]} in permissions string ${permissionsString}`);
        }
    }
    const owner = toRolePermissions(permissionsString.substr(0, 3));
    const group = toRolePermissions(permissionsString.substr(3, 3));
    const other = toRolePermissions(permissionsString.substr(6, 3));
    return {
        owner,
        group,
        other,
        stickyBit,
        extendedAcls,
    };
}
function toAccessControlItem(aclItemString) {
    const error = new RangeError(`toAccessControlItem() Parameter access control item string ${aclItemString} is not valid.`);
    if (aclItemString === "") {
        throw error;
    }
    aclItemString = aclItemString.toLowerCase();
    const parts = aclItemString.split(":");
    if (parts.length < 3 || parts.length > 4) {
        throw error;
    }
    let defaultScope = false;
    let index = 0;
    if (parts.length === 4) {
        if (parts[index] !== "default") {
            throw error;
        }
        defaultScope = true;
        index++;
    }
    const accessControlType = parts[index++];
    if (accessControlType !== "user" &&
        accessControlType !== "group" &&
        accessControlType !== "mask" &&
        accessControlType !== "other") {
        throw error;
    }
    const entityId = parts[index++];
    const permissions = toRolePermissions(parts[index++]);
    return {
        defaultScope,
        accessControlType,
        entityId,
        permissions,
    };
}
function toAcl(aclString) {
    if (aclString === undefined || aclString === "" || aclString === null) {
        return [];
    }
    const acls = [];
    const aclParts = aclString.split(",");
    for (const aclPart of aclParts) {
        acls.push(toAccessControlItem(aclPart));
    }
    return acls;
}
function toAccessControlItemString(item) {
    const entityIdString = item.entityId !== undefined ? `:${item.entityId}` : "";
    const permissionsString = item.permissions !== undefined ? `:${toRolePermissionsString(item.permissions)}` : "";
    return `${item.defaultScope ? "default:" : ""}${item.accessControlType}${entityIdString}${permissionsString}`;
}
function toAclString(acl) {
    return acl.map(toAccessControlItemString).join(",");
}
function toRolePermissionsString(p, stickyBit = false) {
    return `${p.read ? "r" : "-"}${p.write ? "w" : "-"}${stickyBit ? (p.execute ? "t" : "T") : p.execute ? "x" : "-"}`;
}
function toPermissionsString(permissions) {
    return `${toRolePermissionsString(permissions.owner)}${toRolePermissionsString(permissions.group)}${toRolePermissionsString(permissions.other, permissions.stickyBit)}${permissions.extendedAcls ? "+" : ""}`;
}
function toAccessControlChangeFailureArray(aclFailedEntries = []) {
    return aclFailedEntries.map((aclFailedEntry) => {
        return {
            name: aclFailedEntry.name || "",
            isDirectory: (aclFailedEntry.type || "").toLowerCase() === "directory",
            message: aclFailedEntry.errorMessage || "",
        };
    });
}
function toBlobCpkInfo(input) {
    return input
        ? {
            encryptionKey: input.encryptionKey,
            encryptionKeySha256: input.encryptionKeySha256,
            encryptionAlgorithm: "AES256",
        }
        : undefined;
}

// This function relies on the Pipeline already being initialized by a storage-blob client
function getCoreClientOptions(pipeline) {
    const _a = pipeline.options, { httpClient: v1Client } = _a, restOptions = tslib.__rest(_a, ["httpClient"]);
    const httpClient = pipeline._coreHttpClient;
    if (!httpClient) {
        throw new Error("Pipeline not correctly initialized; missing V2 HttpClient");
    }
    const corePipeline = pipeline._corePipeline;
    if (!corePipeline) {
        throw new Error("Pipeline not correctly initialized; missing V2 Pipeline");
    }
    return Object.assign(Object.assign({}, restOptions), { allowInsecureConnection: true, httpClient, pipeline: corePipeline });
}
/**
 * A StorageClient represents a based URL class for {@link BlobServiceClient}, {@link ContainerClient}
 * and etc.
 */
class StorageClient {
    /**
     * Creates an instance of StorageClient.
     * @param url - url to resource
     * @param pipeline - request policy pipeline.
     */
    constructor(url, pipeline) {
        // URL should be encoded and only once, protocol layer shouldn't encode URL again
        this.url = escapeURLPath(url);
        this.blobEndpointUrl = toBlobEndpointUrl(this.url);
        this.dfsEndpointUrl = toDfsEndpointUrl(this.url);
        this.accountName = getAccountNameFromUrl(this.blobEndpointUrl);
        this.pipeline = pipeline;
        // creating this BlobServiceClient allows us to use the converted V2 Pipeline attached to `pipeline`.
        const blobClient = new storageBlob.BlobServiceClient(url, pipeline);
        this.storageClientContext = new StorageContextClient(this.dfsEndpointUrl, getCoreClientOptions(pipeline));
        this.storageClientContextToBlobEndpoint = new StorageContextClient(this.blobEndpointUrl, getCoreClientOptions(pipeline));
        this.isHttps = iEqual(getURLScheme(this.url) || "", "https");
        this.credential = blobClient.credential;
        // Override protocol layer's default content-type
        const storageClientContext = this.storageClientContext;
        storageClientContext.requestContentType = undefined;
        const storageClientContextWithBlobEndpoint = this.storageClientContextToBlobEndpoint;
        storageClientContextWithBlobEndpoint.requestContentType = undefined;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * This class generates a readable stream from the data in an array of buffers.
 */
class BuffersStream extends stream.Readable {
    /**
     * Creates an instance of BuffersStream that will emit the data
     * contained in the array of buffers.
     *
     * @param buffers - Array of buffers containing the data
     * @param byteLength - The total length of data contained in the buffers
     */
    constructor(buffers, byteLength, options) {
        super(options);
        this.buffers = buffers;
        this.byteLength = byteLength;
        this.byteOffsetInCurrentBuffer = 0;
        this.bufferIndex = 0;
        this.pushedBytesLength = 0;
        // check byteLength is no larger than buffers[] total length
        let buffersLength = 0;
        for (const buf of this.buffers) {
            buffersLength += buf.byteLength;
        }
        if (buffersLength < this.byteLength) {
            throw new Error("Data size shouldn't be larger than the total length of buffers.");
        }
    }
    /**
     * Internal _read() that will be called when the stream wants to pull more data in.
     *
     * @param size - Optional. The size of data to be read
     */
    _read(size) {
        if (this.pushedBytesLength >= this.byteLength) {
            this.push(null);
        }
        if (!size) {
            size = this.readableHighWaterMark;
        }
        const outBuffers = [];
        let i = 0;
        while (i < size && this.pushedBytesLength < this.byteLength) {
            // The last buffer may be longer than the data it contains.
            const remainingDataInAllBuffers = this.byteLength - this.pushedBytesLength;
            const remainingCapacityInThisBuffer = this.buffers[this.bufferIndex].byteLength - this.byteOffsetInCurrentBuffer;
            const remaining = Math.min(remainingCapacityInThisBuffer, remainingDataInAllBuffers);
            if (remaining > size - i) {
                // chunkSize = size - i
                const end = this.byteOffsetInCurrentBuffer + size - i;
                outBuffers.push(this.buffers[this.bufferIndex].slice(this.byteOffsetInCurrentBuffer, end));
                this.pushedBytesLength += size - i;
                this.byteOffsetInCurrentBuffer = end;
                i = size;
                break;
            }
            else {
                // chunkSize = remaining
                const end = this.byteOffsetInCurrentBuffer + remaining;
                outBuffers.push(this.buffers[this.bufferIndex].slice(this.byteOffsetInCurrentBuffer, end));
                if (remaining === remainingCapacityInThisBuffer) {
                    // this.buffers[this.bufferIndex] used up, shift to next one
                    this.byteOffsetInCurrentBuffer = 0;
                    this.bufferIndex++;
                }
                else {
                    this.byteOffsetInCurrentBuffer = end;
                }
                this.pushedBytesLength += remaining;
                i += remaining;
            }
        }
        if (outBuffers.length > 1) {
            this.push(Buffer.concat(outBuffers));
        }
        else if (outBuffers.length === 1) {
            this.push(outBuffers[0]);
        }
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
const maxBufferLength = buffer.constants.MAX_LENGTH;
/**
 * This class provides a buffer container which conceptually has no hard size limit.
 * It accepts a capacity, an array of input buffers and the total length of input data.
 * It will allocate an internal "buffer" of the capacity and fill the data in the input buffers
 * into the internal "buffer" serially with respect to the total length.
 * Then by calling PooledBuffer.getReadableStream(), you can get a readable stream
 * assembled from all the data in the internal "buffer".
 */
class PooledBuffer {
    /**
     * The size of the data contained in the pooled buffers.
     */
    get size() {
        return this._size;
    }
    constructor(capacity, buffers, totalLength) {
        /**
         * Internal buffers used to keep the data.
         * Each buffer has a length of the maxBufferLength except last one.
         */
        this.buffers = [];
        this.capacity = capacity;
        this._size = 0;
        // allocate
        const bufferNum = Math.ceil(capacity / maxBufferLength);
        for (let i = 0; i < bufferNum; i++) {
            let len = i === bufferNum - 1 ? capacity % maxBufferLength : maxBufferLength;
            if (len === 0) {
                len = maxBufferLength;
            }
            this.buffers.push(Buffer.allocUnsafe(len));
        }
        if (buffers) {
            this.fill(buffers, totalLength);
        }
    }
    /**
     * Fill the internal buffers with data in the input buffers serially
     * with respect to the total length and the total capacity of the internal buffers.
     * Data copied will be shift out of the input buffers.
     *
     * @param buffers - Input buffers containing the data to be filled in the pooled buffer
     * @param totalLength - Total length of the data to be filled in.
     *
     */
    fill(buffers, totalLength) {
        this._size = Math.min(this.capacity, totalLength);
        let i = 0, j = 0, targetOffset = 0, sourceOffset = 0, totalCopiedNum = 0;
        while (totalCopiedNum < this._size) {
            const source = buffers[i];
            const target = this.buffers[j];
            const copiedNum = source.copy(target, targetOffset, sourceOffset);
            totalCopiedNum += copiedNum;
            sourceOffset += copiedNum;
            targetOffset += copiedNum;
            if (sourceOffset === source.length) {
                i++;
                sourceOffset = 0;
            }
            if (targetOffset === target.length) {
                j++;
                targetOffset = 0;
            }
        }
        // clear copied from source buffers
        buffers.splice(0, i);
        if (buffers.length > 0) {
            buffers[0] = buffers[0].slice(sourceOffset);
        }
    }
    /**
     * Get the readable stream assembled from all the data in the internal buffers.
     *
     */
    getReadableStream() {
        return new BuffersStream(this.buffers, this.size);
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * This class accepts a Node.js Readable stream as input, and keeps reading data
 * from the stream into the internal buffer structure, until it reaches maxBuffers.
 * Every available buffer will try to trigger outgoingHandler.
 *
 * The internal buffer structure includes an incoming buffer array, and a outgoing
 * buffer array. The incoming buffer array includes the "empty" buffers can be filled
 * with new incoming data. The outgoing array includes the filled buffers to be
 * handled by outgoingHandler. Every above buffer size is defined by parameter bufferSize.
 *
 * NUM_OF_ALL_BUFFERS = BUFFERS_IN_INCOMING + BUFFERS_IN_OUTGOING + BUFFERS_UNDER_HANDLING
 *
 * NUM_OF_ALL_BUFFERS lesser than or equal to maxBuffers
 *
 * PERFORMANCE IMPROVEMENT TIPS:
 * 1. Input stream highWaterMark is better to set a same value with bufferSize
 *    parameter, which will avoid Buffer.concat() operations.
 * 2. concurrency should set a smaller value than maxBuffers, which is helpful to
 *    reduce the possibility when a outgoing handler waits for the stream data.
 *    in this situation, outgoing handlers are blocked.
 *    Outgoing queue shouldn't be empty.
 */
class BufferScheduler {
    /**
     * Creates an instance of BufferScheduler.
     *
     * @param readable - A Node.js Readable stream
     * @param bufferSize - Buffer size of every maintained buffer
     * @param maxBuffers - How many buffers can be allocated
     * @param outgoingHandler - An async function scheduled to be
     *                                          triggered when a buffer fully filled
     *                                          with stream data
     * @param concurrency - Concurrency of executing outgoingHandlers (>0)
     * @param encoding - [Optional] Encoding of Readable stream when it's a string stream
     */
    constructor(readable, bufferSize, maxBuffers, outgoingHandler, concurrency, encoding) {
        /**
         * An internal event emitter.
         */
        this.emitter = new events.EventEmitter();
        /**
         * An internal offset marker to track data offset in bytes of next outgoingHandler.
         */
        this.offset = 0;
        /**
         * An internal marker to track whether stream is end.
         */
        this.isStreamEnd = false;
        /**
         * An internal marker to track whether stream or outgoingHandler returns error.
         */
        this.isError = false;
        /**
         * How many handlers are executing.
         */
        this.executingOutgoingHandlers = 0;
        /**
         * How many buffers have been allocated.
         */
        this.numBuffers = 0;
        /**
         * Because this class doesn't know how much data every time stream pops, which
         * is defined by highWaterMarker of the stream. So BufferScheduler will cache
         * data received from the stream, when data in unresolvedDataArray exceeds the
         * blockSize defined, it will try to concat a blockSize of buffer, fill into available
         * buffers from incoming and push to outgoing array.
         */
        this.unresolvedDataArray = [];
        /**
         * How much data consisted in unresolvedDataArray.
         */
        this.unresolvedLength = 0;
        /**
         * The array includes all the available buffers can be used to fill data from stream.
         */
        this.incoming = [];
        /**
         * The array (queue) includes all the buffers filled from stream data.
         */
        this.outgoing = [];
        if (bufferSize <= 0) {
            throw new RangeError(`bufferSize must be larger than 0, current is ${bufferSize}`);
        }
        if (maxBuffers <= 0) {
            throw new RangeError(`maxBuffers must be larger than 0, current is ${maxBuffers}`);
        }
        if (concurrency <= 0) {
            throw new RangeError(`concurrency must be larger than 0, current is ${concurrency}`);
        }
        this.bufferSize = bufferSize;
        this.maxBuffers = maxBuffers;
        this.readable = readable;
        this.outgoingHandler = outgoingHandler;
        this.concurrency = concurrency;
        this.encoding = encoding;
    }
    /**
     * Start the scheduler, will return error when stream of any of the outgoingHandlers
     * returns error.
     *
     */
    async do() {
        return new Promise((resolve, reject) => {
            this.readable.on("data", (data) => {
                data = typeof data === "string" ? Buffer.from(data, this.encoding) : data;
                this.appendUnresolvedData(data);
                if (!this.resolveData()) {
                    this.readable.pause();
                }
            });
            this.readable.on("error", (err) => {
                this.emitter.emit("error", err);
            });
            this.readable.on("end", () => {
                this.isStreamEnd = true;
                this.emitter.emit("checkEnd");
            });
            this.emitter.on("error", (err) => {
                this.isError = true;
                this.readable.pause();
                reject(err);
            });
            this.emitter.on("checkEnd", () => {
                if (this.outgoing.length > 0) {
                    this.triggerOutgoingHandlers();
                    return;
                }
                if (this.isStreamEnd && this.executingOutgoingHandlers === 0) {
                    if (this.unresolvedLength > 0 && this.unresolvedLength < this.bufferSize) {
                        const buffer = this.shiftBufferFromUnresolvedDataArray();
                        this.outgoingHandler(() => buffer.getReadableStream(), buffer.size, this.offset)
                            .then(resolve)
                            .catch(reject);
                    }
                    else if (this.unresolvedLength >= this.bufferSize) {
                        return;
                    }
                    else {
                        resolve();
                    }
                }
            });
        });
    }
    /**
     * Insert a new data into unresolved array.
     *
     * @param data -
     */
    appendUnresolvedData(data) {
        this.unresolvedDataArray.push(data);
        this.unresolvedLength += data.length;
    }
    /**
     * Try to shift a buffer with size in blockSize. The buffer returned may be less
     * than blockSize when data in unresolvedDataArray is less than bufferSize.
     *
     */
    shiftBufferFromUnresolvedDataArray(buffer) {
        if (!buffer) {
            buffer = new PooledBuffer(this.bufferSize, this.unresolvedDataArray, this.unresolvedLength);
        }
        else {
            buffer.fill(this.unresolvedDataArray, this.unresolvedLength);
        }
        this.unresolvedLength -= buffer.size;
        return buffer;
    }
    /**
     * Resolve data in unresolvedDataArray. For every buffer with size in blockSize
     * shifted, it will try to get (or allocate a buffer) from incoming, and fill it,
     * then push it into outgoing to be handled by outgoing handler.
     *
     * Return false when available buffers in incoming are not enough, else true.
     *
     * @returns Return false when buffers in incoming are not enough, else true.
     */
    resolveData() {
        while (this.unresolvedLength >= this.bufferSize) {
            let buffer;
            if (this.incoming.length > 0) {
                buffer = this.incoming.shift();
                this.shiftBufferFromUnresolvedDataArray(buffer);
            }
            else {
                if (this.numBuffers < this.maxBuffers) {
                    buffer = this.shiftBufferFromUnresolvedDataArray();
                    this.numBuffers++;
                }
                else {
                    // No available buffer, wait for buffer returned
                    return false;
                }
            }
            this.outgoing.push(buffer);
            this.triggerOutgoingHandlers();
        }
        return true;
    }
    /**
     * Try to trigger a outgoing handler for every buffer in outgoing. Stop when
     * concurrency reaches.
     */
    async triggerOutgoingHandlers() {
        let buffer;
        do {
            if (this.executingOutgoingHandlers >= this.concurrency) {
                return;
            }
            buffer = this.outgoing.shift();
            if (buffer) {
                this.triggerOutgoingHandler(buffer);
            }
        } while (buffer);
    }
    /**
     * Trigger a outgoing handler for a buffer shifted from outgoing.
     *
     * @param buffer -
     */
    async triggerOutgoingHandler(buffer) {
        const bufferLength = buffer.size;
        this.executingOutgoingHandlers++;
        this.offset += bufferLength;
        try {
            await this.outgoingHandler(() => buffer.getReadableStream(), bufferLength, this.offset - bufferLength);
        }
        catch (err) {
            this.emitter.emit("error", err);
            return;
        }
        this.executingOutgoingHandlers--;
        this.reuseBuffer(buffer);
        this.emitter.emit("checkEnd");
    }
    /**
     * Return buffer used by outgoing handler into incoming.
     *
     * @param buffer -
     */
    reuseBuffer(buffer) {
        this.incoming.push(buffer);
        if (!this.isError && this.resolveData() && !this.isStreamEnd) {
            this.readable.resume();
        }
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * UserDelegationKeyCredential is only used for generation of user delegation SAS.
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-user-delegation-sas
 */
class UserDelegationKeyCredential {
    /**
     * Creates an instance of UserDelegationKeyCredential.
     * @param accountName -
     * @param userDelegationKey -
     */
    constructor(accountName, userDelegationKey) {
        this.accountName = accountName;
        this.userDelegationKey = userDelegationKey;
        this.key = Buffer.from(userDelegationKey.value, "base64");
    }
    /**
     * Generates a hash signature for an HTTP request or for a SAS.
     *
     * @param stringToSign -
     */
    computeHMACSHA256(stringToSign) {
        // console.log(`stringToSign: ${JSON.stringify(stringToSign)}`);
        return crypto.createHmac("sha256", this.key).update(stringToSign, "utf8").digest("base64");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * This is a helper class to construct a string representing the permissions granted by a ServiceSAS. Setting
 * a value to true means that any SAS which uses these permissions will grant permissions for that operation. Once all
 * the values are set, this should be serialized with toString and set as the permissions field on a
 * {@link DataLakeSASSignatureValues} object. It is possible to construct the permissions string without this class, but
 * the order of the permissions is particular and this class guarantees correctness.
 */
class DataLakeSASPermissions {
    constructor() {
        /**
         * Specifies Read access granted.
         */
        this.read = false;
        /**
         * Specifies Add access granted.
         */
        this.add = false;
        /**
         * Specifies Create access granted.
         */
        this.create = false;
        /**
         * Specifies Write access granted.
         */
        this.write = false;
        /**
         * Specifies Delete access granted.
         */
        this.delete = false;
        /**
         * Specifies Move access granted.
         */
        this.move = false;
        /**
         * Specifies Execute access granted.
         */
        this.execute = false;
        /**
         * Specifies Ownership access granted, which allows the caller to set owner, owning group,
         * or act as the owner when renaming or deleting a blob (file or directory) within a folder
         * that has the sticky bit set.
         */
        this.manageOwnership = false;
        /**
         * Specifies Permission access granted, which allows the caller to set permissions and
         * POSIX ACLs on blobs (files and directories).
         */
        this.manageAccessControl = false;
    }
    /**
     * Creates a {@link DataLakeSASPermissions} from the specified permissions string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid permission.
     *
     * @param permissions -
     */
    static parse(permissions) {
        const blobSASPermissions = new DataLakeSASPermissions();
        for (const char of permissions) {
            switch (char) {
                case "r":
                    blobSASPermissions.read = true;
                    break;
                case "a":
                    blobSASPermissions.add = true;
                    break;
                case "c":
                    blobSASPermissions.create = true;
                    break;
                case "w":
                    blobSASPermissions.write = true;
                    break;
                case "d":
                    blobSASPermissions.delete = true;
                    break;
                case "m":
                    blobSASPermissions.move = true;
                    break;
                case "e":
                    blobSASPermissions.execute = true;
                    break;
                case "o":
                    blobSASPermissions.manageOwnership = true;
                    break;
                case "p":
                    blobSASPermissions.manageAccessControl = true;
                    break;
                default:
                    throw new RangeError(`Invalid permission: ${char}`);
            }
        }
        return blobSASPermissions;
    }
    /**
     * Converts the given permissions to a string. Using this method will guarantee the permissions are in an
     * order accepted by the service.
     *
     * @returns A string which represents the DataLakeSASPermissions
     */
    toString() {
        const permissions = [];
        if (this.read) {
            permissions.push("r");
        }
        if (this.add) {
            permissions.push("a");
        }
        if (this.create) {
            permissions.push("c");
        }
        if (this.write) {
            permissions.push("w");
        }
        if (this.delete) {
            permissions.push("d");
        }
        if (this.move) {
            permissions.push("m");
        }
        if (this.execute) {
            permissions.push("e");
        }
        if (this.manageOwnership) {
            permissions.push("o");
        }
        if (this.manageAccessControl) {
            permissions.push("p");
        }
        return permissions.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * This is a helper class to construct a string representing the permissions granted by a ServiceSAS to a container.
 * Setting a value to true means that any SAS which uses these permissions will grant permissions for that operation.
 * Once all the values are set, this should be serialized with toString and set as the permissions field on a
 * {@link DataLakeSASSignatureValues} object. It is possible to construct the permissions string without this class, but
 * the order of the permissions is particular and this class guarantees correctness.
 */
class FileSystemSASPermissions {
    constructor() {
        /**
         * Specifies Read access granted.
         */
        this.read = false;
        /**
         * Specifies Add access granted.
         */
        this.add = false;
        /**
         * Specifies Create access granted.
         */
        this.create = false;
        /**
         * Specifies Write access granted.
         */
        this.write = false;
        /**
         * Specifies Delete access granted.
         */
        this.delete = false;
        /**
         * Specifies List access granted.
         */
        this.list = false;
        /**
         * Specifies Move access granted.
         */
        this.move = false;
        /**
         * Specifies Execute access granted.
         */
        this.execute = false;
        /**
         * Specifies Ownership access granted, which allows the caller to set owner, owning group,
         * or act as the owner when renaming or deleting a blob (file or directory) within a folder
         * that has the sticky bit set.
         */
        this.manageOwnership = false;
        /**
         * Specifies Permission access granted, which allows the caller to set permissions and
         * POSIX ACLs on blobs (files and directories).
         */
        this.manageAccessControl = false;
    }
    /**
     * Creates an {@link FileSystemSASPermissions} from the specified permissions string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid permission.
     *
     * @param permissions -
     */
    static parse(permissions) {
        const containerSASPermissions = new FileSystemSASPermissions();
        for (const char of permissions) {
            switch (char) {
                case "r":
                    containerSASPermissions.read = true;
                    break;
                case "a":
                    containerSASPermissions.add = true;
                    break;
                case "c":
                    containerSASPermissions.create = true;
                    break;
                case "w":
                    containerSASPermissions.write = true;
                    break;
                case "d":
                    containerSASPermissions.delete = true;
                    break;
                case "l":
                    containerSASPermissions.list = true;
                    break;
                case "m":
                    containerSASPermissions.move = true;
                    break;
                case "e":
                    containerSASPermissions.execute = true;
                    break;
                case "o":
                    containerSASPermissions.manageOwnership = true;
                    break;
                case "p":
                    containerSASPermissions.manageAccessControl = true;
                    break;
                default:
                    throw new RangeError(`Invalid permission ${char}`);
            }
        }
        return containerSASPermissions;
    }
    /**
     * Converts the given permissions to a string. Using this method will guarantee the permissions are in an
     * order accepted by the service.
     *
     * The order of the characters should be as specified here to ensure correctness.
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     */
    toString() {
        const permissions = [];
        if (this.read) {
            permissions.push("r");
        }
        if (this.add) {
            permissions.push("a");
        }
        if (this.create) {
            permissions.push("c");
        }
        if (this.write) {
            permissions.push("w");
        }
        if (this.delete) {
            permissions.push("d");
        }
        if (this.list) {
            permissions.push("l");
        }
        if (this.move) {
            permissions.push("m");
        }
        if (this.execute) {
            permissions.push("e");
        }
        if (this.manageOwnership) {
            permissions.push("o");
        }
        if (this.manageAccessControl) {
            permissions.push("p");
        }
        return permissions.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Generate SasIPRange format string. For example:
 *
 * "8.8.8.8" or "1.1.1.1-255.255.255.255"
 *
 * @param ipRange -
 */
function ipRangeToString(ipRange) {
    return ipRange.end ? `${ipRange.start}-${ipRange.end}` : ipRange.start;
}

/**
 * Protocols for generated SAS.
 */
exports.SASProtocol = void 0;
(function (SASProtocol) {
    /**
     * Protocol that allows HTTPS only
     */
    SASProtocol["Https"] = "https";
    /**
     * Protocol that allows both HTTPS and HTTP
     */
    SASProtocol["HttpsAndHttp"] = "https,http";
})(exports.SASProtocol || (exports.SASProtocol = {}));
/**
 * Represents the components that make up an Azure Storage SAS' query parameters. This type is not constructed directly
 * by the user; it is only generated by the {@link AccountSASSignatureValues} and {@link BlobSASSignatureValues}
 * types. Once generated, it can be encoded into a {@link String} and appended to a URL directly (though caution should
 * be taken here in case there are existing query parameters, which might affect the appropriate means of appending
 * these query parameters).
 *
 * NOTE: Instances of this class are immutable.
 */
class SASQueryParameters {
    /**
     * Optional. IP range allowed for this SAS.
     *
     * @readonly
     */
    get ipRange() {
        if (this.ipRangeInner) {
            return {
                end: this.ipRangeInner.end,
                start: this.ipRangeInner.start,
            };
        }
        return undefined;
    }
    constructor(version, signature, permissionsOrOptions, services, resourceTypes, protocol, startsOn, expiresOn, ipRange, identifier, resource, cacheControl, contentDisposition, contentEncoding, contentLanguage, contentType, userDelegationKey, directoryDepth, preauthorizedAgentObjectId, agentObjectId, correlationId, encryptionScope) {
        this.version = version;
        this.signature = signature;
        if (permissionsOrOptions !== undefined && typeof permissionsOrOptions !== "string") {
            // SASQueryParametersOptions
            const options = permissionsOrOptions;
            this.services = options.services;
            this.resourceTypes = options.resourceTypes;
            this.expiresOn = options.expiresOn;
            this.permissions = options.permissions;
            this.protocol = options.protocol;
            this.startsOn = options.startsOn;
            this.ipRangeInner = options.ipRange;
            this.identifier = options.identifier;
            this.resource = options.resource;
            this.cacheControl = options.cacheControl;
            this.contentDisposition = options.contentDisposition;
            this.contentEncoding = options.contentEncoding;
            this.contentLanguage = options.contentLanguage;
            this.contentType = options.contentType;
            this.directoryDepth = options.directoryDepth;
            this.preauthorizedAgentObjectId = options.preauthorizedAgentObjectId;
            this.agentObjectId = options.agentObjectId;
            this.correlationId = options.correlationId;
            this.encryptionScope = options.encryptionScope;
            if (options.userDelegationKey) {
                this.signedOid = options.userDelegationKey.signedObjectId;
                this.signedTenantId = options.userDelegationKey.signedTenantId;
                this.signedStartsOn = options.userDelegationKey.signedStartsOn;
                this.signedExpiresOn = options.userDelegationKey.signedExpiresOn;
                this.signedService = options.userDelegationKey.signedService;
                this.signedVersion = options.userDelegationKey.signedVersion;
            }
        }
        else {
            this.services = services;
            this.resourceTypes = resourceTypes;
            this.expiresOn = expiresOn;
            this.permissions = permissionsOrOptions;
            this.protocol = protocol;
            this.startsOn = startsOn;
            this.ipRangeInner = ipRange;
            this.identifier = identifier;
            this.resource = resource;
            this.cacheControl = cacheControl;
            this.contentDisposition = contentDisposition;
            this.contentEncoding = contentEncoding;
            this.contentLanguage = contentLanguage;
            this.contentType = contentType;
            this.directoryDepth = directoryDepth;
            this.preauthorizedAgentObjectId = preauthorizedAgentObjectId;
            this.agentObjectId = agentObjectId;
            this.correlationId = correlationId;
            this.encryptionScope = encryptionScope;
            if (userDelegationKey) {
                this.signedOid = userDelegationKey.signedObjectId;
                this.signedTenantId = userDelegationKey.signedTenantId;
                this.signedStartsOn = userDelegationKey.signedStartsOn;
                this.signedExpiresOn = userDelegationKey.signedExpiresOn;
                this.signedService = userDelegationKey.signedService;
                this.signedVersion = userDelegationKey.signedVersion;
            }
        }
    }
    /**
     * Encodes all SAS query parameters into a string that can be appended to a URL.
     *
     */
    toString() {
        var _a;
        const params = [
            "sv",
            "ss",
            "srt",
            "spr",
            "st",
            "se",
            "sip",
            "si",
            "ses",
            "skoid", // Signed object ID
            "sktid", // Signed tenant ID
            "skt", // Signed key start time
            "ske", // Signed key expiry time
            "sks", // Signed key service
            "skv", // Signed key version
            "sr",
            "sp",
            "sig",
            "rscc",
            "rscd",
            "rsce",
            "rscl",
            "rsct",
            "sdd",
            "saoid",
            "suoid",
            "scid",
        ];
        const queries = [];
        for (const param of params) {
            switch (param) {
                case "sv":
                    this.tryAppendQueryParameter(queries, param, this.version);
                    break;
                case "ss":
                    this.tryAppendQueryParameter(queries, param, this.services);
                    break;
                case "srt":
                    this.tryAppendQueryParameter(queries, param, this.resourceTypes);
                    break;
                case "spr":
                    this.tryAppendQueryParameter(queries, param, this.protocol);
                    break;
                case "st":
                    this.tryAppendQueryParameter(queries, param, this.startsOn ? truncatedISO8061Date(this.startsOn, false) : undefined);
                    break;
                case "se":
                    this.tryAppendQueryParameter(queries, param, this.expiresOn ? truncatedISO8061Date(this.expiresOn, false) : undefined);
                    break;
                case "sip":
                    this.tryAppendQueryParameter(queries, param, this.ipRange ? ipRangeToString(this.ipRange) : undefined);
                    break;
                case "si":
                    this.tryAppendQueryParameter(queries, param, this.identifier);
                    break;
                case "ses":
                    this.tryAppendQueryParameter(queries, param, this.encryptionScope);
                    break;
                case "skoid": // Signed object ID
                    this.tryAppendQueryParameter(queries, param, this.signedOid);
                    break;
                case "sktid": // Signed tenant ID
                    this.tryAppendQueryParameter(queries, param, this.signedTenantId);
                    break;
                case "skt": // Signed key start time
                    this.tryAppendQueryParameter(queries, param, this.signedStartsOn ? truncatedISO8061Date(this.signedStartsOn, false) : undefined);
                    break;
                case "ske": // Signed key expiry time
                    this.tryAppendQueryParameter(queries, param, this.signedExpiresOn ? truncatedISO8061Date(this.signedExpiresOn, false) : undefined);
                    break;
                case "sks": // Signed key service
                    this.tryAppendQueryParameter(queries, param, this.signedService);
                    break;
                case "skv": // Signed key version
                    this.tryAppendQueryParameter(queries, param, this.signedVersion);
                    break;
                case "sr":
                    this.tryAppendQueryParameter(queries, param, this.resource);
                    break;
                case "sp":
                    this.tryAppendQueryParameter(queries, param, this.permissions);
                    break;
                case "sig":
                    this.tryAppendQueryParameter(queries, param, this.signature);
                    break;
                case "rscc":
                    this.tryAppendQueryParameter(queries, param, this.cacheControl);
                    break;
                case "rscd":
                    this.tryAppendQueryParameter(queries, param, this.contentDisposition);
                    break;
                case "rsce":
                    this.tryAppendQueryParameter(queries, param, this.contentEncoding);
                    break;
                case "rscl":
                    this.tryAppendQueryParameter(queries, param, this.contentLanguage);
                    break;
                case "rsct":
                    this.tryAppendQueryParameter(queries, param, this.contentType);
                    break;
                case "sdd":
                    this.tryAppendQueryParameter(queries, param, (_a = this.directoryDepth) === null || _a === void 0 ? void 0 : _a.toString());
                    break;
                case "saoid":
                    this.tryAppendQueryParameter(queries, param, this.preauthorizedAgentObjectId);
                    break;
                case "suoid":
                    this.tryAppendQueryParameter(queries, param, this.agentObjectId);
                    break;
                case "scid":
                    this.tryAppendQueryParameter(queries, param, this.correlationId);
                    break;
            }
        }
        return queries.join("&");
    }
    /**
     * A private helper method used to filter and append query key/value pairs into an array.
     *
     * @param queries -
     * @param key -
     * @param value -
     */
    tryAppendQueryParameter(queries, key, value) {
        if (!value) {
            return;
        }
        key = encodeURIComponent(key);
        value = encodeURIComponent(value);
        if (key.length > 0 && value.length > 0) {
            queries.push(`${key}=${value}`);
        }
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * This is a helper class to construct a string representing the permissions granted by a ServiceSAS to a directory.
 * Setting a value to true means that any SAS which uses these permissions will grant permissions for that operation.
 * Once all the values are set, this should be serialized with toString and set as the permissions field on a
 * {@link DataLakeSASSignatureValues} object. It is possible to construct the permissions string without this class, but
 * the order of the permissions is particular and this class guarantees correctness.
 */
class DirectorySASPermissions {
    constructor() {
        /**
         * Specifies Read access granted.
         */
        this.read = false;
        /**
         * Specifies Add access granted.
         */
        this.add = false;
        /**
         * Specifies Create access granted.
         */
        this.create = false;
        /**
         * Specifies Write access granted.
         */
        this.write = false;
        /**
         * Specifies Delete access granted.
         */
        this.delete = false;
        /**
         * Specifies List access granted.
         */
        this.list = false;
        /**
         * Specifies Move access granted.
         */
        this.move = false;
        /**
         * Specifies Execute access granted.
         */
        this.execute = false;
        /**
         * Specifies Ownership access granted, which allows the caller to set owner, owning group,
         * or act as the owner when renaming or deleting a blob (file or directory) within a folder
         * that has the sticky bit set.
         */
        this.manageOwnership = false;
        /**
         * Specifies Permission access granted, which allows the caller to set permissions and
         * POSIX ACLs on blobs (files and directories).
         */
        this.manageAccessControl = false;
    }
    /**
     * Creates an {@link DirectorySASPermissions} from the specified permissions string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid permission.
     *
     * @param permissions -
     */
    static parse(permissions) {
        const directorySASPermissions = new DirectorySASPermissions();
        for (const char of permissions) {
            switch (char) {
                case "r":
                    directorySASPermissions.read = true;
                    break;
                case "a":
                    directorySASPermissions.add = true;
                    break;
                case "c":
                    directorySASPermissions.create = true;
                    break;
                case "w":
                    directorySASPermissions.write = true;
                    break;
                case "d":
                    directorySASPermissions.delete = true;
                    break;
                case "l":
                    directorySASPermissions.list = true;
                    break;
                case "m":
                    directorySASPermissions.move = true;
                    break;
                case "e":
                    directorySASPermissions.execute = true;
                    break;
                case "o":
                    directorySASPermissions.manageOwnership = true;
                    break;
                case "p":
                    directorySASPermissions.manageAccessControl = true;
                    break;
                default:
                    throw new RangeError(`Invalid permission ${char}`);
            }
        }
        return directorySASPermissions;
    }
    /**
     * Converts the given permissions to a string. Using this method will guarantee the permissions are in an
     * order accepted by the service.
     *
     * The order of the characters should be as specified here to ensure correctness.
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     */
    toString() {
        const permissions = [];
        if (this.read) {
            permissions.push("r");
        }
        if (this.add) {
            permissions.push("a");
        }
        if (this.create) {
            permissions.push("c");
        }
        if (this.write) {
            permissions.push("w");
        }
        if (this.delete) {
            permissions.push("d");
        }
        if (this.list) {
            permissions.push("l");
        }
        if (this.move) {
            permissions.push("m");
        }
        if (this.execute) {
            permissions.push("e");
        }
        if (this.manageOwnership) {
            permissions.push("o");
        }
        if (this.manageAccessControl) {
            permissions.push("p");
        }
        return permissions.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
function generateDataLakeSASQueryParameters(dataLakeSASSignatureValues, sharedKeyCredentialOrUserDelegationKey, accountName) {
    return generateDataLakeSASQueryParametersInternal(dataLakeSASSignatureValues, sharedKeyCredentialOrUserDelegationKey, accountName).sasQueryParameter;
}
function generateDataLakeSASQueryParametersInternal(dataLakeSASSignatureValues, sharedKeyCredentialOrUserDelegationKey, accountName) {
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    const sharedKeyCredential = sharedKeyCredentialOrUserDelegationKey instanceof storageBlob.StorageSharedKeyCredential
        ? sharedKeyCredentialOrUserDelegationKey
        : undefined;
    let userDelegationKeyCredential;
    if (sharedKeyCredential === undefined && accountName !== undefined) {
        userDelegationKeyCredential = new UserDelegationKeyCredential(accountName, sharedKeyCredentialOrUserDelegationKey);
    }
    if (sharedKeyCredential === undefined && userDelegationKeyCredential === undefined) {
        throw TypeError("Invalid sharedKeyCredential, userDelegationKey or accountName.");
    }
    // Version 2020-12-06 adds support for encryptionscope in SAS.
    if (version >= "2020-12-06") {
        if (sharedKeyCredential !== undefined) {
            return generateBlobSASQueryParameters20201206(dataLakeSASSignatureValues, sharedKeyCredential);
        }
        else {
            return generateBlobSASQueryParametersUDK20201206(dataLakeSASSignatureValues, userDelegationKeyCredential);
        }
    }
    // Version 2018-11-09 adds support for the signed resource and signed blob snapshot time fields.
    // https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas#constructing-the-signature-string
    if (version >= "2018-11-09") {
        if (sharedKeyCredential !== undefined) {
            return generateBlobSASQueryParameters20181109(dataLakeSASSignatureValues, sharedKeyCredential);
        }
        else {
            // Version 2020-02-10 delegation SAS signature construction includes preauthorizedAgentObjectId, agentObjectId, correlationId.
            if (version >= "2020-02-10") {
                return generateBlobSASQueryParametersUDK20200210(dataLakeSASSignatureValues, userDelegationKeyCredential);
            }
            else {
                return generateBlobSASQueryParametersUDK20181109(dataLakeSASSignatureValues, userDelegationKeyCredential);
            }
        }
    }
    if (version >= "2015-04-05") {
        if (sharedKeyCredential !== undefined) {
            return generateBlobSASQueryParameters20150405(dataLakeSASSignatureValues, sharedKeyCredential);
        }
        else {
            throw new RangeError("'version' must be >= '2018-11-09' when generating user delegation SAS using user delegation key.");
        }
    }
    throw new RangeError("'version' must be >= '2015-04-05'.");
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2015-04-05 AND BEFORE 2018-11-09.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn and identifier.
 *
 * WARNING: When identifier is not provided, permissions and expiresOn are required.
 * You MUST assign value to identifier or expiresOn & permissions manually if you initial with
 * this constructor.
 *
 * @param dataLakeSASSignatureValues -
 * @param sharedKeyCredential -
 */
function generateBlobSASQueryParameters20150405(dataLakeSASSignatureValues, sharedKeyCredential) {
    if (!dataLakeSASSignatureValues.identifier &&
        !(dataLakeSASSignatureValues.permissions && dataLakeSASSignatureValues.expiresOn)) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for DataLake SAS generation when 'identifier' is not provided.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        resource = "b";
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(sharedKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        dataLakeSASSignatureValues.identifier,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        dataLakeSASSignatureValues.cacheControl ? dataLakeSASSignatureValues.cacheControl : "",
        dataLakeSASSignatureValues.contentDisposition
            ? dataLakeSASSignatureValues.contentDisposition
            : "",
        dataLakeSASSignatureValues.contentEncoding ? dataLakeSASSignatureValues.contentEncoding : "",
        dataLakeSASSignatureValues.contentLanguage ? dataLakeSASSignatureValues.contentLanguage : "",
        dataLakeSASSignatureValues.contentType ? dataLakeSASSignatureValues.contentType : "",
    ].join("\n");
    const signature = sharedKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType),
        stringToSign: stringToSign,
    };
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2018-11-09.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn and identifier.
 *
 * WARNING: When identifier is not provided, permissions and expiresOn are required.
 * You MUST assign value to identifier or expiresOn & permissions manually if you initial with
 * this constructor.
 *
 * @param dataLakeSASSignatureValues -
 * @param sharedKeyCredential -
 */
function generateBlobSASQueryParameters20181109(dataLakeSASSignatureValues, sharedKeyCredential) {
    if (!dataLakeSASSignatureValues.identifier &&
        !(dataLakeSASSignatureValues.permissions && dataLakeSASSignatureValues.expiresOn)) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for Blob SAS generation when 'identifier' is not provided.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        if (dataLakeSASSignatureValues.isDirectory) {
            resource = "d";
        }
        else {
            resource = "b";
            if (dataLakeSASSignatureValues.snapshotTime) {
                resource = "bs";
            }
        }
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            if (dataLakeSASSignatureValues.isDirectory) {
                verifiedPermissions = DirectorySASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
            else {
                verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(sharedKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        dataLakeSASSignatureValues.identifier,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        resource,
        dataLakeSASSignatureValues.snapshotTime,
        dataLakeSASSignatureValues.cacheControl ? dataLakeSASSignatureValues.cacheControl : "",
        dataLakeSASSignatureValues.contentDisposition
            ? dataLakeSASSignatureValues.contentDisposition
            : "",
        dataLakeSASSignatureValues.contentEncoding ? dataLakeSASSignatureValues.contentEncoding : "",
        dataLakeSASSignatureValues.contentLanguage ? dataLakeSASSignatureValues.contentLanguage : "",
        dataLakeSASSignatureValues.contentType ? dataLakeSASSignatureValues.contentType : "",
    ].join("\n");
    const signature = sharedKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType, undefined, dataLakeSASSignatureValues.directoryDepth),
        stringToSign: stringToSign,
    };
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2018-11-09.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn.
 *
 * WARNING: identifier will be ignored, permissions and expiresOn are required.
 *
 * @param dataLakeSASSignatureValues -
 * @param userDelegationKeyCredential -
 */
function generateBlobSASQueryParametersUDK20181109(dataLakeSASSignatureValues, userDelegationKeyCredential) {
    if (!dataLakeSASSignatureValues.permissions || !dataLakeSASSignatureValues.expiresOn) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for Blob SAS generation when generating user delegation SAS.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        if (dataLakeSASSignatureValues.isDirectory) {
            resource = "d";
        }
        else {
            resource = "b";
            if (dataLakeSASSignatureValues.snapshotTime) {
                resource = "bs";
            }
        }
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            if (dataLakeSASSignatureValues.isDirectory) {
                verifiedPermissions = DirectorySASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
            else {
                verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(userDelegationKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        userDelegationKeyCredential.userDelegationKey.signedObjectId,
        userDelegationKeyCredential.userDelegationKey.signedTenantId,
        userDelegationKeyCredential.userDelegationKey.signedStartsOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedStartsOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedExpiresOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedExpiresOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedService,
        userDelegationKeyCredential.userDelegationKey.signedVersion,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        resource,
        dataLakeSASSignatureValues.snapshotTime,
        dataLakeSASSignatureValues.cacheControl,
        dataLakeSASSignatureValues.contentDisposition,
        dataLakeSASSignatureValues.contentEncoding,
        dataLakeSASSignatureValues.contentLanguage,
        dataLakeSASSignatureValues.contentType,
    ].join("\n");
    const signature = userDelegationKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType, userDelegationKeyCredential.userDelegationKey, dataLakeSASSignatureValues.directoryDepth, dataLakeSASSignatureValues.preauthorizedAgentObjectId, dataLakeSASSignatureValues.agentObjectId, dataLakeSASSignatureValues.correlationId),
        stringToSign: stringToSign,
    };
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2020-02-10.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn.
 *
 * WARNING: identifier will be ignored, permissions and expiresOn are required.
 *
 * @param dataLakeSASSignatureValues -
 * @param userDelegationKeyCredential -
 */
function generateBlobSASQueryParametersUDK20200210(dataLakeSASSignatureValues, userDelegationKeyCredential) {
    if (!dataLakeSASSignatureValues.permissions || !dataLakeSASSignatureValues.expiresOn) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for Blob SAS generation when generating user delegation SAS.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        if (dataLakeSASSignatureValues.isDirectory) {
            resource = "d";
        }
        else {
            resource = "b";
            if (dataLakeSASSignatureValues.snapshotTime) {
                resource = "bs";
            }
        }
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            if (dataLakeSASSignatureValues.isDirectory) {
                verifiedPermissions = DirectorySASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
            else {
                verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(userDelegationKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        userDelegationKeyCredential.userDelegationKey.signedObjectId,
        userDelegationKeyCredential.userDelegationKey.signedTenantId,
        userDelegationKeyCredential.userDelegationKey.signedStartsOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedStartsOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedExpiresOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedExpiresOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedService,
        userDelegationKeyCredential.userDelegationKey.signedVersion,
        dataLakeSASSignatureValues.preauthorizedAgentObjectId,
        dataLakeSASSignatureValues.agentObjectId,
        dataLakeSASSignatureValues.correlationId,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        resource,
        dataLakeSASSignatureValues.snapshotTime,
        dataLakeSASSignatureValues.cacheControl,
        dataLakeSASSignatureValues.contentDisposition,
        dataLakeSASSignatureValues.contentEncoding,
        dataLakeSASSignatureValues.contentLanguage,
        dataLakeSASSignatureValues.contentType,
    ].join("\n");
    const signature = userDelegationKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType, userDelegationKeyCredential.userDelegationKey, dataLakeSASSignatureValues.directoryDepth, dataLakeSASSignatureValues.preauthorizedAgentObjectId, dataLakeSASSignatureValues.agentObjectId, dataLakeSASSignatureValues.correlationId),
        stringToSign: stringToSign,
    };
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2020-12-06.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn and identifier.
 *
 * WARNING: When identifier is not provided, permissions and expiresOn are required.
 * You MUST assign value to identifier or expiresOn & permissions manually if you initial with
 * this constructor.
 *
 * @param dataLakeSASSignatureValues -
 * @param sharedKeyCredential -
 */
function generateBlobSASQueryParameters20201206(dataLakeSASSignatureValues, sharedKeyCredential) {
    if (!dataLakeSASSignatureValues.identifier &&
        !(dataLakeSASSignatureValues.permissions && dataLakeSASSignatureValues.expiresOn)) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for Blob SAS generation when 'identifier' is not provided.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        if (dataLakeSASSignatureValues.isDirectory) {
            resource = "d";
        }
        else {
            resource = "b";
            if (dataLakeSASSignatureValues.snapshotTime) {
                resource = "bs";
            }
        }
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            if (dataLakeSASSignatureValues.isDirectory) {
                verifiedPermissions = DirectorySASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
            else {
                verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(sharedKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        dataLakeSASSignatureValues.identifier,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        resource,
        dataLakeSASSignatureValues.snapshotTime,
        dataLakeSASSignatureValues.encryptionScope ? dataLakeSASSignatureValues.encryptionScope : "",
        dataLakeSASSignatureValues.cacheControl ? dataLakeSASSignatureValues.cacheControl : "",
        dataLakeSASSignatureValues.contentDisposition
            ? dataLakeSASSignatureValues.contentDisposition
            : "",
        dataLakeSASSignatureValues.contentEncoding ? dataLakeSASSignatureValues.contentEncoding : "",
        dataLakeSASSignatureValues.contentLanguage ? dataLakeSASSignatureValues.contentLanguage : "",
        dataLakeSASSignatureValues.contentType ? dataLakeSASSignatureValues.contentType : "",
    ].join("\n");
    const signature = sharedKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType, undefined, dataLakeSASSignatureValues.directoryDepth, undefined, undefined, undefined, dataLakeSASSignatureValues.encryptionScope),
        stringToSign: stringToSign,
    };
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 * IMPLEMENTATION FOR API VERSION FROM 2020-12-06.
 *
 * Creates an instance of SASQueryParameters.
 *
 * Only accepts required settings needed to create a SAS. For optional settings please
 * set corresponding properties directly, such as permissions, startsOn.
 *
 * WARNING: identifier will be ignored, permissions and expiresOn are required.
 *
 * @param dataLakeSASSignatureValues -
 * @param userDelegationKeyCredential -
 */
function generateBlobSASQueryParametersUDK20201206(dataLakeSASSignatureValues, userDelegationKeyCredential) {
    if (!dataLakeSASSignatureValues.permissions || !dataLakeSASSignatureValues.expiresOn) {
        throw new RangeError("Must provide 'permissions' and 'expiresOn' for Blob SAS generation when generating user delegation SAS.");
    }
    const version = dataLakeSASSignatureValues.version
        ? dataLakeSASSignatureValues.version
        : SERVICE_VERSION;
    dataLakeSASSignatureValues = SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version);
    let resource = "c";
    if (dataLakeSASSignatureValues.pathName) {
        if (dataLakeSASSignatureValues.isDirectory) {
            resource = "d";
        }
        else {
            resource = "b";
            if (dataLakeSASSignatureValues.snapshotTime) {
                resource = "bs";
            }
        }
    }
    // Calling parse and toString guarantees the proper ordering and throws on invalid characters.
    let verifiedPermissions;
    if (dataLakeSASSignatureValues.permissions) {
        if (dataLakeSASSignatureValues.pathName) {
            if (dataLakeSASSignatureValues.isDirectory) {
                verifiedPermissions = DirectorySASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
            else {
                verifiedPermissions = DataLakeSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
            }
        }
        else {
            verifiedPermissions = FileSystemSASPermissions.parse(dataLakeSASSignatureValues.permissions.toString()).toString();
        }
    }
    // Signature is generated on the un-url-encoded values.
    const stringToSign = [
        verifiedPermissions ? verifiedPermissions : "",
        dataLakeSASSignatureValues.startsOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.startsOn, false)
            : "",
        dataLakeSASSignatureValues.expiresOn
            ? truncatedISO8061Date(dataLakeSASSignatureValues.expiresOn, false)
            : "",
        getCanonicalName(userDelegationKeyCredential.accountName, dataLakeSASSignatureValues.fileSystemName, dataLakeSASSignatureValues.pathName),
        userDelegationKeyCredential.userDelegationKey.signedObjectId,
        userDelegationKeyCredential.userDelegationKey.signedTenantId,
        userDelegationKeyCredential.userDelegationKey.signedStartsOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedStartsOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedExpiresOn
            ? truncatedISO8061Date(userDelegationKeyCredential.userDelegationKey.signedExpiresOn, false)
            : "",
        userDelegationKeyCredential.userDelegationKey.signedService,
        userDelegationKeyCredential.userDelegationKey.signedVersion,
        dataLakeSASSignatureValues.preauthorizedAgentObjectId,
        dataLakeSASSignatureValues.agentObjectId,
        dataLakeSASSignatureValues.correlationId,
        dataLakeSASSignatureValues.ipRange ? ipRangeToString(dataLakeSASSignatureValues.ipRange) : "",
        dataLakeSASSignatureValues.protocol ? dataLakeSASSignatureValues.protocol : "",
        version,
        resource,
        dataLakeSASSignatureValues.snapshotTime,
        dataLakeSASSignatureValues.encryptionScope,
        dataLakeSASSignatureValues.cacheControl,
        dataLakeSASSignatureValues.contentDisposition,
        dataLakeSASSignatureValues.contentEncoding,
        dataLakeSASSignatureValues.contentLanguage,
        dataLakeSASSignatureValues.contentType,
    ].join("\n");
    const signature = userDelegationKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameter: new SASQueryParameters(version, signature, verifiedPermissions, undefined, undefined, dataLakeSASSignatureValues.protocol, dataLakeSASSignatureValues.startsOn, dataLakeSASSignatureValues.expiresOn, dataLakeSASSignatureValues.ipRange, dataLakeSASSignatureValues.identifier, resource, dataLakeSASSignatureValues.cacheControl, dataLakeSASSignatureValues.contentDisposition, dataLakeSASSignatureValues.contentEncoding, dataLakeSASSignatureValues.contentLanguage, dataLakeSASSignatureValues.contentType, userDelegationKeyCredential.userDelegationKey, dataLakeSASSignatureValues.directoryDepth, dataLakeSASSignatureValues.preauthorizedAgentObjectId, dataLakeSASSignatureValues.agentObjectId, dataLakeSASSignatureValues.correlationId, dataLakeSASSignatureValues.encryptionScope),
        stringToSign: stringToSign,
    };
}
function getCanonicalName(accountName, containerName, blobName) {
    // FileSystem: "/blob/account/fileSystemName"
    // File:       "/blob/account/fileSystemName/fileName"
    const elements = [`/blob/${accountName}/${containerName}`];
    if (blobName) {
        elements.push(`/${blobName}`);
    }
    return elements.join("");
}
function SASSignatureValuesSanityCheckAndAutofill(dataLakeSASSignatureValues, version) {
    var _a;
    if (version < "2020-02-10" &&
        (dataLakeSASSignatureValues.isDirectory || dataLakeSASSignatureValues.directoryDepth)) {
        throw RangeError("'version' must be >= '2020-02-10' to support directory SAS.");
    }
    if (dataLakeSASSignatureValues.isDirectory && dataLakeSASSignatureValues.pathName === undefined) {
        throw RangeError("Must provide 'pathName' when 'isDirectory' is true.");
    }
    if (dataLakeSASSignatureValues.directoryDepth !== undefined &&
        (!Number.isInteger(dataLakeSASSignatureValues.directoryDepth) ||
            dataLakeSASSignatureValues.directoryDepth < 0)) {
        throw RangeError("'directoryDepth' must be a non-negative interger.");
    }
    if (dataLakeSASSignatureValues.isDirectory &&
        dataLakeSASSignatureValues.directoryDepth === undefined) {
        // calculate directoryDepth from pathName
        if (dataLakeSASSignatureValues.pathName === "/") {
            dataLakeSASSignatureValues.directoryDepth = 0;
        }
        else {
            dataLakeSASSignatureValues.directoryDepth = (_a = dataLakeSASSignatureValues.pathName) === null || _a === void 0 ? void 0 : _a.split("/").filter((x) => x !== "").length;
        }
    }
    if (version < "2020-02-10" &&
        dataLakeSASSignatureValues.permissions &&
        (dataLakeSASSignatureValues.permissions.move ||
            dataLakeSASSignatureValues.permissions.execute ||
            dataLakeSASSignatureValues.permissions.manageOwnership ||
            dataLakeSASSignatureValues.permissions.manageAccessControl)) {
        throw RangeError("'version' must be >= '2020-02-10' when providing m, e, o or p permission.");
    }
    if (version < "2020-02-10" &&
        (dataLakeSASSignatureValues.preauthorizedAgentObjectId ||
            dataLakeSASSignatureValues.agentObjectId ||
            dataLakeSASSignatureValues.correlationId)) {
        throw RangeError("'version' must be >= '2020-02-10' when providing 'preauthorizedAgentObjectId', 'agentObjectId' or 'correlationId'.");
    }
    if (dataLakeSASSignatureValues.preauthorizedAgentObjectId &&
        dataLakeSASSignatureValues.agentObjectId) {
        throw RangeError("'preauthorizedAgentObjectId' or 'agentObjectId' shouldn't be specified at the same time.");
    }
    if (dataLakeSASSignatureValues.snapshotTime && version < "2018-11-09") {
        throw RangeError("'version' must be >= '2018-11-09' when provided 'snapshotTime'.");
    }
    if (dataLakeSASSignatureValues.pathName === undefined &&
        dataLakeSASSignatureValues.snapshotTime) {
        throw RangeError("Must provide 'blobName' when provided 'snapshotTime'.");
    }
    return dataLakeSASSignatureValues;
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
// In browser, during webpack or browserify bundling, this module will be replaced by 'events'
// https://github.com/Gozala/events
/**
 * States for Batch.
 */
var BatchStates;
(function (BatchStates) {
    BatchStates[BatchStates["Good"] = 0] = "Good";
    BatchStates[BatchStates["Error"] = 1] = "Error";
})(BatchStates || (BatchStates = {}));
/**
 * Batch provides basic parallel execution with concurrency limits.
 * Will stop execute left operations when one of the executed operation throws an error.
 * But Batch cannot cancel ongoing operations, you need to cancel them by yourself.
 */
class Batch {
    /**
     * Creates an instance of Batch.
     * @param concurrency -
     */
    constructor(concurrency = 5) {
        /**
         * Number of active operations under execution.
         */
        this.actives = 0;
        /**
         * Number of completed operations under execution.
         */
        this.completed = 0;
        /**
         * Offset of next operation to be executed.
         */
        this.offset = 0;
        /**
         * Operation array to be executed.
         */
        this.operations = [];
        /**
         * States of Batch. When an error happens, state will turn into error.
         * Batch will stop execute left operations.
         */
        this.state = BatchStates.Good;
        if (concurrency < 1) {
            throw new RangeError("concurrency must be larger than 0");
        }
        this.concurrency = concurrency;
        this.emitter = new events.EventEmitter();
    }
    /**
     * Add a operation into queue.
     *
     * @param operation -
     */
    addOperation(operation) {
        this.operations.push(async () => {
            try {
                this.actives++;
                await operation();
                this.actives--;
                this.completed++;
                this.parallelExecute();
            }
            catch (error) {
                this.emitter.emit("error", error);
            }
        });
    }
    /**
     * Start execute operations in the queue.
     *
     */
    async do() {
        if (this.operations.length === 0) {
            return Promise.resolve();
        }
        this.parallelExecute();
        return new Promise((resolve, reject) => {
            this.emitter.on("finish", resolve);
            this.emitter.on("error", (error) => {
                this.state = BatchStates.Error;
                reject(error);
            });
        });
    }
    /**
     * Get next operation to be executed. Return null when reaching ends.
     *
     */
    nextOperation() {
        if (this.offset < this.operations.length) {
            return this.operations[this.offset++];
        }
        return null;
    }
    /**
     * Start execute operations. One one the most important difference between
     * this method with do() is that do() wraps as an sync method.
     *
     */
    parallelExecute() {
        if (this.state === BatchStates.Error) {
            return;
        }
        if (this.completed >= this.operations.length) {
            this.emitter.emit("finish");
            return;
        }
        while (this.actives < this.concurrency) {
            const operation = this.nextOperation();
            if (operation) {
                operation();
            }
            else {
                return;
            }
        }
    }
}

/**
 * An error thrown when an operation is interrupted and can be continued later on.
 */
class DataLakeAclChangeFailedError extends Error {
    constructor(error, continuationToken) {
        super(error.message);
        this.name = "DataLakeAclChangeFailedError";
        this.innerError = error;
        this.continuationToken = continuationToken;
        Object.setPrototypeOf(this, DataLakeAclChangeFailedError.prototype);
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * Promisified version of fs.stat().
 */
const fsStat = util__namespace.promisify(fs__namespace.stat);
const fsCreateReadStream = fs__namespace.createReadStream;

/**
 * A DataLakePathClient represents a URL to the Azure Storage path (directory or file).
 */
class DataLakePathClient extends StorageClient {
    /**
     * SetAccessControlRecursiveInternal operation sets the Access Control on a path and sub paths.
     *
     * @param mode - Mode \"set\" sets POSIX access control rights on files and directories,
     *                                                 Mode \"modify\" modifies one or more POSIX access control rights that pre-exist on files and directories,
     *                                                 Mode \"remove\" removes one or more POSIX access control rights that were present earlier on files and directories.
     * @param acl - The POSIX access control list for the file or directory.
     * @param options - Optional. Options
     */
    async setAccessControlRecursiveInternal(mode, acl, options = {}) {
        if (options.maxBatches !== undefined && options.maxBatches < 1) {
            throw RangeError(`Options maxBatches must be larger than 0.`);
        }
        if (options.batchSize !== undefined && options.batchSize < 1) {
            throw RangeError(`Options batchSize must be larger than 0.`);
        }
        const result = {
            counters: {
                failedChangesCount: 0,
                changedDirectoriesCount: 0,
                changedFilesCount: 0,
            },
            continuationToken: undefined,
        };
        return tracingClient.withSpan("DataLakePathClient-setAccessControlRecursiveInternal", options, async (updatedOptions) => {
            var _a, _b, _c, _d, _e, _f;
            let continuationToken = options.continuationToken;
            let batchCounter = 0;
            let reachMaxBatches = false;
            do {
                let response;
                try {
                    response = await this.pathContext.setAccessControlRecursive(mode, Object.assign(Object.assign({}, updatedOptions), { acl: toAclString(acl), maxRecords: options.batchSize, continuation: continuationToken, forceFlag: options.continueOnFailure }));
                }
                catch (e) {
                    throw new DataLakeAclChangeFailedError(e, continuationToken);
                }
                batchCounter++;
                continuationToken = response.continuation;
                // Update result
                result.continuationToken = continuationToken;
                result.counters.failedChangesCount += (_a = response.failureCount) !== null && _a !== void 0 ? _a : 0;
                result.counters.changedDirectoriesCount += (_b = response.directoriesSuccessful) !== null && _b !== void 0 ? _b : 0;
                result.counters.changedFilesCount += (_c = response.filesSuccessful) !== null && _c !== void 0 ? _c : 0;
                // Progress event call back
                if (options.onProgress) {
                    const progress = {
                        batchFailures: toAccessControlChangeFailureArray(response.failedEntries),
                        batchCounters: {
                            failedChangesCount: (_d = response.failureCount) !== null && _d !== void 0 ? _d : 0,
                            changedDirectoriesCount: (_e = response.directoriesSuccessful) !== null && _e !== void 0 ? _e : 0,
                            changedFilesCount: (_f = response.filesSuccessful) !== null && _f !== void 0 ? _f : 0,
                        },
                        aggregateCounters: result.counters,
                        continuationToken: continuationToken,
                    };
                    options.onProgress(progress);
                }
                reachMaxBatches =
                    options.maxBatches === undefined ? false : batchCounter >= options.maxBatches;
            } while (continuationToken && !reachMaxBatches);
            return result;
        });
    }
    constructor(url, credentialOrPipeline, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        if (storageBlob.isPipelineLike(credentialOrPipeline)) {
            super(url, credentialOrPipeline);
        }
        else {
            let credential;
            if (credentialOrPipeline === undefined) {
                credential = new storageBlob.AnonymousCredential();
            }
            else {
                credential = credentialOrPipeline;
            }
            const pipeline = newPipeline(credential, options);
            super(url, pipeline);
        }
        this.pathContext = new PathOperationsImpl(this.storageClientContext);
        this.blobClient = new storageBlob.BlobClient(this.blobEndpointUrl, this.pipeline);
    }
    /**
     * Name of current file system.
     *
     * @readonly
     */
    get fileSystemName() {
        return this.blobClient.containerName;
    }
    /**
     * Name of current path (directory or file).
     *
     * @readonly
     */
    get name() {
        return this.blobClient.name;
    }
    /**
     * Convert current DataLakePathClient to DataLakeDirectoryClient if current path is a directory.
     *
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    toDirectoryClient() {
        return new DataLakeDirectoryClient(this.dfsEndpointUrl, this.pipeline);
    }
    /**
     * Convert current DataLakePathClient to DataLakeFileClient if current path is a file.
     *
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    toFileClient() {
        return new DataLakeFileClient(this.dfsEndpointUrl, this.pipeline);
    }
    /**
     * Get a {@link DataLakeLeaseClient} that manages leases on the path (directory or file).
     *
     * @param proposeLeaseId - Optional. Initial proposed lease Id.
     */
    getDataLakeLeaseClient(proposeLeaseId) {
        return new DataLakeLeaseClient(this.blobClient.getBlobLeaseClient(proposeLeaseId));
    }
    /**
     * Create a directory or path.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/create
     *
     * @param resourceType - Resource type, "directory" or "file".
     * @param options - Optional. Options when creating path.
     */
    async create(resourceType, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-create", options, async (updatedOptions) => {
            ensureCpkIfSpecified(options.customerProvidedKey, this.isHttps);
            let expiryOptions;
            let expiresOn;
            if (typeof options.expiresOn === "number" && Number.isFinite(options.expiresOn)) {
                expiryOptions = "RelativeToNow";
                expiresOn = String(Math.round(options.expiresOn));
            }
            else if (options.expiresOn instanceof Date) {
                expiryOptions = "Absolute";
                expiresOn = options.expiresOn.toUTCString();
            }
            else if (options.expiresOn) {
                throw new Error(`Value for expiresOn is invalid: ${options.expiresOn}`);
            }
            return assertResponse(await this.pathContext.create(Object.assign(Object.assign({}, updatedOptions), { resource: resourceType, leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions, properties: toProperties(options.metadata), cpkInfo: options.customerProvidedKey, acl: options.acl ? toAclString(options.acl) : undefined, expiryOptions,
                expiresOn })));
        });
    }
    /**
     * Create a directory or file. If the resource already exists, it is not changed.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/create
     *
     * @param resourceType - Resource type, "directory" or "file".
     * @param options -
     */
    async createIfNotExists(resourceType, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-createIfNotExists", options, async (updatedOptions) => {
            var _a, _b;
            try {
                const conditions = { ifNoneMatch: ETagAny };
                const res = await this.create(resourceType, Object.assign(Object.assign({}, options), { conditions, tracingOptions: updatedOptions.tracingOptions }));
                return Object.assign({ succeeded: true }, res);
            }
            catch (e) {
                if (((_a = e.details) === null || _a === void 0 ? void 0 : _a.errorCode) === "PathAlreadyExists") {
                    return Object.assign(Object.assign({ succeeded: false }, (_b = e.response) === null || _b === void 0 ? void 0 : _b.parsedHeaders), { _response: e.response });
                }
                throw e;
            }
        });
    }
    /**
     * Returns true if the Data Lake file represented by this client exists; false otherwise.
     *
     * NOTE: use this function with care since an existing file might be deleted by other clients or
     * applications. Vice versa new files might be added by other clients or applications after this
     * function completes.
     *
     * @param options - options to Exists operation.
     */
    async exists(options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-exists", options, async (updatedOptions) => {
            return this.blobClient.exists(Object.assign(Object.assign({}, updatedOptions), { customerProvidedKey: toBlobCpkInfo(updatedOptions.customerProvidedKey) }));
        });
    }
    /**
     * Delete current path (directory or file).
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/delete
     *
     * @param recursive - Required and valid only when the resource is a directory. If "true", all paths beneath the directory will be deleted.
     * @param options - Optional. Options when deleting path.
     */
    async delete(recursive, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-delete", options, async (updatedOptions) => {
            if (this.isTokenCredential === undefined) {
                this.isTokenCredential = false;
                this.pipeline.factories.forEach((factory) => {
                    if (coreAuth.isTokenCredential(factory.credential)) {
                        this.isTokenCredential = true;
                    }
                });
                if (coreAuth.isTokenCredential(this.pipeline._credential)) {
                    this.isTokenCredential = true;
                }
            }
            const paginated = recursive === true && this.isTokenCredential === true;
            let continuation;
            let response;
            // How to handle long delete loop?
            do {
                response = assertResponse(await this.pathContext.delete(Object.assign(Object.assign({}, updatedOptions), { continuation,
                    recursive, leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions, abortSignal: options.abortSignal, paginated })));
                continuation = response.continuation;
            } while (continuation);
            return response;
        });
    }
    /**
     * Delete current path (directory or file) if it exists.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/delete
     *
     * @param recursive - Required and valid only when the resource is a directory. If "true", all paths beneath the directory will be deleted.
     * @param options -
     */
    async deleteIfExists(recursive, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-deleteIfExists", options, async (updatedOptions) => {
            var _a, _b;
            try {
                const res = await this.delete(recursive, updatedOptions);
                return Object.assign({ succeeded: true }, res);
            }
            catch (e) {
                if (((_a = e.details) === null || _a === void 0 ? void 0 : _a.errorCode) === "PathNotFound") {
                    return Object.assign(Object.assign({ succeeded: false }, (_b = e.response) === null || _b === void 0 ? void 0 : _b.parsedHeaders), { _response: e.response });
                }
                throw e;
            }
        });
    }
    /**
     * Returns the access control data for a path (directory of file).
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/getproperties
     *
     * @param options - Optional. Options when getting file access control.
     */
    async getAccessControl(options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-getAccessControl", options, async (updatedOptions) => {
            const response = assertResponse(await this.pathContext.getProperties(Object.assign(Object.assign({}, updatedOptions), { action: "getAccessControl", upn: options.userPrincipalName, leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions, abortSignal: options.abortSignal })));
            return Object.assign(Object.assign({}, response), { _response: response._response, permissions: toPermissions(response.permissions), acl: toAcl(response.acl) });
        });
    }
    /**
     * Set the access control data for a path (directory of file).
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param acl - The POSIX access control list for the file or directory.
     * @param options - Optional. Options when setting path access control.
     */
    async setAccessControl(acl, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-setAccessControl", options, async (updatedOptions) => {
            return assertResponse(await this.pathContext.setAccessControl(Object.assign(Object.assign({}, updatedOptions), { acl: toAclString(acl), leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions })));
        });
    }
    /**
     * Sets the Access Control on a path and sub paths.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param acl - The POSIX access control list for the file or directory.
     * @param options - Optional. Options
     */
    async setAccessControlRecursive(acl, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-setAccessControlRecursive", options, async (updatedOptions) => {
            return this.setAccessControlRecursiveInternal("set", acl, updatedOptions);
        });
    }
    /**
     * Modifies the Access Control on a path and sub paths.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param acl - The POSIX access control list for the file or directory.
     * @param options - Optional. Options
     */
    async updateAccessControlRecursive(acl, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-updateAccessControlRecursive", options, async (updatedOptions) => {
            return this.setAccessControlRecursiveInternal("modify", acl, updatedOptions);
        });
    }
    /**
     * Removes the Access Control on a path and sub paths.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param acl - The POSIX access control list for the file or directory.
     * @param options - Optional. Options
     */
    async removeAccessControlRecursive(acl, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-removeAccessControlRecursive", options, async (updatedOptions) => {
            return this.setAccessControlRecursiveInternal("remove", acl, updatedOptions);
        });
    }
    /**
     * Sets the file permissions on a path.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param permissions - The POSIX access permissions for the file owner, the file owning group, and others.
     * @param options - Optional. Options when setting path permissions.
     */
    async setPermissions(permissions, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakePathClient-setPermissions", options, async (updatedOptions) => {
            return assertResponse(await this.pathContext.setAccessControl(Object.assign(Object.assign({}, updatedOptions), { permissions: toPermissionsString(permissions), leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions })));
        });
    }
    /**
     * Returns all user-defined metadata, standard HTTP properties, and system properties
     * for the path (directory or file).
     *
     * WARNING: The `metadata` object returned in the response will have its keys in lowercase, even if
     * they originally contained uppercase characters. This differs from the metadata keys returned by
     * the methods of {@link DataLakeFileSystemClient} that list paths using the `includeMetadata` option, which
     * will retain their original casing.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-blob-properties
     *
     * @param options - Optional. Options when getting path properties.
     */
    async getProperties(options = {}) {
        return tracingClient.withSpan("DataLakePathClient-getProperties", options, async (updatedOptions) => {
            const response = await this.blobClient.getProperties(Object.assign(Object.assign({}, options), { customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey), tracingOptions: updatedOptions.tracingOptions }));
            return ParsePathGetPropertiesExtraHeaderValues(response);
        });
    }
    /**
     * Sets system properties on the path (directory or file).
     *
     * If no value provided, or no value provided for the specified blob HTTP headers,
     * these blob HTTP headers without a value will be cleared.
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/set-blob-properties
     *
     * @param httpHeaders -
     * @param options -
     */
    async setHttpHeaders(httpHeaders, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-setHttpHeaders", options, async (updatedOptions) => {
            return this.blobClient.setHTTPHeaders({
                blobCacheControl: httpHeaders.cacheControl,
                blobContentType: httpHeaders.contentType,
                blobContentMD5: httpHeaders.contentMD5,
                blobContentEncoding: httpHeaders.contentEncoding,
                blobContentLanguage: httpHeaders.contentLanguage,
                blobContentDisposition: httpHeaders.contentDisposition,
            }, updatedOptions);
        });
    }
    /**
     * Sets user-defined metadata for the specified path (directory of file) as one or more name-value pairs.
     *
     * If no option provided, or no metadata defined in the parameter, the path
     * metadata will be removed.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/set-blob-metadata
     *
     * @param metadata - Optional. Replace existing metadata with this value.
     *                              If no value provided the existing metadata will be removed.
     * @param options - Optional. Options when setting path metadata.
     */
    async setMetadata(metadata, options = {}) {
        return tracingClient.withSpan("DataLakePathClient-setMetadata", options, async (updatedOptions) => {
            return this.blobClient.setMetadata(metadata, Object.assign(Object.assign({}, options), { customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey), tracingOptions: updatedOptions.tracingOptions }));
        });
    }
    async move(destinationPathOrFileSystem, destinationPathOrOptions, options) {
        let destinationFileSystem = this.fileSystemName;
        let destinationPath = destinationPathOrFileSystem;
        let pathMoveOptions;
        if (typeof destinationPathOrOptions === "string") {
            destinationFileSystem = destinationPathOrFileSystem;
            destinationPath = destinationPathOrOptions;
            pathMoveOptions = options !== null && options !== void 0 ? options : {};
        }
        else {
            pathMoveOptions = destinationPathOrOptions !== null && destinationPathOrOptions !== void 0 ? destinationPathOrOptions : {};
        }
        const renameSource = getURLPathAndQuery(this.dfsEndpointUrl);
        const split = destinationPath.split("?");
        let destinationUrl;
        if (split.length === 2) {
            const renameDestination = `/${destinationFileSystem}/${split[0]}`;
            destinationUrl = setURLPath(this.dfsEndpointUrl, renameDestination);
            destinationUrl = setURLQueries(destinationUrl, split[1]);
        }
        else if (split.length === 1) {
            const renameDestination = `/${destinationFileSystem}/${destinationPath}`;
            destinationUrl = setURLPath(this.dfsEndpointUrl, renameDestination);
        }
        else {
            throw new RangeError("Destination path should not contain more than one query string");
        }
        const destPathClient = new DataLakePathClient(destinationUrl, this.pipeline);
        return tracingClient.withSpan("DataLakePathClient-move", pathMoveOptions, async (updatedOptions) => {
            var _a, _b, _c, _d, _e;
            return assertResponse(await destPathClient.pathContext.create(Object.assign(Object.assign({}, updatedOptions), { mode: "legacy", // By default
                renameSource, sourceLeaseId: (_a = pathMoveOptions.conditions) === null || _a === void 0 ? void 0 : _a.leaseId, leaseAccessConditions: pathMoveOptions.destinationConditions, sourceModifiedAccessConditions: {
                    sourceIfMatch: (_b = pathMoveOptions.conditions) === null || _b === void 0 ? void 0 : _b.ifMatch,
                    sourceIfNoneMatch: (_c = pathMoveOptions.conditions) === null || _c === void 0 ? void 0 : _c.ifNoneMatch,
                    sourceIfModifiedSince: (_d = pathMoveOptions.conditions) === null || _d === void 0 ? void 0 : _d.ifModifiedSince,
                    sourceIfUnmodifiedSince: (_e = pathMoveOptions.conditions) === null || _e === void 0 ? void 0 : _e.ifUnmodifiedSince,
                }, modifiedAccessConditions: pathMoveOptions.destinationConditions, abortSignal: pathMoveOptions.abortSignal })));
        });
    }
}
/**
 * A DataLakeDirectoryClient represents a URL to the Azure Storage directory.
 */
class DataLakeDirectoryClient extends DataLakePathClient {
    async create(resourceTypeOrOptions, options = {}) {
        if (resourceTypeOrOptions === "file") {
            throw TypeError(`DataLakeDirectoryClient:create() resourceType cannot be ${resourceTypeOrOptions}. Refer to DataLakeFileClient for file creation.`);
        }
        let pathCreateOptions;
        if (resourceTypeOrOptions === "directory") {
            pathCreateOptions = options;
        }
        else {
            pathCreateOptions = resourceTypeOrOptions !== null && resourceTypeOrOptions !== void 0 ? resourceTypeOrOptions : {};
        }
        return tracingClient.withSpan("DataLakeDirectoryClient-create", pathCreateOptions, async (updatedOptions) => {
            return super.create("directory", updatedOptions);
        });
    }
    async createIfNotExists(resourceTypeOrOptions, options = {}) {
        if (resourceTypeOrOptions === "file") {
            throw TypeError(`DataLakeDirectoryClient:createIfNotExists() resourceType cannot be ${resourceTypeOrOptions}. Refer to DataLakeFileClient for file creation.`);
        }
        if (resourceTypeOrOptions !== "directory") {
            options = resourceTypeOrOptions || {};
        }
        return tracingClient.withSpan("DataLakeDirectoryClient-createIfNotExists", options, async (updatedOptions) => {
            return super.createIfNotExists("directory", Object.assign({}, updatedOptions));
        });
    }
    /**
     * Creates a {@link DataLakeDirectoryClient} object under current directory.
     *
     * @param subdirectoryName - Subdirectory name.
     */
    getSubdirectoryClient(subdirectoryName) {
        return new DataLakeDirectoryClient(appendToURLPath(this.url, encodeURIComponent(subdirectoryName)), this.pipeline);
    }
    /**
     * Creates a {@link DataLakeFileClient} object under current directory.
     *
     * @param fileName -
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    getFileClient(fileName) {
        return new DataLakeFileClient(appendToURLPath(this.url, encodeURIComponent(fileName)), this.pipeline);
    }
    /**
     * Only available for clients constructed with a shared key credential.
     *
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateSasUrl(options) {
        return new Promise((resolve) => {
            if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
                throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
            }
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name, isDirectory: true }, options), this.credential).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options*/
    generateSasStringToSign(options) {
        if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
            throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
        }
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name, isDirectory: true }, options), this.credential).stringToSign;
    }
    /**
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasUrl(options, userDelegationKey) {
        return new Promise((resolve) => {
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name, isDirectory: true }, options), userDelegationKey, this.accountName).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasStringToSign(options, userDelegationKey) {
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name, isDirectory: true }, options), userDelegationKey, this.accountName).stringToSign;
    }
}
/**
 * A DataLakeFileClient represents a URL to the Azure Storage file.
 */
class DataLakeFileClient extends DataLakePathClient {
    constructor(url, credentialOrPipeline, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        if (storageBlob.isPipelineLike(credentialOrPipeline)) {
            super(url, credentialOrPipeline);
        }
        else {
            let credential;
            if (credentialOrPipeline === undefined) {
                credential = new storageBlob.AnonymousCredential();
            }
            else {
                credential = credentialOrPipeline;
            }
            const pipeline = newPipeline(credential, options);
            super(url, pipeline);
        }
        this.pathContextInternal = new PathOperationsImpl(this.storageClientContext);
        this.blockBlobClientInternal = new storageBlob.BlockBlobClient(this.blobEndpointUrl, this.pipeline);
        this.pathContextInternalToBlobEndpoint = new PathOperationsImpl(this.storageClientContextToBlobEndpoint);
    }
    async create(resourceTypeOrOptions, options = {}) {
        if (resourceTypeOrOptions === "directory") {
            throw TypeError(`DataLakeFileClient:create() resourceType cannot be ${resourceTypeOrOptions}. Refer to DataLakeDirectoryClient for directory creation.`);
        }
        let pathCreateOptions;
        if (resourceTypeOrOptions === "file") {
            pathCreateOptions = options;
        }
        else {
            pathCreateOptions = resourceTypeOrOptions !== null && resourceTypeOrOptions !== void 0 ? resourceTypeOrOptions : {};
        }
        return tracingClient.withSpan("DataLakeFileClient-create", pathCreateOptions, async (updatedOptions) => {
            return super.create("file", updatedOptions);
        });
    }
    async createIfNotExists(resourceTypeOrOptions, options = {}) {
        if (resourceTypeOrOptions === "directory") {
            throw TypeError(`DataLakeFileClient:createIfNotExists() resourceType cannot be ${resourceTypeOrOptions}. Refer to DataLakeDirectoryClient for directory creation.`);
        }
        if (resourceTypeOrOptions !== "file") {
            options = resourceTypeOrOptions || {};
        }
        return tracingClient.withSpan("DataLakeFileClient-createIfNotExists", options, async (updatedOptions) => {
            return super.createIfNotExists("file", updatedOptions);
        });
    }
    /**
     * Downloads a file from the service, including its metadata and properties.
     *
     * * In Node.js, data returns in a Readable stream readableStreamBody
     * * In browsers, data returns in a promise contentAsBlob
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-blob
     *
     * * Example usage (Node.js):
     *
     * ```js
     * // Download and convert a file to a string
     * const downloadResponse = await fileClient.read();
     * const downloaded = await streamToBuffer(downloadResponse.readableStreamBody);
     * console.log("Downloaded file content:", downloaded.toString());
     *
     * async function streamToBuffer(readableStream) {
     *   return new Promise((resolve, reject) => {
     *     const chunks = [];
     *     readableStream.on("data", (data) => {
     *       chunks.push(typeof data === "string" ? Buffer.from(data) : data);
     *     });
     *     readableStream.on("end", () => {
     *       resolve(Buffer.concat(chunks));
     *     });
     *     readableStream.on("error", reject);
     *   });
     * }
     * ```
     *
     * Example usage (browser):
     *
     * ```js
     * // Download and convert a file to a string
     * const downloadResponse = await fileClient.read();
     * const downloaded = await blobToString(await downloadResponse.contentAsBlob);
     * console.log("Downloaded file content", downloaded);
     *
     * async function blobToString(blob: Blob): Promise<string> {
     *   const fileReader = new FileReader();
     *   return new Promise<string>((resolve, reject) => {
     *     fileReader.onloadend = (ev: any) => {
     *       resolve(ev.target!.result);
     *     };
     *     fileReader.onerror = reject;
     *     fileReader.readAsText(blob);
     *   });
     * }
     * ```
     *
     * @param offset - Optional. Offset to read file, default value is 0.
     * @param count - Optional. How many bytes to read, default will read from offset to the end.
     * @param options - Optional. Options when reading file.
     */
    async read(offset = 0, count, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-read", options, async (updatedOptions) => {
            const rawResponse = await this.blockBlobClientInternal.download(offset, count, Object.assign(Object.assign({}, updatedOptions), { customerProvidedKey: toBlobCpkInfo(updatedOptions.customerProvidedKey) }));
            const response = ParsePathGetPropertiesExtraHeaderValues(rawResponse);
            if (!coreUtil.isNode && !response.contentAsBlob) {
                response.contentAsBlob = rawResponse.blobBody;
            }
            response.fileContentMD5 = rawResponse.blobContentMD5;
            response._response.parsedHeaders.fileContentMD5 =
                rawResponse._response.parsedHeaders.blobContentMD5;
            delete rawResponse.blobContentMD5;
            delete rawResponse._response.parsedHeaders.blobContentMD5;
            return response;
        });
    }
    /**
     * Uploads data to be appended to a file. Data can only be appended to a file.
     * To apply perviously uploaded data to a file, call flush.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/datalakestoragegen2/path/update
     *
     * @param body - Content to be uploaded.
     * @param offset - Append offset in bytes.
     * @param length - Length of content to append in bytes.
     * @param options - Optional. Options when appending data.
     */
    async append(body, offset, length, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeFileClient-append", options, async (updatedOptions) => {
            ensureCpkIfSpecified(options.customerProvidedKey, this.isHttps);
            return assertResponse(await this.pathContextInternal.appendData(body, Object.assign(Object.assign({}, updatedOptions), { pathHttpHeaders: {
                    contentMD5: options.transactionalContentMD5,
                }, abortSignal: options.abortSignal, position: offset, contentLength: length, leaseAccessConditions: options.conditions, requestOptions: {
                    onUploadProgress: options.onProgress,
                }, cpkInfo: options.customerProvidedKey, flush: options.flush, proposedLeaseId: options.proposedLeaseId, leaseDuration: options.leaseDurationInSeconds, leaseAction: options.leaseAction })));
        });
    }
    /**
     * Flushes (writes) previously appended data to a file.
     *
     * @param position - File position to flush.
     *                          This parameter allows the caller to upload data in parallel and control the order in which it is appended to the file.
     *                          It is required when uploading data to be appended to the file and when flushing previously uploaded data to the file.
     *                          The value must be the position where the data is to be appended. Uploaded data is not immediately flushed, or written,
     *                          to the file. To flush, the previously uploaded data must be contiguous, the position parameter must be specified and
     *                          equal to the length of the file after all data has been written, and there must not be a request entity body included
     *                          with the request.
     * @param options - Optional. Options when flushing data.
     */
    async flush(position, options = {}) {
        options.conditions = options.conditions || {};
        return tracingClient.withSpan("DataLakeFileClient-flush", options, async (updatedOptions) => {
            ensureCpkIfSpecified(options.customerProvidedKey, this.isHttps);
            return assertResponse(await this.pathContextInternal.flushData(Object.assign(Object.assign({}, updatedOptions), { position, contentLength: 0, leaseAccessConditions: options.conditions, modifiedAccessConditions: options.conditions, cpkInfo: options.customerProvidedKey, proposedLeaseId: options.proposedLeaseId, leaseDuration: options.leaseDurationInSeconds, leaseAction: options.leaseAction })));
        });
    }
    // high level functions
    /**
     * ONLY AVAILABLE IN NODE.JS RUNTIME.
     *
     * Uploads a local file to a Data Lake file.
     *
     * @param filePath - Full path of the local file
     * @param options -
     */
    async uploadFile(filePath, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-uploadFile", options, async (updatedOptions) => {
            const size = (await fsStat(filePath)).size;
            return this.uploadSeekableInternal((offset, contentSize) => {
                return () => fsCreateReadStream(filePath, {
                    autoClose: true,
                    end: offset + contentSize - 1,
                    start: offset,
                });
            }, size, updatedOptions);
        });
    }
    /**
     * Uploads a Buffer(Node.js)/Blob/ArrayBuffer/ArrayBufferView to a File.
     *
     * @param data - Buffer(Node), Blob, ArrayBuffer or ArrayBufferView
     * @param options -
     */
    async upload(data, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-upload", options, async (updatedOptions) => {
            if (coreUtil.isNode) {
                let buffer;
                if (data instanceof Buffer) {
                    buffer = data;
                }
                else if (data instanceof ArrayBuffer) {
                    buffer = Buffer.from(data);
                }
                else {
                    data = data;
                    buffer = Buffer.from(data.buffer, data.byteOffset, data.byteLength);
                }
                return this.uploadSeekableInternal((offset, size) => buffer.slice(offset, offset + size), buffer.length, updatedOptions);
            }
            else {
                const browserBlob = new Blob([data]);
                return this.uploadSeekableInternal((offset, size) => browserBlob.slice(offset, offset + size), browserBlob.size, updatedOptions);
            }
        });
    }
    async uploadSeekableInternal(bodyFactory, size, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-uploadData", options, async (updatedOptions) => {
            var _a;
            if (size > FILE_MAX_SIZE_BYTES) {
                throw new RangeError(`size must be <= ${FILE_MAX_SIZE_BYTES}.`);
            }
            // Create the file.
            const createRes = this.create({
                abortSignal: options.abortSignal,
                metadata: options.metadata,
                permissions: options.permissions,
                umask: options.umask,
                conditions: options.conditions,
                pathHttpHeaders: options.pathHttpHeaders,
                customerProvidedKey: updatedOptions.customerProvidedKey,
                tracingOptions: updatedOptions.tracingOptions,
                encryptionContext: updatedOptions.encryptionContext,
            });
            // append() with empty data would return error, so do not continue
            if (size === 0) {
                return createRes;
            }
            else {
                await createRes;
            }
            // After the File is Create, Lease ID is the only valid request parameter.
            options.conditions = { leaseId: (_a = options.conditions) === null || _a === void 0 ? void 0 : _a.leaseId };
            if (!options.chunkSize) {
                options.chunkSize = Math.ceil(size / BLOCK_BLOB_MAX_BLOCKS);
                if (options.chunkSize < FILE_UPLOAD_DEFAULT_CHUNK_SIZE) {
                    options.chunkSize = FILE_UPLOAD_DEFAULT_CHUNK_SIZE;
                }
            }
            if (options.chunkSize < 1 || options.chunkSize > FILE_UPLOAD_MAX_CHUNK_SIZE) {
                throw new RangeError(`chunkSize option must be >= 1 and <= ${FILE_UPLOAD_MAX_CHUNK_SIZE}`);
            }
            if (!options.maxConcurrency) {
                options.maxConcurrency = DEFAULT_HIGH_LEVEL_CONCURRENCY;
            }
            if (options.maxConcurrency <= 0) {
                throw new RangeError(`maxConcurrency must be > 0.`);
            }
            if (!options.singleUploadThreshold) {
                options.singleUploadThreshold = FILE_MAX_SINGLE_UPLOAD_THRESHOLD;
            }
            if (options.singleUploadThreshold < 1 ||
                options.singleUploadThreshold > FILE_MAX_SINGLE_UPLOAD_THRESHOLD) {
                throw new RangeError(`singleUploadThreshold option must be >= 1 and <= ${FILE_MAX_SINGLE_UPLOAD_THRESHOLD}`);
            }
            // When buffer length <= singleUploadThreshold, this method will use one append/flush call to finish the upload.
            if (size <= options.singleUploadThreshold) {
                await this.append(bodyFactory(0, size), 0, size, {
                    abortSignal: options.abortSignal,
                    conditions: options.conditions,
                    customerProvidedKey: updatedOptions.customerProvidedKey,
                    onProgress: options.onProgress,
                    tracingOptions: updatedOptions.tracingOptions,
                });
                return this.flush(size, {
                    abortSignal: options.abortSignal,
                    conditions: options.conditions,
                    close: options.close,
                    pathHttpHeaders: options.pathHttpHeaders,
                    customerProvidedKey: updatedOptions.customerProvidedKey,
                    tracingOptions: updatedOptions.tracingOptions,
                });
            }
            const numBlocks = Math.floor((size - 1) / options.chunkSize) + 1;
            if (numBlocks > BLOCK_BLOB_MAX_BLOCKS) {
                throw new RangeError(`The data's size is too big or the chunkSize is too small;` +
                    `the number of chunks must be <= ${BLOCK_BLOB_MAX_BLOCKS}`);
            }
            let transferProgress = 0;
            const batch = new Batch(options.maxConcurrency);
            for (let i = 0; i < numBlocks; i++) {
                batch.addOperation(async () => {
                    const start = options.chunkSize * i;
                    const end = i === numBlocks - 1 ? size : start + options.chunkSize;
                    const contentLength = end - start;
                    await this.append(bodyFactory(start, contentLength), start, contentLength, {
                        abortSignal: options.abortSignal,
                        conditions: options.conditions,
                        customerProvidedKey: updatedOptions.customerProvidedKey,
                        tracingOptions: updatedOptions.tracingOptions,
                    });
                    transferProgress += contentLength;
                    if (options.onProgress) {
                        options.onProgress({ loadedBytes: transferProgress });
                    }
                });
            }
            await batch.do();
            return this.flush(size, {
                abortSignal: options.abortSignal,
                conditions: options.conditions,
                close: options.close,
                pathHttpHeaders: options.pathHttpHeaders,
                customerProvidedKey: updatedOptions.customerProvidedKey,
                tracingOptions: updatedOptions.tracingOptions,
            });
        });
    }
    /**
     * ONLY AVAILABLE IN NODE.JS RUNTIME.
     *
     * Uploads a Node.js Readable stream into a Data Lake file.
     * This method will try to create a file, then starts uploading chunk by chunk.
     * Please make sure potential size of stream doesn't exceed FILE_MAX_SIZE_BYTES and
     * potential number of chunks doesn't exceed BLOCK_BLOB_MAX_BLOCKS.
     *
     * PERFORMANCE IMPROVEMENT TIPS:
     * * Input stream highWaterMark is better to set a same value with options.chunkSize
     *   parameter, which will avoid Buffer.concat() operations.
     *
     * @param stream - Node.js Readable stream.
     * @param options -
     */
    async uploadStream(stream, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-uploadStream", options, async (updatedOptions) => {
            var _a;
            // Create the file
            await this.create({
                abortSignal: options.abortSignal,
                metadata: options.metadata,
                permissions: options.permissions,
                umask: options.umask,
                conditions: options.conditions,
                pathHttpHeaders: options.pathHttpHeaders,
                customerProvidedKey: options.customerProvidedKey,
                tracingOptions: updatedOptions.tracingOptions,
                encryptionContext: updatedOptions.encryptionContext,
            });
            // After the File is Create, Lease ID is the only valid request parameter.
            options.conditions = { leaseId: (_a = options.conditions) === null || _a === void 0 ? void 0 : _a.leaseId };
            if (!options.chunkSize) {
                options.chunkSize = FILE_UPLOAD_DEFAULT_CHUNK_SIZE;
            }
            if (options.chunkSize < 1 || options.chunkSize > FILE_UPLOAD_MAX_CHUNK_SIZE) {
                throw new RangeError(`chunkSize option must be >= 1 and <= ${FILE_UPLOAD_MAX_CHUNK_SIZE}`);
            }
            if (!options.maxConcurrency) {
                options.maxConcurrency = DEFAULT_HIGH_LEVEL_CONCURRENCY;
            }
            if (options.maxConcurrency <= 0) {
                throw new RangeError(`maxConcurrency must be > 0.`);
            }
            let transferProgress = 0;
            const scheduler = new BufferScheduler(stream, options.chunkSize, options.maxConcurrency, async (body, length, offset) => {
                await this.append(body, offset, length, {
                    abortSignal: options.abortSignal,
                    conditions: options.conditions,
                    customerProvidedKey: options.customerProvidedKey,
                    tracingOptions: updatedOptions.tracingOptions,
                });
                // Update progress after block is successfully uploaded to server, in case of block trying
                transferProgress += length;
                if (options.onProgress) {
                    options.onProgress({ loadedBytes: transferProgress });
                }
            }, 
            // concurrency should set a smaller value than maxConcurrency, which is helpful to
            // reduce the possibility when a outgoing handler waits for stream data, in
            // this situation, outgoing handlers are blocked.
            // Outgoing queue shouldn't be empty.
            Math.ceil((options.maxConcurrency / 4) * 3));
            await scheduler.do();
            return this.flush(transferProgress, {
                abortSignal: options.abortSignal,
                conditions: options.conditions,
                close: options.close,
                pathHttpHeaders: options.pathHttpHeaders,
                customerProvidedKey: options.customerProvidedKey,
                tracingOptions: updatedOptions.tracingOptions,
            });
        });
    }
    async readToBuffer(bufferOrOffset, offsetOrCount, countOrOptions, optOptions = {}) {
        let buffer = undefined;
        let offset = 0;
        let count = 0;
        let options = optOptions;
        if (bufferOrOffset instanceof Buffer) {
            buffer = bufferOrOffset;
            offset = offsetOrCount || 0;
            count = typeof countOrOptions === "number" ? countOrOptions : 0;
        }
        else {
            offset = typeof bufferOrOffset === "number" ? bufferOrOffset : 0;
            count = typeof offsetOrCount === "number" ? offsetOrCount : 0;
            options = countOrOptions || {};
        }
        return tracingClient.withSpan("DataLakeFileClient-readToBuffer", options, async (updatedOptions) => {
            if (buffer) {
                return this.blockBlobClientInternal.downloadToBuffer(buffer, offset, count, Object.assign(Object.assign({}, options), { maxRetryRequestsPerBlock: options.maxRetryRequestsPerChunk, blockSize: options.chunkSize, customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey), tracingOptions: updatedOptions.tracingOptions }));
            }
            else {
                return this.blockBlobClientInternal.downloadToBuffer(offset, count, Object.assign(Object.assign({}, options), { maxRetryRequestsPerBlock: options.maxRetryRequestsPerChunk, blockSize: options.chunkSize, customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey), tracingOptions: updatedOptions.tracingOptions }));
            }
        });
    }
    /**
     * ONLY AVAILABLE IN NODE.JS RUNTIME.
     *
     * Downloads a Data Lake file to a local file.
     * Fails if the the given file path already exits.
     * Offset and count are optional, pass 0 and undefined respectively to download the entire file.
     *
     * @param filePath -
     * @param offset - From which position of the file to download.
     * @param count - How much data to be downloaded. Will download to the end when passing undefined.
     * @param options - Options to read Data Lake file.
     * @returns The response data for file read operation,
     *                                      but with readableStreamBody set to undefined since its
     *                                      content is already read and written into a local file
     *                                      at the specified path.
     */
    async readToFile(filePath, offset = 0, count, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-readToFile", options, async (updatedOptions) => {
            const rawResposne = await this.blockBlobClientInternal.downloadToFile(filePath, offset, count, Object.assign(Object.assign({}, updatedOptions), { customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey) }));
            const response = ParsePathGetPropertiesExtraHeaderValues(rawResposne);
            return response;
        });
    }
    /**
     * Quick query for a JSON or CSV formatted file.
     *
     * Example usage (Node.js):
     *
     * ```js
     * // Query and convert a file to a string
     * const queryResponse = await fileClient.query("select * from BlobStorage");
     * const downloaded = (await streamToBuffer(queryResponse.readableStreamBody)).toString();
     * console.log("Query file content:", downloaded);
     *
     * async function streamToBuffer(readableStream) {
     *   return new Promise((resolve, reject) => {
     *     const chunks = [];
     *     readableStream.on("data", (data) => {
     *       chunks.push(typeof data === "string" ? Buffer.from(data) : data);
     *     });
     *     readableStream.on("end", () => {
     *       resolve(Buffer.concat(chunks));
     *     });
     *     readableStream.on("error", reject);
     *   });
     * }
     * ```
     *
     * @param query -
     * @param options -
     */
    async query(query, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-query", options, async (updatedOptions) => {
            const rawResponse = await this.blockBlobClientInternal.query(query, Object.assign(Object.assign({}, updatedOptions), { customerProvidedKey: toBlobCpkInfo(options.customerProvidedKey) }));
            const response = rawResponse;
            if (!coreUtil.isNode && !response.contentAsBlob) {
                response.contentAsBlob = rawResponse.blobBody;
            }
            response.fileContentMD5 = rawResponse.blobContentMD5;
            response._response.parsedHeaders.fileContentMD5 =
                rawResponse._response.parsedHeaders.blobContentMD5;
            delete rawResponse.blobContentMD5;
            delete rawResponse._response.parsedHeaders.blobContentMD5;
            return response;
        });
    }
    /**
     * Sets an expiry time on a file, once that time is met the file is deleted.
     *
     * @param mode -
     * @param options -
     */
    async setExpiry(mode, options = {}) {
        return tracingClient.withSpan("DataLakeFileClient-setExpiry", options, async (updatedOptions) => {
            var _a;
            let expiresOn = undefined;
            if (mode === "RelativeToNow" || mode === "RelativeToCreation") {
                if (!options.timeToExpireInMs) {
                    throw new Error(`Should specify options.timeToExpireInMs when using mode ${mode}.`);
                }
                // MINOR: need check against <= 2**64, but JS number has the precision problem.
                expiresOn = Math.round(options.timeToExpireInMs).toString();
            }
            if (mode === "Absolute") {
                if (!options.expiresOn) {
                    throw new Error(`Should specify options.expiresOn when using mode ${mode}.`);
                }
                const now = new Date();
                if (!(options.expiresOn.getTime() > now.getTime())) {
                    throw new Error(`options.expiresOn should be later than now: ${now.toUTCString()} when using mode ${mode}, but is ${(_a = options.expiresOn) === null || _a === void 0 ? void 0 : _a.toUTCString()}`);
                }
                expiresOn = options.expiresOn.toUTCString();
            }
            const adaptedOptions = Object.assign(Object.assign({}, options), { expiresOn });
            return assertResponse(await this.pathContextInternalToBlobEndpoint.setExpiry(mode, Object.assign(Object.assign({}, adaptedOptions), { tracingOptions: updatedOptions.tracingOptions })));
        });
    }
    /**
     * Only available for clients constructed with a shared key credential.
     *
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateSasUrl(options) {
        return new Promise((resolve) => {
            if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
                throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
            }
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name }, options), this.credential).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Only available for clients constructed with a shared key credential.
     *
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options*/
    generateSasStringToSign(options) {
        if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
            throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
        }
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name }, options), this.credential).stringToSign;
    }
    /**
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasUrl(options, userDelegationKey) {
        return new Promise((resolve) => {
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name }, options), userDelegationKey, this.accountName).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasStringToSign(options, userDelegationKey) {
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.fileSystemName, pathName: this.name }, options), userDelegationKey, this.accountName).stringToSign;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * A PathClientInternal represents a URL to the Azure Storage path (directory or file) to
 * help to construct a path client to expose Path context with blob endpoint.
 */
class PathClientInternal extends DataLakePathClient {
    /**
     * Creates an instance of DataLakePathClient from url and pipeline.
     *
     * @param url - A Client string pointing to Azure Storage data lake path (directory or file), such as
     *                     "https://myaccount.dfs.core.windows.net/filesystem/directory" or "https://myaccount.dfs.core.windows.net/filesystem/file".
     *                     You can append a SAS if using AnonymousCredential, such as "https://myaccount.dfs.core.windows.net/filesystem/directory?sasString".
     * @param pipeline - Call newPipeline() to create a default
     *                            pipeline, or provide a customized pipeline.
     */
    constructor(url, pipeline) {
        super(url, pipeline);
        this.blobPathContext = new PathOperationsImpl(this.storageClientContextToBlobEndpoint);
    }
}

/**
 * A DataLakeFileSystemClient represents a URL to the Azure Storage file system
 * allowing you to manipulate its directories and files.
 */
class DataLakeFileSystemClient extends StorageClient {
    constructor(url, credentialOrPipeline, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        if (storageBlob.isPipelineLike(credentialOrPipeline)) {
            super(url, credentialOrPipeline);
        }
        else {
            let credential;
            if (credentialOrPipeline === undefined) {
                credential = new storageBlob.AnonymousCredential();
            }
            else {
                credential = credentialOrPipeline;
            }
            const pipeline = newPipeline(credential, options);
            super(url, pipeline);
        }
        this.fileSystemContext = new FileSystemOperationsImpl(this.storageClientContext);
        this.fileSystemContextToBlobEndpoint = new FileSystemOperationsImpl(this.storageClientContextToBlobEndpoint);
        this.blobContainerClient = new storageBlob.ContainerClient(this.blobEndpointUrl, this.pipeline);
    }
    /**
     * Name of current file system.
     *
     * @readonly
     */
    get name() {
        return this.blobContainerClient.containerName;
    }
    /**
     * Creates a {@link DataLakeDirectoryClient} object under current file system.
     *
     * @param directoryName -
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    getDirectoryClient(directoryName) {
        return new DataLakeDirectoryClient(appendToURLPath(this.url, EscapePath(directoryName)), this.pipeline);
    }
    /**
     * Creates a {@link DataLakeFileClient} object under current file system.
     *
     * @param fileName -
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    getFileClient(fileName) {
        return new DataLakeFileClient(appendToURLPath(this.url, EscapePath(fileName)), this.pipeline);
    }
    /**
     * Get a {@link DataLakeLeaseClient} that manages leases on the file system.
     *
     * @param proposeLeaseId - Optional. Initial proposed lease Id.
     */
    getDataLakeLeaseClient(proposeLeaseId) {
        return new DataLakeLeaseClient(this.blobContainerClient.getBlobLeaseClient(proposeLeaseId));
    }
    /**
     * Creates a new file system under the specified account. If the file system with
     * the same name already exists, the operation fails.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-container
     *
     * @param options - Optional. Options when creating file system.
     */
    async create(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-create", options, async (updatedOptions) => {
            return this.blobContainerClient.create(Object.assign(Object.assign({}, options), { access: toContainerPublicAccessType(options.access), tracingOptions: updatedOptions.tracingOptions, containerEncryptionScope: options.fileSystemEncryptionScope }));
        });
    }
    /**
     * Creates a new file system under the specified account. If the file system with
     * the same name already exists, it is not changed.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-container
     *
     * @param options -
     */
    async createIfNotExists(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-createIfNotExists", options, async (updatedOptions) => {
            return this.blobContainerClient.createIfNotExists(Object.assign(Object.assign({}, options), { access: toContainerPublicAccessType(options.access), containerEncryptionScope: options.fileSystemEncryptionScope, tracingOptions: updatedOptions.tracingOptions }));
        });
    }
    /**
     * Returns true if the File system represented by this client exists; false otherwise.
     *
     * NOTE: use this function with care since an existing file system might be deleted by other clients or
     * applications. Vice versa new file system with the same name might be added by other clients or
     * applications after this function completes.
     *
     * @param options -
     */
    async exists(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-exists", options, async (updatedOptions) => {
            return this.blobContainerClient.exists(updatedOptions);
        });
    }
    /**
     * Delete current file system.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/delete-container
     *
     * @param options - Optional. Options when deleting file system.
     */
    async delete(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-delete", options, async (updatedOptions) => {
            return this.blobContainerClient.delete(Object.assign(Object.assign({}, options), { tracingOptions: updatedOptions.tracingOptions }));
        });
    }
    /**
     * Delete current file system if it exists.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/delete-container
     *
     * @param options -
     */
    async deleteIfExists(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-deleteIfExists", options, async (updatedOptions) => {
            return this.blobContainerClient.deleteIfExists(updatedOptions);
        });
    }
    /**
     * Returns all user-defined metadata and system properties for the specified
     * file system.
     *
     * WARNING: The `metadata` object returned in the response will have its keys in lowercase, even if
     * they originally contained uppercase characters. This differs from the metadata keys returned by
     * the `listFileSystems` method of {@link DataLakeServiceClient} using the `includeMetadata` option, which
     * will retain their original casing.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-container-properties
     *
     * @param options - Optional. Options when getting file system properties.
     */
    async getProperties(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-getProperties", options, async (updatedOptions) => {
            const rawResponse = await this.blobContainerClient.getProperties(Object.assign(Object.assign({}, options), { tracingOptions: updatedOptions.tracingOptions }));
            // Transfer and rename blobPublicAccess to publicAccess
            const response = rawResponse;
            response.publicAccess = toPublicAccessType(rawResponse.blobPublicAccess);
            response._response.parsedHeaders.publicAccess = response.publicAccess;
            delete rawResponse.blobPublicAccess;
            delete rawResponse._response.parsedHeaders.blobPublicAccess;
            return response;
        });
    }
    /**
     * Sets one or more user-defined name-value pairs for the specified file system.
     *
     * If no option provided, or no metadata defined in the parameter, the file system
     * metadata will be removed.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/set-container-metadata
     *
     * @param metadata - Replace existing metadata with this value.
     *                              If no value provided the existing metadata will be removed.
     * @param options - Optional. Options when setting file system metadata.
     */
    async setMetadata(metadata, options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-setMetadata", options, async (updatedOptions) => {
            return this.blobContainerClient.setMetadata(metadata, Object.assign(Object.assign({}, options), { tracingOptions: updatedOptions.tracingOptions }));
        });
    }
    /**
     * Gets the permissions for the specified file system. The permissions indicate
     * whether file system data may be accessed publicly.
     *
     * WARNING: JavaScript Date will potentially lose precision when parsing startsOn and expiresOn strings.
     * For example, new Date("2018-12-31T03:44:23.8827891Z").toISOString() will get "2018-12-31T03:44:23.882Z".
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-container-acl
     *
     * @param options - Optional. Options when getting file system access policy.
     */
    async getAccessPolicy(options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-getAccessPolicy", options, async (updatedOptions) => {
            const rawResponse = await this.blobContainerClient.getAccessPolicy(Object.assign(Object.assign({}, options), { tracingOptions: updatedOptions.tracingOptions }));
            // Transfer and rename blobPublicAccess to publicAccess
            const response = rawResponse;
            response.publicAccess = toPublicAccessType(rawResponse.blobPublicAccess);
            response._response.parsedHeaders.publicAccess = response.publicAccess;
            delete rawResponse.blobPublicAccess;
            delete rawResponse._response.parsedHeaders.blobPublicAccess;
            return response;
        });
    }
    /**
     * Sets the permissions for the specified file system. The permissions indicate
     * whether directories or files in a file system may be accessed publicly.
     *
     * When you set permissions for a file system, the existing permissions are replaced.
     * If no access or containerAcl provided, the existing file system ACL will be
     * removed.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/set-container-acl
     *
     * @param access - Optional. The level of public access to data in the file system.
     * @param fileSystemAcl - Optional. Array of elements each having a unique Id and details of the access policy.
     * @param options - Optional. Options when setting file system access policy.
     */
    async setAccessPolicy(access, fileSystemAcl, options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-setAccessPolicy", options, async (updatedOptions) => {
            return this.blobContainerClient.setAccessPolicy(toContainerPublicAccessType(access), fileSystemAcl, Object.assign(Object.assign({}, options), { tracingOptions: updatedOptions.tracingOptions }));
        });
    }
    /**
     * Returns an async iterable iterator to list all the paths (directories and files)
     * under the specified file system.
     *
     * .byPage() returns an async iterable iterator to list the paths in pages.
     *
     * Example using `for await` syntax:
     *
     * ```js
     * // Get the fileSystemClient before you run these snippets,
     * // Can be obtained from `serviceClient.getFileSystemClient("<your-filesystem-name>");`
     * let i = 1;
     * for await (const path of fileSystemClient.listPaths()) {
     *   console.log(`Path ${i++}: ${path.name}, isDirectory?: ${path.isDirectory}`);
     * }
     * ```
     *
     * Example using `iter.next()`:
     *
     * ```js
     * let i = 1;
     * let iter = fileSystemClient.listPaths();
     * let pathItem = await iter.next();
     * while (!pathItem.done) {
     *   console.log(`Path ${i++}: ${pathItem.value.name}, isDirectory?: ${pathItem.value.isDirectory}`);
     *   pathItem = await iter.next();
     * }
     * ```
     *
     * Example using `byPage()`:
     *
     * ```js
     * // passing optional maxPageSize in the page settings
     * let i = 1;
     * for await (const response of fileSystemClient.listPaths().byPage({ maxPageSize: 20 })) {
     *   for (const path of response.pathItems) {
     *     console.log(`Path ${i++}: ${path.name}, isDirectory?: ${path.isDirectory}`);
     *   }
     * }
     * ```
     *
     * Example using paging with a marker:
     *
     * ```js
     * let i = 1;
     * let iterator = fileSystemClient.listPaths().byPage({ maxPageSize: 2 });
     * let response = (await iterator.next()).value;
     *
     * // Prints 2 path names
     * for (const path of response.pathItems) {
     *   console.log(`Path ${i++}: ${path.name}, isDirectory?: ${path.isDirectory}`);
     * }
     *
     * // Gets next marker
     * let marker = response.continuationToken;
     *
     * // Passing next marker as continuationToken
     *
     * iterator = fileSystemClient.listPaths().byPage({ continuationToken: marker, maxPageSize: 10 });
     * response = (await iterator.next()).value;
     *
     * // Prints 10 path names
     * for (const path of response.pathItems) {
     *   console.log(`Path ${i++}: ${path.name}, isDirectory?: ${path.isDirectory}`);
     * }
     * ```
     *
     * @see https://learn.microsoft.com/rest/api/storageservices/list-blobs
     *
     * @param options - Optional. Options when listing paths.
     */
    listPaths(options = {}) {
        options.path = options.path === "" ? undefined : options.path;
        const iter = this.listItems(options);
        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
            byPage: (settings = {}) => {
                return this.listSegments(settings.continuationToken, Object.assign({ maxResults: settings.maxPageSize }, options));
            },
        };
    }
    listItems() {
        return tslib.__asyncGenerator(this, arguments, function* listItems_1(options = {}) {
            var _a, e_1, _b, _c;
            try {
                for (var _d = true, _e = tslib.__asyncValues(this.listSegments(undefined, options)), _f; _f = yield tslib.__await(_e.next()), _a = _f.done, !_a; _d = true) {
                    _c = _f.value;
                    _d = false;
                    const response = _c;
                    yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(response.pathItems || [])));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = _e.return)) yield tslib.__await(_b.call(_e));
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
    }
    listSegments(continuation_1) {
        return tslib.__asyncGenerator(this, arguments, function* listSegments_1(continuation, options = {}) {
            let response;
            if (!!continuation || continuation === undefined) {
                do {
                    response = yield tslib.__await(this.listPathsSegment(continuation, options));
                    continuation = response.continuation;
                    yield yield tslib.__await(response);
                } while (continuation);
            }
        });
    }
    async listPathsSegment(continuation, options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-listPathsSegment", options, async (updatedOptions) => {
            const rawResponse = await this.fileSystemContext.listPaths(options.recursive || false, Object.assign(Object.assign({ continuation }, updatedOptions), { upn: options.userPrincipalName }));
            const response = rawResponse;
            response.pathItems = [];
            for (const path of rawResponse.paths || []) {
                response.pathItems.push(Object.assign(Object.assign({}, path), { permissions: toPermissions(path.permissions), createdOn: windowsFileTimeTicksToTime(path.creationTime), expiresOn: windowsFileTimeTicksToTime(path.expiryTime) }));
            }
            delete rawResponse.paths;
            return response;
        });
    }
    /**
     * Returns an async iterable iterator to list all the paths (directories and files)
     * under the specified file system.
     *
     * .byPage() returns an async iterable iterator to list the paths in pages.
     *
     * Example using `for await` syntax:
     *
     * ```js
     * // Get the fileSystemClient before you run these snippets,
     * // Can be obtained from `serviceClient.getFileSystemClient("<your-filesystem-name>");`
     * let i = 1;
     * for await (const deletePath of fileSystemClient.listDeletedPaths()) {
     *   console.log(`Path ${i++}: ${deletePath.name}`);
     * }
     * ```
     *
     * Example using `iter.next()`:
     *
     * ```js
     * let i = 1;
     * let iter = fileSystemClient.listDeletedPaths();
     * let deletedPathItem = await iter.next();
     * while (!deletedPathItem.done) {
     *   console.log(`Path ${i++}: ${deletedPathItem.value.name}`);
     *   pathItem = await iter.next();
     * }
     * ```
     *
     * Example using `byPage()`:
     *
     * ```js
     * // passing optional maxPageSize in the page settings
     * let i = 1;
     * for await (const response of fileSystemClient.listDeletedPaths().byPage({ maxPageSize: 20 })) {
     *   for (const deletePath of response.pathItems) {
     *     console.log(`Path ${i++}: ${deletePath.name}`);
     *   }
     * }
     * ```
     *
     * Example using paging with a marker:
     *
     * ```js
     * let i = 1;
     * let iterator = fileSystemClient.listDeletedPaths().byPage({ maxPageSize: 2 });
     * let response = (await iterator.next()).value;
     *
     * // Prints 2 path names
     * for (const path of response.pathItems) {
     *   console.log(`Path ${i++}: ${path.name}}`);
     * }
     *
     * // Gets next marker
     * let marker = response.continuationToken;
     *
     * // Passing next marker as continuationToken
     *
     * iterator = fileSystemClient.listDeletedPaths().byPage({ continuationToken: marker, maxPageSize: 10 });
     * response = (await iterator.next()).value;
     *
     * // Prints 10 path names
     * for (const deletePath of response.deletedPathItems) {
     *   console.log(`Path ${i++}: ${deletePath.name}`);
     * }
     * ```
     *
     * @see https://learn.microsoft.com/rest/api/storageservices/list-blobs
     *
     * @param options - Optional. Options when listing deleted paths.
     */
    listDeletedPaths(options = {}) {
        const iter = this.listDeletedItems(options);
        return {
            next() {
                return iter.next();
            },
            [Symbol.asyncIterator]() {
                return this;
            },
            byPage: (settings = {}) => {
                return this.listDeletedSegments(settings.continuationToken, Object.assign({ maxResults: settings.maxPageSize }, options));
            },
        };
    }
    listDeletedItems() {
        return tslib.__asyncGenerator(this, arguments, function* listDeletedItems_1(options = {}) {
            var _a, e_2, _b, _c;
            try {
                for (var _d = true, _e = tslib.__asyncValues(this.listDeletedSegments(undefined, options)), _f; _f = yield tslib.__await(_e.next()), _a = _f.done, !_a; _d = true) {
                    _c = _f.value;
                    _d = false;
                    const response = _c;
                    yield tslib.__await(yield* tslib.__asyncDelegator(tslib.__asyncValues(response.pathItems || [])));
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (!_d && !_a && (_b = _e.return)) yield tslib.__await(_b.call(_e));
                }
                finally { if (e_2) throw e_2.error; }
            }
        });
    }
    listDeletedSegments(continuation_1) {
        return tslib.__asyncGenerator(this, arguments, function* listDeletedSegments_1(continuation, options = {}) {
            let response;
            if (!!continuation || continuation === undefined) {
                do {
                    response = yield tslib.__await(this.listDeletedPathsSegment(continuation, options));
                    continuation = response.continuation;
                    yield yield tslib.__await(response);
                } while (continuation);
            }
        });
    }
    async listDeletedPathsSegment(continuation, options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-listDeletedPathsSegment", options, async (updatedOptions) => {
            const rawResponse = await this.fileSystemContextToBlobEndpoint.listBlobHierarchySegment(Object.assign(Object.assign({ marker: continuation }, updatedOptions), { prefix: options.prefix === "" ? undefined : options.prefix }));
            const response = rawResponse;
            response.pathItems = [];
            for (const path of rawResponse.segment.blobItems || []) {
                response.pathItems.push({
                    name: path.name,
                    deletionId: path.deletionId,
                    deletedOn: path.properties.deletedTime,
                    remainingRetentionDays: path.properties.remainingRetentionDays,
                });
            }
            if (response.nextMarker) {
                response.continuation = response.nextMarker;
            }
            return response;
        });
    }
    /**
     * Restores a soft deleted path.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/undelete-blob
     *
     * @param deletedPath - Required.  The path of the deleted path.
     *
     * @param deletionId - Required.  The deletion ID associated with the soft deleted path.
     *
     */
    async undeletePath(deletedPath, deletionId, options = {}) {
        return tracingClient.withSpan("DataLakeFileSystemClient-undeletePath", options, async (updatedOptions) => {
            const pathClient = new PathClientInternal(appendToURLPath(this.blobEndpointUrl, EscapePath(deletedPath)), this.pipeline);
            const rawResponse = assertResponse(await pathClient.blobPathContext.undelete(Object.assign(Object.assign({ undeleteSource: "?" + DeletionIdKey + "=" + deletionId }, options), { tracingOptions: updatedOptions.tracingOptions })));
            if (rawResponse.resourceType === PathResultTypeConstants.DirectoryResourceType) {
                return Object.assign({ pathClient: this.getDirectoryClient(deletedPath) }, rawResponse);
            }
            else {
                return Object.assign({ pathClient: this.getFileClient(deletedPath) }, rawResponse);
            }
        });
    }
    /**
     * Only available for DataLakeFileSystemClient constructed with a shared key credential.
     *
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateSasUrl(options) {
        return new Promise((resolve) => {
            if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
                throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
            }
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.name }, options), this.credential).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Only available for DataLakeFileSystemClient constructed with a shared key credential.
     *
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options*/
    generateSasStringToSign(options) {
        if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
            throw RangeError("Can only generate the SAS when the client is initialized with a shared key credential");
        }
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.name }, options), this.credential).stringToSign;
    }
    /**
     * Generates a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasUrl(options, userDelegationKey) {
        return new Promise((resolve) => {
            const sas = generateDataLakeSASQueryParameters(Object.assign({ fileSystemName: this.name }, options), userDelegationKey, this.accountName).toString();
            resolve(appendToURLQuery(this.url, sas));
        });
    }
    /**
     * Generates string to sign for a Service Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the input user delegation key.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-a-service-sas
     *
     * @param options - Optional parameters.
     * @param userDelegationKey - Return value of `blobServiceClient.getUserDelegationKey()`
     * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateUserDelegationSasStringToSign(options, userDelegationKey) {
        return generateDataLakeSASQueryParametersInternal(Object.assign({ fileSystemName: this.name }, options), userDelegationKey, this.accountName).stringToSign;
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * This is a helper class to construct a string representing the permissions granted by an AccountSAS. Setting a value
 * to true means that any SAS which uses these permissions will grant permissions for that operation. Once all the
 * values are set, this should be serialized with toString and set as the permissions field on an
 * {@link AccountSASSignatureValues} object. It is possible to construct the permissions string without this class, but
 * the order of the permissions is particular and this class guarantees correctness.
 */
class AccountSASPermissions {
    constructor() {
        /**
         * Permission to read resources and list queues and tables granted.
         */
        this.read = false;
        /**
         * Permission to write resources granted.
         */
        this.write = false;
        /**
         * Permission to delete blobs and files granted.
         */
        this.delete = false;
        /**
         * Permission to list blob containers, blobs, shares, directories, and files granted.
         */
        this.list = false;
        /**
         * Permission to add messages, table entities, and append to blobs granted.
         */
        this.add = false;
        /**
         * Permission to create blobs and files granted.
         */
        this.create = false;
        /**
         * Permissions to update messages and table entities granted.
         */
        this.update = false;
        /**
         * Permission to get and delete messages granted.
         */
        this.process = false;
    }
    /**
     * Parse initializes the AccountSASPermissions fields from a string.
     *
     * @param permissions -
     */
    static parse(permissions) {
        const accountSASPermissions = new AccountSASPermissions();
        for (const c of permissions) {
            switch (c) {
                case "r":
                    accountSASPermissions.read = true;
                    break;
                case "w":
                    accountSASPermissions.write = true;
                    break;
                case "d":
                    accountSASPermissions.delete = true;
                    break;
                case "l":
                    accountSASPermissions.list = true;
                    break;
                case "a":
                    accountSASPermissions.add = true;
                    break;
                case "c":
                    accountSASPermissions.create = true;
                    break;
                case "u":
                    accountSASPermissions.update = true;
                    break;
                case "p":
                    accountSASPermissions.process = true;
                    break;
                default:
                    throw new RangeError(`Invalid permission character: ${c}`);
            }
        }
        return accountSASPermissions;
    }
    /**
     * Produces the SAS permissions string for an Azure Storage account.
     * Call this method to set AccountSASSignatureValues Permissions field.
     *
     * Using this method will guarantee the resource types are in
     * an order accepted by the service.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-an-account-sas
     *
     */
    toString() {
        // The order of the characters should be as specified here to ensure correctness:
        // https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-an-account-sas
        // Use a string array instead of string concatenating += operator for performance
        const permissions = [];
        if (this.read) {
            permissions.push("r");
        }
        if (this.write) {
            permissions.push("w");
        }
        if (this.delete) {
            permissions.push("d");
        }
        if (this.list) {
            permissions.push("l");
        }
        if (this.add) {
            permissions.push("a");
        }
        if (this.create) {
            permissions.push("c");
        }
        if (this.update) {
            permissions.push("u");
        }
        if (this.process) {
            permissions.push("p");
        }
        return permissions.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * This is a helper class to construct a string representing the resources accessible by an AccountSAS. Setting a value
 * to true means that any SAS which uses these permissions will grant access to that resource type. Once all the
 * values are set, this should be serialized with toString and set as the resources field on an
 * {@link AccountSASSignatureValues} object. It is possible to construct the resources string without this class, but
 * the order of the resources is particular and this class guarantees correctness.
 */
class AccountSASResourceTypes {
    constructor() {
        /**
         * Permission to access service level APIs granted.
         */
        this.service = false;
        /**
         * Permission to access container level APIs (Blob Containers, Tables, Queues, File Shares, File Systems) granted.
         */
        this.container = false;
        /**
         * Permission to access object level APIs (Blobs, Table Entities, Queue Messages, Files, Directories) granted.
         */
        this.object = false;
    }
    /**
     * Creates an {@link AccountSASResourceTypes} from the specified resource types string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid resource type.
     *
     * @param resourceTypes -
     */
    static parse(resourceTypes) {
        const accountSASResourceTypes = new AccountSASResourceTypes();
        for (const c of resourceTypes) {
            switch (c) {
                case "s":
                    accountSASResourceTypes.service = true;
                    break;
                case "c":
                    accountSASResourceTypes.container = true;
                    break;
                case "o":
                    accountSASResourceTypes.object = true;
                    break;
                default:
                    throw new RangeError(`Invalid resource type: ${c}`);
            }
        }
        return accountSASResourceTypes;
    }
    /**
     * Converts the given resource types to a string.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-an-account-sas
     *
     */
    toString() {
        const resourceTypes = [];
        if (this.service) {
            resourceTypes.push("s");
        }
        if (this.container) {
            resourceTypes.push("c");
        }
        if (this.object) {
            resourceTypes.push("o");
        }
        return resourceTypes.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * This is a helper class to construct a string representing the services accessible by an AccountSAS. Setting a value
 * to true means that any SAS which uses these permissions will grant access to that service. Once all the
 * values are set, this should be serialized with toString and set as the services field on an
 * {@link AccountSASSignatureValues} object. It is possible to construct the services string without this class, but
 * the order of the services is particular and this class guarantees correctness.
 */
class AccountSASServices {
    constructor() {
        /**
         * Permission to access blob and data lake resources granted.
         */
        this.blob = false;
        /**
         * Permission to access file resources granted.
         */
        this.file = false;
        /**
         * Permission to access queue resources granted.
         */
        this.queue = false;
        /**
         * Permission to access table resources granted.
         */
        this.table = false;
    }
    /**
     * Creates an {@link AccountSASServices} from the specified services string. This method will throw an
     * Error if it encounters a character that does not correspond to a valid service.
     *
     * @param services -
     */
    static parse(services) {
        const accountSASServices = new AccountSASServices();
        for (const c of services) {
            switch (c) {
                case "b":
                    accountSASServices.blob = true;
                    break;
                case "f":
                    accountSASServices.file = true;
                    break;
                case "q":
                    accountSASServices.queue = true;
                    break;
                case "t":
                    accountSASServices.table = true;
                    break;
                default:
                    throw new RangeError(`Invalid service character: ${c}`);
            }
        }
        return accountSASServices;
    }
    /**
     * Converts the given services to a string.
     *
     */
    toString() {
        const services = [];
        if (this.blob) {
            services.push("b");
        }
        if (this.table) {
            services.push("t");
        }
        if (this.queue) {
            services.push("q");
        }
        if (this.file) {
            services.push("f");
        }
        return services.join("");
    }
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * Generates a {@link SASQueryParameters} object which contains all SAS query parameters needed to make an actual
 * REST request.
 *
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-an-account-sas
 *
 * @param accountSASSignatureValues -
 * @param sharedKeyCredential -
 */
function generateAccountSASQueryParameters(accountSASSignatureValues, sharedKeyCredential) {
    return generateAccountSASQueryParametersInternal(accountSASSignatureValues, sharedKeyCredential)
        .sasQueryParameters;
}
function generateAccountSASQueryParametersInternal(accountSASSignatureValues, sharedKeyCredential) {
    const version = accountSASSignatureValues.version
        ? accountSASSignatureValues.version
        : SERVICE_VERSION;
    const parsedPermissions = AccountSASPermissions.parse(accountSASSignatureValues.permissions.toString());
    const parsedServices = AccountSASServices.parse(accountSASSignatureValues.services).toString();
    const parsedResourceTypes = AccountSASResourceTypes.parse(accountSASSignatureValues.resourceTypes).toString();
    let stringToSign;
    if (version >= "2020-12-06") {
        stringToSign = [
            sharedKeyCredential.accountName,
            parsedPermissions,
            parsedServices,
            parsedResourceTypes,
            accountSASSignatureValues.startsOn
                ? truncatedISO8061Date(accountSASSignatureValues.startsOn, false)
                : "",
            truncatedISO8061Date(accountSASSignatureValues.expiresOn, false),
            accountSASSignatureValues.ipRange ? ipRangeToString(accountSASSignatureValues.ipRange) : "",
            accountSASSignatureValues.protocol ? accountSASSignatureValues.protocol : "",
            version,
            accountSASSignatureValues.encryptionScope ? accountSASSignatureValues.encryptionScope : "", // Reserve for encryption scope
            "", // Account SAS requires an additional newline character
        ].join("\n");
    }
    else {
        stringToSign = [
            sharedKeyCredential.accountName,
            parsedPermissions,
            parsedServices,
            parsedResourceTypes,
            accountSASSignatureValues.startsOn
                ? truncatedISO8061Date(accountSASSignatureValues.startsOn, false)
                : "",
            truncatedISO8061Date(accountSASSignatureValues.expiresOn, false),
            accountSASSignatureValues.ipRange ? ipRangeToString(accountSASSignatureValues.ipRange) : "",
            accountSASSignatureValues.protocol ? accountSASSignatureValues.protocol : "",
            version,
            "", // Account SAS requires an additional newline character
        ].join("\n");
    }
    const signature = sharedKeyCredential.computeHMACSHA256(stringToSign);
    return {
        sasQueryParameters: new SASQueryParameters(version, signature, parsedPermissions.toString(), parsedServices, parsedResourceTypes, accountSASSignatureValues.protocol, accountSASSignatureValues.startsOn, accountSASSignatureValues.expiresOn, accountSASSignatureValues.ipRange, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, accountSASSignatureValues.encryptionScope),
        stringToSign: stringToSign,
    };
}

// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * DataLakeServiceClient allows you to manipulate Azure
 * Data Lake service resources and file systems. The storage account provides
 * the top-level namespace for the Data Lake service.
 */
class DataLakeServiceClient extends StorageClient {
    /**
     *
     * Creates an instance of DataLakeServiceClient from connection string.
     *
     * @param connectionString - Account connection string or a SAS connection string of an Azure storage account.
     *                                  [ Note - Account connection string can only be used in NODE.JS runtime. ]
     *                                  Account connection string example -
     *                                  `DefaultEndpointsProtocol=https;AccountName=myaccount;AccountKey=accountKey;EndpointSuffix=core.windows.net`
     *                                  SAS connection string example -
     *                                  `BlobEndpoint=https://myaccount.blob.core.windows.net/;QueueEndpoint=https://myaccount.queue.core.windows.net/;FileEndpoint=https://myaccount.file.core.windows.net/;TableEndpoint=https://myaccount.table.core.windows.net/;SharedAccessSignature=sasString`
     * @param options - Optional. Options to configure the HTTP pipeline.
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    static fromConnectionString(connectionString, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        options = options || {};
        const extractedCreds = extractConnectionStringParts(connectionString);
        if (extractedCreds.kind === "AccountConnString") {
            if (coreUtil.isNode) {
                const sharedKeyCredential = new storageBlob.StorageSharedKeyCredential(extractedCreds.accountName, extractedCreds.accountKey);
                if (!options.proxyOptions) {
                    options.proxyOptions = coreRestPipeline.getDefaultProxySettings(extractedCreds.proxyUri);
                }
                const pipeline = newPipeline(sharedKeyCredential, options);
                return new DataLakeServiceClient(toDfsEndpointUrl(extractedCreds.url), pipeline);
            }
            else {
                throw new Error("Account connection string is only supported in Node.js environment");
            }
        }
        else if (extractedCreds.kind === "SASConnString") {
            const pipeline = newPipeline(new storageBlob.AnonymousCredential(), options);
            return new DataLakeServiceClient(toDfsEndpointUrl(extractedCreds.url) + "?" + extractedCreds.accountSas, pipeline);
        }
        else {
            throw new Error("Connection string must be either an Account connection string or a SAS connection string");
        }
    }
    constructor(url, credentialOrPipeline, 
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-options */
    options) {
        if (storageBlob.isPipelineLike(credentialOrPipeline)) {
            super(url, credentialOrPipeline);
        }
        else {
            let credential;
            if (credentialOrPipeline === undefined) {
                credential = new storageBlob.AnonymousCredential();
            }
            else {
                credential = credentialOrPipeline;
            }
            const pipeline = newPipeline(credential, options);
            super(url, pipeline);
        }
        // this.serviceContext = new Service(this.storageClientContext);
        this.blobServiceClient = new storageBlob.BlobServiceClient(this.blobEndpointUrl, this.pipeline);
    }
    /**
     * Creates a {@link DataLakeFileSystemClient} object.
     *
     * @param fileSystemName - File system name.
     */
    // Legacy, no way to fix the eslint error without breaking. Disable the rule for this line.
    /* eslint-disable-next-line @azure/azure-sdk/ts-naming-subclients */
    getFileSystemClient(fileSystemName) {
        return new DataLakeFileSystemClient(appendToURLPath(this.url, encodeURIComponent(fileSystemName)), this.pipeline);
    }
    /**
     * ONLY AVAILABLE WHEN USING BEARER TOKEN AUTHENTICATION (TokenCredential).
     *
     * Retrieves a user delegation key for the Data Lake service. This is only a valid operation when using
     * bearer token authentication.
     *
     * @example
     * ```js
     * // Generate user delegation SAS for a file system
     * const userDelegationKey = await dataLakeServiceClient.getUserDelegationKey(startsOn, expiresOn);
     * const fileSystemSAS = generateDataLakeSASQueryParameters({
     *     fileSystemName, // Required
     *     permissions: FileSystemSASPermissions.parse("racwdl"), // Required
     *     startsOn, // Required. Date type
     *     expiresOn, // Optional. Date type
     *     ipRange: { start: "0.0.0.0", end: "255.255.255.255" }, // Optional
     *     protocol: SASProtocol.HttpsAndHttp, // Optional
     *     version: "2018-11-09" // Must greater than or equal to 2018-11-09 to generate user delegation SAS
     *   },
     *   userDelegationKey, // UserDelegationKey
     *   accountName
     * ).toString();
     * ```
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-user-delegation-key
     *
     * @param startsOn - The start time for the user delegation SAS. Must be within 7 days of the current time.
     * @param expiresOn - The end time for the user delegation SAS. Must be within 7 days of the current time.
     * @param options -
     */
    async getUserDelegationKey(startsOn, expiresOn, options = {}) {
        return tracingClient.withSpan("DataLakeServiceClient-getUserDelegationKey", options, async (updatedOptions) => {
            return this.blobServiceClient.getUserDelegationKey(startsOn, expiresOn, updatedOptions);
        });
    }
    /**
     * Returns an async iterable iterator to list all the file systems
     * under the specified account.
     *
     * .byPage() returns an async iterable iterator to list the file systems in pages.
     *
     * Example using `for await` syntax:
     *
     * ```js
     * let i = 1;
     * for await (const fileSystem of serviceClient.listFileSystems()) {
     *   console.log(`FileSystem ${i++}: ${fileSystem.name}`);
     * }
     * ```
     *
     * Example using `iter.next()`:
     *
     * ```js
     * let i = 1;
     * const iter = serviceClient.listFileSystems();
     * let fileSystemItem = await iter.next();
     * while (!fileSystemItem.done) {
     *   console.log(`FileSystem ${i++}: ${fileSystemItem.value.name}`);
     *   fileSystemItem = await iter.next();
     * }
     * ```
     *
     * Example using `byPage()`:
     *
     * ```js
     * // passing optional maxPageSize in the page settings
     * let i = 1;
     * for await (const response of serviceClient.listFileSystems().byPage({ maxPageSize: 20 })) {
     *   if (response.fileSystemItems) {
     *     for (const fileSystem of response.fileSystemItems) {
     *       console.log(`FileSystem ${i++}: ${fileSystem.name}`);
     *     }
     *   }
     * }
     * ```
     *
     * Example using paging with a marker:
     *
     * ```js
     * let i = 1;
     * let iterator = serviceClient.listFileSystems().byPage({ maxPageSize: 2 });
     * let response = (await iterator.next()).value;
     *
     * // Prints 2 file system names
     * if (response.fileSystemItems) {
     *   for (const fileSystem of response.fileSystemItems) {
     *     console.log(`FileSystem ${i++}: ${fileSystem.name}`);
     *   }
     * }
     *
     * // Gets next marker
     * let marker = response.continuationToken;
     * // Passing next marker as continuationToken
     * iterator = serviceClient
     *   .listContainers()
     *   .byPage({ continuationToken: marker, maxPageSize: 10 });
     * response = (await iterator.next()).value;
     *
     * // Prints 10 file system names
     * if (response.fileSystemItems) {
     *   for (const fileSystem of response.fileSystemItems) {
     *      console.log(`FileSystem ${i++}: ${fileSystem.name}`);
     *   }
     * }
     * ```
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/list-containers2
     *
     * @param options -
     */
    listFileSystems(options = {}) {
        return toFileSystemPagedAsyncIterableIterator(this.blobServiceClient.listContainers(options));
    }
    // public async createFileSystem(): Promise<DataLakeFileSystemClient> {
    //   throw Error("NotImplemented");
    // }
    // public async deleteFileSystem(fileSystem: string): Promise<ServiceDeleteFileSystemResponse> {
    //   throw Error("NotImplemented");
    // }
    /**
     * Only available for DataLakeServiceClient constructed with a shared key credential.
     *
     * Generates an account Shared Access Signature (SAS) URI based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-account-sas
     *
     * @param expiresOn - Optional. The time at which the shared access signature becomes invalid. Default to an hour later if not specified.
     * @param permissions - Specifies the list of permissions to be associated with the SAS.
     * @param resourceTypes - Specifies the resource types associated with the shared access signature.
     * @param options - Optional parameters.
     * @returns An account SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateAccountSasUrl(expiresOn, permissions = AccountSASPermissions.parse("r"), resourceTypes = "sco", options = {}) {
        if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
            throw RangeError("Can only generate the account SAS when the client is initialized with a shared key credential");
        }
        if (expiresOn === undefined) {
            const now = new Date();
            expiresOn = new Date(now.getTime() + 3600 * 1000);
        }
        const sas = generateAccountSASQueryParameters(Object.assign({ permissions,
            expiresOn,
            resourceTypes, services: AccountSASServices.parse("b").toString() }, options), this.credential).toString();
        return appendToURLQuery(this.url, sas);
    }
    /**
     * Only available for DataLakeServiceClient constructed with a shared key credential.
     *
     * Generates string to sign for an account Shared Access Signature (SAS) based on the client properties
     * and parameters passed in. The SAS is signed by the shared key credential of the client.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/create-account-sas
     *
     * @param expiresOn - Optional. The time at which the shared access signature becomes invalid. Default to an hour later if not specified.
     * @param permissions - Specifies the list of permissions to be associated with the SAS.
     * @param resourceTypes - Specifies the resource types associated with the shared access signature.
     * @param options - Optional parameters.
     * @returns An account SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
     */
    generateSasStringToSign(expiresOn, permissions = AccountSASPermissions.parse("r"), resourceTypes = "sco", options = {}) {
        if (!(this.credential instanceof storageBlob.StorageSharedKeyCredential)) {
            throw RangeError("Can only generate the account SAS when the client is initialized with a shared key credential");
        }
        if (expiresOn === undefined) {
            const now = new Date();
            expiresOn = new Date(now.getTime() + 3600 * 1000);
        }
        return generateAccountSASQueryParametersInternal(Object.assign({ permissions,
            expiresOn,
            resourceTypes, services: AccountSASServices.parse("b").toString() }, options), this.credential).stringToSign;
    }
    /**
     * Renames an existing File System.
     *
     * @param sourceFileSystemName - The name of the source File System.
     * @param destinationContainerName - The new name of the File System.
     * @param options - Options to configure File System Rename operation.
     */
    /* eslint-disable-next-line @typescript-eslint/ban-ts-comment */
    // @ts-ignore Need to hide this interface for now. Make it public and turn on the live tests for it when the service is ready.
    async renameFileSystem(sourceFileSystemName, destinationFileSystemName, options = {}) {
        return tracingClient.withSpan("DataLakeServiceClient-renameFileSystem", options, async (updatedOptions) => {
            const res = await this.blobServiceClient["renameContainer"](sourceFileSystemName, destinationFileSystemName, updatedOptions);
            const fileSystemClient = this.getFileSystemClient(destinationFileSystemName);
            return {
                fileSystemClient,
                fileSystemRenameResponse: res.containerRenameResponse,
            };
        });
    }
    /**
     * Restore a previously deleted File System.
     * This API is only functional if Container Soft Delete is enabled for the storage account.
     *
     * @param deletedFileSystemName - The name of the source File System.
     * @param deleteFileSystemVersion - The new name of the File System.
     * @param options - Options to configure File System Restore operation.
     */
    async undeleteFileSystem(deletedFileSystemName, deleteFileSystemVersion, options = {}) {
        return tracingClient.withSpan("DataLakeServiceClient-undeleteFileSystem", options, async (updatedOptions) => {
            const res = await this.blobServiceClient.undeleteContainer(deletedFileSystemName, deleteFileSystemVersion, Object.assign(Object.assign({}, options), { destinationContainerName: options.destinationFileSystemName, tracingOptions: updatedOptions.tracingOptions }));
            const fileSystemClient = this.getFileSystemClient(options.destinationFileSystemName || deletedFileSystemName);
            return {
                fileSystemClient,
                fileSystemUndeleteResponse: res.containerUndeleteResponse,
            };
        });
    }
    /**
     * Gets the properties of a storage account’s Blob service endpoint, including properties
     * for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/get-blob-service-properties
     *
     * @param options - Options to the Service Get Properties operation.
     * @returns Response data for the Service Get Properties operation.
     */
    async getProperties(options = {}) {
        return tracingClient.withSpan("DataLakeServiceClient-getProperties", options, async (updatedOptions) => {
            return this.blobServiceClient.getProperties({
                abortSignal: options.abortSignal,
                tracingOptions: updatedOptions.tracingOptions,
            });
        });
    }
    /**
     * Sets properties for a storage account’s Blob service endpoint, including properties
     * for Storage Analytics, CORS (Cross-Origin Resource Sharing) rules and soft delete settings.
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/set-blob-service-properties
     *
     * @param properties -
     * @param options - Options to the Service Set Properties operation.
     * @returns Response data for the Service Set Properties operation.
     */
    async setProperties(properties, options = {}) {
        return tracingClient.withSpan("DataLakeServiceClient-setProperties", options, async (updatedOptions) => {
            return this.blobServiceClient.setProperties(properties, {
                abortSignal: options.abortSignal,
                tracingOptions: updatedOptions.tracingOptions,
            });
        });
    }
}

// Keeping these for backward compatibility when we changed to use string unions.
/**
 * Defines values for PathGetPropertiesAction.
 * Possible values include: 'getAccessControl', 'getStatus'
 * @readonly
 */
exports.PathGetPropertiesAction = void 0;
(function (PathGetPropertiesAction) {
    PathGetPropertiesAction["GetAccessControl"] = "getAccessControl";
    PathGetPropertiesAction["GetStatus"] = "getStatus";
})(exports.PathGetPropertiesAction || (exports.PathGetPropertiesAction = {}));
/**
 * Defines values for PathRenameMode.
 * Possible values include: 'legacy', 'posix'
 * @readonly
 */
exports.PathRenameMode = void 0;
(function (PathRenameMode) {
    PathRenameMode["Legacy"] = "legacy";
    PathRenameMode["Posix"] = "posix";
})(exports.PathRenameMode || (exports.PathRenameMode = {}));
/**
 * Defines values for PathResourceType.
 * Possible values include: 'directory', 'file'
 * @readonly
 */
exports.PathResourceType = void 0;
(function (PathResourceType) {
    PathResourceType["Directory"] = "directory";
    PathResourceType["File"] = "file";
})(exports.PathResourceType || (exports.PathResourceType = {}));
/**
 * Defines the known cloud audiences for Storage.
 */
exports.StorageDataLakeAudience = void 0;
(function (StorageDataLakeAudience) {
    /**
     * The OAuth scope to use to retrieve an AAD token for Azure Storage.
     */
    StorageDataLakeAudience["StorageOAuthScopes"] = "https://storage.azure.com/.default";
})(exports.StorageDataLakeAudience || (exports.StorageDataLakeAudience = {}));
/**
 * To get OAuth audience for a storage account for datalake service.
 */
function getDataLakeServiceAccountAudience(storageAccountName) {
    return `https://${storageAccountName}.dfs.core.windows.net/.default`;
}
/** *********************************************************/
/** DataLakeLeaseClient option and response related models */
/** *********************************************************/

Object.defineProperty(exports, "RestError", {
    enumerable: true,
    get: function () { return coreRestPipeline.RestError; }
});
Object.defineProperty(exports, "AnonymousCredential", {
    enumerable: true,
    get: function () { return storageBlob.AnonymousCredential; }
});
Object.defineProperty(exports, "AnonymousCredentialPolicy", {
    enumerable: true,
    get: function () { return storageBlob.AnonymousCredentialPolicy; }
});
Object.defineProperty(exports, "BaseRequestPolicy", {
    enumerable: true,
    get: function () { return storageBlob.BaseRequestPolicy; }
});
Object.defineProperty(exports, "Credential", {
    enumerable: true,
    get: function () { return storageBlob.Credential; }
});
Object.defineProperty(exports, "CredentialPolicy", {
    enumerable: true,
    get: function () { return storageBlob.CredentialPolicy; }
});
Object.defineProperty(exports, "Pipeline", {
    enumerable: true,
    get: function () { return storageBlob.Pipeline; }
});
Object.defineProperty(exports, "StorageBrowserPolicy", {
    enumerable: true,
    get: function () { return storageBlob.StorageBrowserPolicy; }
});
Object.defineProperty(exports, "StorageBrowserPolicyFactory", {
    enumerable: true,
    get: function () { return storageBlob.StorageBrowserPolicyFactory; }
});
Object.defineProperty(exports, "StorageRetryPolicy", {
    enumerable: true,
    get: function () { return storageBlob.StorageRetryPolicy; }
});
Object.defineProperty(exports, "StorageRetryPolicyFactory", {
    enumerable: true,
    get: function () { return storageBlob.StorageRetryPolicyFactory; }
});
Object.defineProperty(exports, "StorageRetryPolicyType", {
    enumerable: true,
    get: function () { return storageBlob.StorageRetryPolicyType; }
});
Object.defineProperty(exports, "StorageSharedKeyCredential", {
    enumerable: true,
    get: function () { return storageBlob.StorageSharedKeyCredential; }
});
Object.defineProperty(exports, "StorageSharedKeyCredentialPolicy", {
    enumerable: true,
    get: function () { return storageBlob.StorageSharedKeyCredentialPolicy; }
});
Object.defineProperty(exports, "isPipelineLike", {
    enumerable: true,
    get: function () { return storageBlob.isPipelineLike; }
});
exports.AccountSASPermissions = AccountSASPermissions;
exports.AccountSASResourceTypes = AccountSASResourceTypes;
exports.AccountSASServices = AccountSASServices;
exports.DataLakeAclChangeFailedError = DataLakeAclChangeFailedError;
exports.DataLakeDirectoryClient = DataLakeDirectoryClient;
exports.DataLakeFileClient = DataLakeFileClient;
exports.DataLakeFileSystemClient = DataLakeFileSystemClient;
exports.DataLakeLeaseClient = DataLakeLeaseClient;
exports.DataLakePathClient = DataLakePathClient;
exports.DataLakeSASPermissions = DataLakeSASPermissions;
exports.DataLakeServiceClient = DataLakeServiceClient;
exports.DirectorySASPermissions = DirectorySASPermissions;
exports.FileSystemSASPermissions = FileSystemSASPermissions;
exports.SASQueryParameters = SASQueryParameters;
exports.StorageOAuthScopes = StorageOAuthScopes;
exports.ToBlobEndpointHostMappings = ToBlobEndpointHostMappings;
exports.ToDfsEndpointHostMappings = ToDfsEndpointHostMappings;
exports.generateAccountSASQueryParameters = generateAccountSASQueryParameters;
exports.generateDataLakeSASQueryParameters = generateDataLakeSASQueryParameters;
exports.getDataLakeServiceAccountAudience = getDataLakeServiceAccountAudience;
exports.logger = logger;
exports.newPipeline = newPipeline;
//# sourceMappingURL=index.js.map
